<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="Portal.Stylesheet.Name">pda</xsl:variable>
	<xsl:include href="LayoutSettings.xsl"/>
	<!-- This is the Branding Area Template -->
	<xsl:template match="*|/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="text()|@*">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="Gadget[@top=&apos;y&apos;]">
		<html>
			<head>
				<title>
					<xsl:value-of select="@title"/>
				</title>
				<!--<link href="{$Portal.ResourcePath}/stylesheets/npsadmin.css" rel="stylesheet"/> -->
				<xsl:copy-of select="$Portal.Layout.CSS"/>
			</head>
			<xsl:choose>
				<xsl:when test="@container=&apos;y&apos;and @top=&apos;y&apos;">
					<body xsl:use-attribute-sets="Portal.Layout.Attributes">
						<xsl:call-template name="Portal.BrandingArea.Layout"/>
					</body>
				</xsl:when>
				<xsl:otherwise>
					<body>
						<table border="0" cellpadding="0" cellspacing="0" width="100%">
							<tr valign="top">
								<td width="100%">
									<xsl:apply-templates select="*[last()]"/>
								</td>
							</tr>
						</table>
					</body>
				</xsl:otherwise>
			</xsl:choose>
		</html>
	</xsl:template>
	<!--
	This template constructs a HTML table for
	the Branding Area.  Modify it as needed.

	1. Build a header
	2. Build the columns
	3. Build the footer

	This template allows number of columns to
	be determined dynamically based on the
	setting given in the directory.  This can
	be overridden if desired.
-->
	<xsl:template name="Portal.BrandingArea.Layout">
		<!-- Start the table for the Branding Area-->
		<table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
			<!-- Build the Header -->
			<xsl:call-template name="Portal.BrandingArea.Layout.Header"/>
			<!-- Build the Columns (Dynamically) -->
			<xsl:choose>
				<xsl:when test="@scheme=&apos;3 Column&apos;">
					<!-- The desired scheme type is "3 Column". -->
					<xsl:call-template name="Portal.BrandingArea.Layout.3Column"/>
				</xsl:when>
				<xsl:when test="@scheme=&apos;2 Column&apos;">
					<!-- The desired scheme type is "2 Column". -->
					<xsl:call-template name="Portal.BrandingArea.Layout.2Column"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- Default: The desired scheme type is "1 Column". -->
					<xsl:call-template name="Portal.BrandingArea.Layout.1Column"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- Build the Footer -->
			<xsl:call-template name="Portal.BrandingArea.Layout.Footer"/>
		</table>
	</xsl:template>
	<!--
	This template constructs a HTML table for
	the Inheritable Area.  Modify it as needed.

	1. Build a header
	2. Build the columns
	3. Build the footer

	This template allows number of columns to
	be determined dynamically based on the
	setting given in the directory.  This can
	be overridden if desired.
-->
	<xsl:template name="Portal.InheritableArea.Layout">
		<!-- Start the table for the Inheritable Area -->
		<xsl:choose>
			<xsl:when test="@scheme=&apos;Paged&apos;">
				<xsl:call-template name="Portal.InheritableArea.Layout.Paged"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Portal.InheritableArea.Layout.NotPaged"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Selection on Top -->
	<xsl:template name="Portal.InheritableArea.Layout.Paged">
		<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
			<xsl:attribute name="bgcolor">
				<xsl:value-of select="$Portal.InheritableArea.Color.Background"/>
			</xsl:attribute>
			<!-- Insert the tabs across the top. -->
			<tr align="left" valign="top">
				<td colspan="25" nowrap="true" width="100%">
					<xsl:call-template name="Portal.InheritableArea.ObjectSchemeDropdownSelect"/>
				</td>
			</tr>
			<tr align="center" valign="top">
				<td align="left" width="100%">
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<!-- Force all gadgets into one column. -->
						<xsl:call-template name="Portal.InheritableArea.Layout.PDA"/>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.ObjectSchemeDropdownSelect">
		<select name="maxWnd" onchange="location=&apos;{$Portal.Servlet.Normal}GI_ID={@id}&amp;maxWnd=&apos;+this.options[this.selectedIndex].value;">
			<!-- Show the current object scheme as the first option listed. -->
			<option value="{*/Gadget[@state=&apos;max&apos;]/@id}">
				<xsl:value-of select="*/Gadget[@state=&apos;max&apos;]/@title"/>
			</option>
			<xsl:for-each select="*/Gadget[@container=&apos;y&apos; and @state != &apos;max&apos;]">
				<xsl:sort data-type="number" order="ascending" select="@priority"/>
				<xsl:sort order="ascending" select="@title"/>
				<option value="{@id}">
					<xsl:value-of select="@title"/>
				</option>
			</xsl:for-each>
		</select>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.PDA">
		<xsl:if test="*/Gadget">
			<tr valign="top">
				<td colspan="25">
					<!-- Column 1 -->
					<xsl:apply-templates select="*/Gadget">
						<xsl:with-param name="Position" select="&apos;PDA&apos;"/>
						<xsl:sort data-type="number" order="ascending" select="@priority"/>
						<xsl:sort order="ascending" select="@title"/>
					</xsl:apply-templates>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.PDA">
		<!-- 	This template for the PDA is different
			than the normal stylesheets, so it has
			been customized to display only the
			current maximized gadget and show the
			rest in the drop-down selection tool.	-->
		<!--	Draw the selection tool for the
			minimized gadgets first.				-->
		<xsl:if test="*/Gadget[@state != &apos;max&apos;]">
			<tr>
				<td>
					<select name="maxWnd" onchange="location=&apos;{$Portal.Servlet.Normal}GI_ID={@id}&amp;maxWnd=&apos;+this.options[this.selectedIndex].value;">
						<!--	Display by default a message
							to let them know that they can
							switch to another gadget.  When
							they press the "Go" button with
							this option displayed, it will
							just return to the same gadget
							that is already displayed.		-->
						<option value="{*/Gadget[@state=&apos;max&apos;]/@id}">
							<xsl:value-of select="*/Gadget[@state=&apos;max&apos;]/@title"/>
						</option>
						<!--	Now for each gadget that is not
							maximized (currently showing),
							list it as an option.			-->
						<xsl:for-each select="*/Gadget[@state != &apos;max&apos;]">
							<option value="{@id}">
								<xsl:value-of select="@title"/>
							</option>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</xsl:if>
		<!--	Now draw the maximized gadget.			-->
		<xsl:if test="*/Gadget[@state=&apos;max&apos;]">
			<tr>
				<td colspan="25">
					<!-- Column 1 (One and only column) -->
					<!-- 	We're calling each layout section
						to ensure each one gets called.		-->
					<xsl:apply-templates select="*/Gadget[@state=&apos;max&apos;]">
						<xsl:with-param name="Position" select="&apos;PDA&apos;"/>
						<xsl:sort data-type="number" order="ascending" select="@priority"/>
						<xsl:sort order="ascending" select="@title"/>
					</xsl:apply-templates>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Generic.Tabs.Inline">
		<table bgcolor="{$Portal.Layout.Color.Background}" border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr align="left">
				<xsl:for-each select="*/Gadget[@container=&apos;y&apos;]">
					<xsl:sort data-type="number" order="ascending" select="@priority"/>
					<xsl:choose>
						<xsl:when test="@state=&apos;max&apos;">
							<!-- Show the active Tab. -->
							<td align="center" bgcolor="{$Portal.ObjectScheme.Select.Active.Color.Background}" width="10%">
								<font color="{$Portal.ObjectScheme.Select.Active.Color.Foreground}">
									<b>
										<xsl:value-of select="@title"/>
									</b>
								</font>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<!-- Show the inactive tabs. -->
							<td align="center" bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}" width="10%">
								<font color="{$Portal.ObjectScheme.Select.Inactive.Color.Foreground}">
									<a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;maxWnd={@id}">
										<xsl:value-of select="@title"/>
									</a>
								</font>
							</td>
						</xsl:otherwise>
					</xsl:choose>
					<td width="2%">
						<!-- This adds a little bit of space between each tab. -->
					</td>
				</xsl:for-each>
				<td align="right" width="98%">
					<!--
					Insert anything here that you would
					like to appear on the right-hand side
					of the tabs.
				-->
				</td>
			</tr>
			<tr align="center">
				<!-- Add a line below the tabs. -->
				<td bgcolor="{$Portal.ObjectScheme.Select.Active.Color.Background}" colspan="25" height="3" width="100%"/>
			</tr>
			<tr align="center">
				<td bgcolor="{$Portal.ObjectScheme.Color.Background}" colspan="25" height="6" width="100%"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Portal.Generic.Tabs.Stacked">
		<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
			<xsl:for-each select="*/Gadget[@container=&apos;y&apos;]">
				<xsl:sort data-type="number" order="ascending" select="@priority"/>
				<tr>
					<xsl:choose>
						<xsl:when test="@state=&apos;max&apos;">
							<!-- Draw the Active Tab -->
							<td bgcolor="{$Portal.ObjectScheme.Select.Active.Color.Background}">
								<font color="{$Portal.ObjectScheme.Select.Active.Color.Foreground}">
									<b>
										<xsl:value-of select="@title"/>
									</b>
								</font>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<!-- Draw an Inactive Tab -->
							<td align="center" bgcolor="{$Portal.ObjectScheme.Select.Inactive.Color.Background}">
								<font color="{$Portal.ObjectScheme.Select.Inactive.Color.Foreground}">
									<a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;maxWnd={@id}">
										<xsl:value-of select="@title"/>
									</a>
								</font>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
			<tr>
				<td height="100%"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.NotPaged">
		<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
			<!-- Build the Header -->
			<xsl:call-template name="Portal.InheritableArea.Layout.Header"/>
			<!-- Build the Columns (Dynamically) -->
			<xsl:choose>
				<xsl:when test="@scheme=&apos;3 Column&apos;">
					<!-- The desired scheme type is "3 Column". -->
					<xsl:call-template name="Portal.InheritableArea.Layout.3Column"/>
				</xsl:when>
				<xsl:when test="@scheme=&apos;2 Column&apos;">
					<!-- The desired scheme type is "2 Column". -->
					<xsl:call-template name="Portal.InheritableArea.Layout.2Column"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- Default: The desired scheme type is "1 Column". -->
					<xsl:call-template name="Portal.InheritableArea.Layout.1Column"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- Build the Footer -->
			<xsl:call-template name="Portal.InheritableArea.Layout.Footer"/>
		</table>
	</xsl:template>
	<!--
	This template constructs a HTML table for
	an Object Scheme.  Modify it as needed.

	1. Build a header
	2. Build the columns
	3. Build the footer

	This template allows number of columns to
	be determined dynamically based on the
	setting given in the directory.  This can
	be overridden if desired.
-->
	<xsl:template name="Portal.ObjectScheme.Layout">
		<!-- Start the table for the Object Scheme -->
		<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
			<!-- Build the Header -->
			<xsl:call-template name="Portal.ObjectScheme.Layout.Header"/>
			<!-- Build the Columns (Dynamically) -->
			<xsl:choose>
				<xsl:when test="@scheme=&apos;3 Column&apos;">
					<!-- The desired scheme type is "3 Column". -->
					<xsl:call-template name="Portal.ObjectScheme.Layout.3Column"/>
				</xsl:when>
				<xsl:when test="@scheme=&apos;2 Column&apos;">
					<!-- The desired scheme type is "2 Column". -->
					<xsl:call-template name="Portal.ObjectScheme.Layout.2Column"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- Default: The desired scheme type is "1 Column". -->
					<xsl:call-template name="Portal.ObjectScheme.Layout.1Column"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- Build the Footer -->
			<xsl:call-template name="Portal.ObjectScheme.Layout.Footer"/>
		</table>
	</xsl:template>
	<!--
	This template handles drawing each invidual
	Gadget window and calls the XSL Stylesheet
	Specified by the Gadget.
-->
	<xsl:template name="Portal.Gadget">
		<table border="0" cellpadding="0" cellspacing="0" width="95%">
			<!--		<xsl:if test="@hasframe='y'">-->
			<!--
				Draw a window frame for the gadget
				that includes the Gadget's title and
				any other icons to control it.
			-->
			<!--			<xsl:call-template name="Portal.Gadget.TitleBar"/>-->
			<!--		</xsl:if>-->
			<tr>
				<td>
					<!--
					Call the Gadget's Template, which is
					the last XML tag in the <Gadget> tag.
				-->
					<xsl:apply-templates select="*[last()]"/>
				</td>
			</tr>
		</table>
		<!-- Make spacing here! -->
		<xsl:if test="../../@top=&apos;n&apos;">
			<table border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td height="5">
						<!-- Specify spacing height in pixels -->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Gadget.TitleBar">
		<tr valign="middle">
			<td colspan="25" xsl:use-attribute-sets="Portal.Gadget.TitleBar.Attributes">
				<xsl:call-template name="Portal.Gadget.TitleBar.SystemIcons"/>
				<xsl:call-template name="Portal.Gadget.TitleBar.GadgetIcons"/>
				<font xsl:use-attribute-sets="Portal.Gadget.TitleBar.Font.Attributes">
					<b>
						<xsl:value-of select="@title"/>
					</b>
				</font>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Portal.Gadget.TitleBar.SystemIcons">
		<xsl:if test="@allowClose[.=&apos;y&apos;]">
			<a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;remWnd={@id}">
				<img align="right" alt="{$com.novell.nps.skins.default.pda.RemoveImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/images/remove.gif"/>
			</a>
		</xsl:if>
		<!--
	<xsl:if test="@custom">
		<a>
			<xsl:attribute name="href"><xsl:value-of select="@custom"/></xsl:attribute>
			<img border="0" align="right" src="&ResourcePath;/stylesheets/images/personalize.gif" ALT="{$com.novell.nps.skins.default.pda.PersonalizeImageAltText}"/>
		</a>
	</xsl:if>
-->
		<xsl:if test="@NPConfig">
			<a href="{$Portal.Servlet.FullPage}GI_ID={@id}&amp;NPAction=Configurable&amp;FULLPAGE=branding">
				<img ALT="{$com.novell.nps.skins.default.pda.PersonalizeImageAltText}" align="right" border="0" src="{$Portal.ResourcePath}/stylesheets/images/personalize.gif"/>
			</a>
		</xsl:if>
		<xsl:if test="@NPHelp">
			<a TARGET="Help" href="{@NPHelp}">
				<img ALT="{$com.novell.nps.skins.default.pda.HelpImageAltText}" align="right" border="0" src="{$Portal.ResourcePath}/stylesheets/images/help.gif"/>
			</a>
		</xsl:if>
		<xsl:if test="@ssGad">
			<a href="{$Portal.Servlet.Normal}GI_ID={@id}&amp;NPAction=ResetGadgetSS">
				<img ALT="{$com.novell.nps.skins.default.pda.ResetSecretStoreImageAltText}" align="right" border="0" src="{$Portal.ResourcePath}/stylesheets/images/reset_ss.gif"/>
			</a>
		</xsl:if>
		<!-- This is removed for now.
	<IMG BORDER="0" ALIGN="right" SRC="&ResourcePath;/stylesheets/images/pin.gif"/>-->
		<xsl:if test="@state=&apos;max&apos;">
			<a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;minWnd={@id}">
				<img align="right" alt="{$com.novell.nps.skins.default.pda.MinimizeImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/images/minimize.gif"/>
			</a>
		</xsl:if>
		<xsl:if test="@state=&apos;min&apos;">
			<a href="{$Portal.Servlet.Normal}GI_ID={../../@id}&amp;maxWnd={@id}">
				<img align="right" alt="{$com.novell.nps.skins.default.pda.MaximizeImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/images/maximize.gif"/>
			</a>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Gadget.TitleBar.GadgetIcons">
		<!-- GadgetInstanceActionIcons -->
		<xsl:for-each select="Icons/Icon">
			<xsl:sort data-type="number" order="ascending" select="@priority"/>
			<xsl:sort data-type="text" order="ascending" select="@name"/>
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="$Portal.Servlet.Normal"/>GI_ID=<xsl:value-of select="../../@id"/>
					<xsl:for-each select="actions/action">&amp;<xsl:value-of select="@name"/>=<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:attribute>
				<img align="right" alt="{@name}" border="0" src="{@href}"/>
			</a>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Layout.Header">
		<tr align="left" valign="top">
			<td bgcolor="#DDDDDD" colspan="25" width="100%">
				<!--				<table align="left" border="0" cellpadding="0" cellspacing="0" height="59" width="100%" background="&ResourcePath;/stylesheets/skins/default/devices/pda/images/nback.gif" style="background-repeat:no-repeat;">-->
				<table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr valign="top">
						<xsl:choose>
							<xsl:when test="/PortalData/SessionInfo/AuthInfo/State/text()=&apos;StateLoggedIn&apos;">
								<td nowrap="true" width="1">
									<table align="center" border="0" cellpadding="0" cellspacing="0" width="1">
										<tr>
											<td align="center" nowrap="true" width="1">
												<font color="#663000" face="Trebuchet MS" size="-1"> <xsl:value-of select="$com.novell.nps.skins.default.pda.UsernamePromptText"/>
												</font>
											</td>
										</tr>
										<tr>
											<td align="center" nowrap="true" width="1">
												<font face="Trebuchet MS" size="-1">  <xsl:value-of select="/PortalData/SessionInfo/User/CN"/>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td nowrap="true">        </td>
							</xsl:otherwise>
						</xsl:choose>
						<td align="left" nowrap="true" valign="top" width="*">
							<img alt="Novell" src="{$Portal.ResourcePath}/stylesheets/skins/default/devices/pda/images/Novellogo.gif"/>
							<!--							<img src="&ResourcePath;/stylesheets/skins/default/devices/pda/images/nps_black.gif" width="219" height="22" alt=""/>-->
							<!--
						</td>
						<td align="left" valign="top" width="99%" bgcolor="yellow">
-->
							<xsl:if test="/PortalData/SessionInfo/AuthInfo/State/text()=&apos;StateLoggedIn&apos;">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="$Portal.Servlet.Normal"/>NPService=AuthenticationService&amp;logoutButton=Logout&amp;NPServiceDataType=PortalData</xsl:attribute>
									<img alt="{$com.novell.nps.skins.default.pda.LogoutImageAltText}" border="0" src="{$Portal.ResourcePath}/stylesheets/skins/default/devices/pda/images/But_Logout1.gif"/>
								</a>
							</xsl:if>
						</td>
					</tr>
					<!--
					<xsl:if test="/PortalData/SessionInfo/AuthInfo/State/text()='StateLoggedIn'">
						<tr valign="top">
							<td align="left" nowrap="true" width="100%">
								<font size="-1" face="Trebuchet MS">&#160;&#160;<font color="#663000">Username: </font><xsl:value-of select="/PortalData/SessionInfo/User/CN"/></font>
							</td>
						</tr>
					</xsl:if>
-->
				</table>
				<!--
				<table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr valign="top">
						<td align="left" valign="top" width="1%">
							<table align="left" border="0" cellpadding="0" cellspacing="0" width="1%">
								<tr valign="top">
									<td align="left" valign="top" height="1%">
										<img src="&ResourcePath;/stylesheets/skins/default/devices/pda/images/nps_black.gif" width="219" height="22"/>
									</td>
								</tr>
								<xsl:if test="/PortalData/SessionInfo/AuthInfo/State/text()='StateLoggedIn'">
									<tr><td><img src="&ResourcePath;/stylesheets/images/pixel.gif" height="7"/></td></tr>
									<tr valign="bottom">
										<td align="left" valign="bottom" height="99%" nowrap="true">
											<font size="-1" face="Trebuchet MS">&#160;&#160;<font color="#663000">Username: </font><xsl:value-of select="/PortalData/SessionInfo/User/CN"/></font>
											<form method="POST">
												<xsl:attribute name="action">&ServletPath;?NPService=AuthenticationService&amp;logoutButton=Logout&amp;NPServiceDataType=PortalData</xsl:attribute>
												<input type="image" src="&ResourcePath;/stylesheets/skins/default/devices/pda/images/But_Logout1.gif"/>
											</form>
										</td>
									</tr>
								</xsl:if>
							</table>
						</td>
-->
				<!-- draws the gadgets assigned to the Branding Area -->
				<!--
						<xsl:for-each select="*/Gadget[@position='Header']">
							<xsl:sort select="@priority" data-type="number" order="ascending"/>
							<xsl:sort select="@title" order="ascending"/>
							<td align="left" valign="bottom" width="1%">
								<xsl:choose>
									<xsl:when test="com.novell.nps.authentication.Authenticator and /PortalData/SessionInfo/AuthInfo/State/text()='StateLoggedIn'">
-->
				<!--	Do nothing here.  Just prevent the normal
												Authenticator gadget's stylesheet from being
												called!											-->
				<!--
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="*[last()]">
											<xsl:with-param name="Position" select="Header"/>
										</xsl:apply-templates>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</xsl:for-each>
-->
				<!--
						<td align="left" valign="top" width="1%" nowrap="false">
							<img src="&ResourcePath;/stylesheets/images/pixel.gif" height="15"/>
							<img src="&ResourcePath;/stylesheets/skins/default/devices/pda/images/Novellogo.gif" width="100" height="22"/>
						</td>
-->
				<!--
					</tr>
				</table>
-->
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Layout.1Column">
		<xsl:call-template name="Portal.Generic.1Column"/>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Layout.2Column">
		<xsl:call-template name="Portal.Generic.2Column"/>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Layout.3Column">
		<xsl:call-template name="Portal.Generic.3Column"/>
	</xsl:template>
	<xsl:template name="Portal.BrandingArea.Layout.Footer">
		<xsl:call-template name="Portal.Generic.Footer"/>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.Header">
		<xsl:call-template name="Portal.Generic.Header"/>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.1Column">
		<xsl:call-template name="Portal.Generic.1Column"/>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.2Column">
		<xsl:call-template name="Portal.Generic.2Column"/>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.3Column">
		<xsl:call-template name="Portal.Generic.3Column"/>
	</xsl:template>
	<xsl:template name="Portal.InheritableArea.Layout.Footer">
		<xsl:call-template name="Portal.Generic.Footer"/>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.Header">
		<xsl:call-template name="Portal.Generic.Header"/>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.1Column">
		<xsl:call-template name="Portal.Generic.1Column"/>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.2Column">
		<xsl:call-template name="Portal.Generic.2Column"/>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.3Column">
		<xsl:call-template name="Portal.Generic.3Column"/>
	</xsl:template>
	<xsl:template name="Portal.ObjectScheme.Layout.Footer">
		<xsl:call-template name="Portal.Generic.Footer"/>
	</xsl:template>
	<xsl:template name="Portal.Generic.Header">
		<!--
		Only build the header table cell if there
		is at least one Gadget assigned to the header
		by using the <xsl:if>.
	-->
		<!--	<xsl:call-template name="Portal.Generic.StackedGadgets">-->
		<xsl:call-template name="Portal.Generic.InlineGadgets">
			<xsl:with-param name="position" select="&apos;Header&apos;"/>
			<xsl:with-param name="colspan" select="3"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Portal.Generic.1Column">
		<!--
		Only build each column if there is a
		Gadget assigned to it by using the
		<xsl:if>.
	-->
		<xsl:if test="*/Gadget[@position=&apos;Column 1&apos; or @position=&apos;Column 2&apos; or @position=&apos;Column 3&apos;]">
			<tr valign="top">
				<td colspan="25">
					<!-- Column 1 -->
					<xsl:apply-templates select="*/Gadget">
						<xsl:with-param name="Position" select="&apos;Column 1&apos;"/>
						<xsl:sort data-type="number" order="ascending" select="@priority"/>
						<xsl:sort order="ascending" select="@title"/>
					</xsl:apply-templates>
					<xsl:apply-templates select="*/Gadget">
						<xsl:with-param name="Position" select="&apos;Column 2&apos;"/>
						<xsl:sort data-type="number" order="ascending" select="@priority"/>
						<xsl:sort order="ascending" select="@title"/>
					</xsl:apply-templates>
					<xsl:apply-templates select="*/Gadget">
						<xsl:with-param name="Position" select="&apos;Column 3&apos;"/>
						<xsl:sort data-type="number" order="ascending" select="@priority"/>
						<xsl:sort order="ascending" select="@title"/>
					</xsl:apply-templates>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Generic.2Column">
		<!--
		Only build each column if there is a
		Gadget assigned to it by using the
		<xsl:if>.
	-->
		<xsl:if test="*/Gadget[@position=&apos;Column 1&apos; or @position=&apos;Column 2&apos; or @position=&apos;Column 3&apos;]">
			<tr valign="top">
				<xsl:if test="*/Gadget[@position=&apos;Column 1&apos;]">
					<td colspan="25">
						<!-- Column 1 -->
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 1&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
				<xsl:if test="*/Gadget[@position=&apos;Column 2&apos; or @position=&apos;Column 3&apos;]">
					<td colspan="25">
						<!-- Column 2 -->
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 2&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 3&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Generic.3Column">
		<!--
		Only build each column if there is a
		Gadget assigned to it by using the
		<xsl:if>.
	-->
		<xsl:if test="*/Gadget[@position=&apos;Column 1&apos; or @position=&apos;Column 2&apos; or @position=&apos;Column 3&apos;]">
			<tr valign="top">
				<xsl:if test="*/Gadget[@position=&apos;Column 1&apos;]">
					<td colspan="25">
						<!-- Column 1 -->
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 1&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
				<xsl:if test="*/Gadget[@position=&apos;Column 2&apos;]">
					<td colspan="25">
						<!-- Column 2 -->
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 2&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
				<xsl:if test="*/Gadget[@position=&apos;Column 3&apos;]">
					<td colspan="25">
						<!-- Column 3 -->
						<xsl:apply-templates select="*/Gadget">
							<xsl:with-param name="Position" select="&apos;Column 3&apos;"/>
							<xsl:sort data-type="number" order="ascending" select="@priority"/>
							<xsl:sort order="ascending" select="@title"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Portal.Generic.Footer">
		<!--
		Only build the footer table cell if there
		is at least one Gadget assigned to the footer
		by using the <xsl:if>.
	-->
		<xsl:call-template name="Portal.Generic.StackedGadgets">
			<xsl:with-param name="position" select="&apos;Footer&apos;"/>
			<xsl:with-param name="colspan" select="3"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Portal.Generic.StackedGadgets">
		<xsl:param name="position"/>
		<xsl:param name="colspan"/>
		<xsl:for-each select="*/Gadget[@position=$position]">
			<xsl:sort data-type="number" order="ascending" select="@priority"/>
			<xsl:sort order="ascending" select="@title"/>
			<tr>
				<td colspan="25">
					<xsl:attribute name="colspan">
						<xsl:value-of select="$colspan"/>
					</xsl:attribute>
					<xsl:apply-templates select=".">
						<xsl:with-param name="Position" select="$position"/>
					</xsl:apply-templates>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Portal.Generic.InlineGadgets">
		<xsl:param name="position"/>
		<xsl:param name="colspan"/>
		<xsl:if test="*/Gadget[@position=$position]">
			<tr>
				<xsl:for-each select="*/Gadget[@position=$position]">
					<xsl:sort data-type="number" order="ascending" select="@priority"/>
					<xsl:sort order="ascending" select="@title"/>
					<td colspan="25">
						<xsl:attribute name="colspan">
							<xsl:value-of select="$colspan"/>
						</xsl:attribute>
						<xsl:apply-templates select=".">
							<xsl:with-param name="Position" select="$position"/>
						</xsl:apply-templates>
					</td>
				</xsl:for-each>
			</tr>
		</xsl:if>
	</xsl:template>
	<!--
	This is the Inheritable Area template.
-->
	<xsl:template match="Gadget[@top=&apos;y&apos;]/*/Gadget[@container=&apos;y&apos; and @top=&apos;n&apos;]">
		<xsl:param name="Position"/>
		<xsl:if test="@position=$Position">
			<xsl:call-template name="Portal.InheritableArea.Layout"/>
		</xsl:if>
	</xsl:template>
	<!--
	This is the Object Scheme template.
-->
	<xsl:template match="Gadget[@top=&apos;n&apos;]/*/Gadget[@container=&apos;y&apos; and @top=&apos;n&apos;]">
		<xsl:param name="Position"/>
		<xsl:if test="@position=$Position or $Position=&apos;PDA&apos;">
			<xsl:if test="@state=&apos;max&apos;">
				<!--
				Only output Object Schemes whose state is "max".
				Object Schemes whose state is "min" exist in the
				Portal's XML data so that a "tab" representation
				can be given for them.  The Object Scheme in a
				"max" state gives data for the current Object
				Scheme.
			 -->
				<xsl:call-template name="Portal.ObjectScheme.Layout.PDA"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- This template handles Gadgets. -->
	<xsl:template match="*/Gadget[@container=&apos;n&apos; and @top=&apos;n&apos;]">
		<xsl:param name="Position"/>
		<xsl:choose>
			<xsl:when test="com.novell.nps.authentication.Authenticator and /PortalData/SessionInfo/AuthInfo/State/text()=&apos;StateLoggedIn&apos;">
				<!-- 	Do nothing here!  This will only prevent
					us from ever rendering the Authenticator
					in its normal fashion.						-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@position=$Position or $Position=&apos;PDA&apos;">
					<xsl:call-template name="Portal.Gadget"/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
