/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.nmas;

import com.novell.security.japi.nmas.NMASUtil;

public class NMASConfigData {
    private int dataSizeInBytes;
    private byte[] encodedData;
    private int methodType;
    private byte certValidationFlags;

    public NMASConfigData(byte[] byArray) {
        this.encodedData = byArray;
        this.decodeData();
    }

    public NMASConfigData(int n, byte by) {
        this.methodType = n;
        this.certValidationFlags = by;
        this.encodeData();
    }

    public NMASConfigData(long l) {
        this.methodType = (int)l;
        this.certValidationFlags = 0;
        this.encodeData();
    }

    private void decodeData() {
        if (this.encodedData.length != 9) {
            return;
        }
        this.dataSizeInBytes = NMASUtil.UnsignedByteValue(this.encodedData[0]) + (NMASUtil.UnsignedByteValue(this.encodedData[1]) << 8) + (NMASUtil.UnsignedByteValue(this.encodedData[2]) << 16) + (NMASUtil.UnsignedByteValue(this.encodedData[3]) << 24);
        this.methodType = NMASUtil.UnsignedByteValue(this.encodedData[4]) + (NMASUtil.UnsignedByteValue(this.encodedData[5]) << 8) + (NMASUtil.UnsignedByteValue(this.encodedData[6]) << 16) + (NMASUtil.UnsignedByteValue(this.encodedData[7]) << 24);
        this.certValidationFlags = (byte)NMASUtil.UnsignedByteValue(this.encodedData[8]);
    }

    private void encodeData() {
        int n = 5;
        if (this.encodedData == null) {
            this.encodedData = new byte[4 + n];
        }
        this.encodedData[0] = (byte)(n & 0xFF);
        this.encodedData[1] = (byte)((n & 0xFF00) >> 8);
        this.encodedData[2] = (byte)((n & 0xFF0000) >> 16);
        this.encodedData[3] = (byte)((n & 0xFF000000) >> 24);
        this.encodedData[4] = (byte)(this.methodType & 0xFF);
        this.encodedData[5] = (byte)((this.methodType & 0xFF00) >> 8);
        this.encodedData[6] = (byte)((this.methodType & 0xFF0000) >> 16);
        this.encodedData[7] = (byte)((this.methodType & 0xFF000000) >> 24);
        this.encodedData[8] = this.certValidationFlags;
    }

    public int getMethodType() {
        return this.methodType;
    }

    public byte getCertValidationFlags() {
        return this.certValidationFlags;
    }

    public void setMethodType(int n) {
        this.methodType = n;
        this.encodeData();
    }

    public void setCertValidationFlags(byte by) {
        this.certValidationFlags = by;
        this.encodeData();
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }
}

