/*
 * Decompiled with CFR 0.152.
 */
package com.novell.NvdsLdapExtensions;

import com.novell.NvdsLdapExtensions.EnforcementData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class DMITaskInfo {
    private String m_operationName = "";
    private String m_versionSuffix = "0.0.0";
    private ArrayList m_enforcementData = new ArrayList();
    private String m_srvName = "";

    public DMITaskInfo(Element element, String srvName) {
        this.m_srvName = srvName;
        this.setInfo(element);
    }

    private void setInfo(Element operationElement) {
        Namespace srvregNamespace;
        List list;
        Attribute nameAttribute = operationElement.getAttribute("name");
        if (nameAttribute != null) {
            String fullName = nameAttribute.getValue();
            int lastIndex = fullName.lastIndexOf(":");
            this.m_operationName = fullName.substring(lastIndex + 1);
            lastIndex = fullName.lastIndexOf("_");
            if (lastIndex != -1) {
                this.m_versionSuffix = fullName.substring(lastIndex + 2) + ".0.0";
            }
        }
        if ((list = operationElement.getChildren("enforcement", srvregNamespace = Namespace.getNamespace((String)"http://www.novell.com/destiny/srvreg"))).size() > 0) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                EnforcementData eData = new EnforcementData((Element)iter.next());
                if (!eData.getData()) continue;
                this.m_enforcementData.add(eData);
            }
        }
    }

    public String getOperationName() {
        return this.m_operationName;
    }

    public String getVersionSuffix() {
        return this.m_versionSuffix;
    }

    public EnforcementData[] getEnforcementData() {
        if (this.m_enforcementData.size() == 0) {
            return null;
        }
        return this.m_enforcementData.toArray(new EnforcementData[this.m_enforcementData.size()]);
    }

    public String getOperationID() {
        return this.m_srvName + "." + this.m_operationName;
    }

    public String getServiceName() {
        return this.m_srvName;
    }
}

