/*
 * Decompiled with CFR 0.152.
 */
package com.novell.NvdsLdapExtensions;

import com.novell.NvdsLdapExtensions.DMITaskInfo;
import com.novell.NvdsLdapExtensions.NVDSException;
import com.novell.NvdsLdapExtensions.RBACRoleInfo;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ldap.LDAPNamespace;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class NvdsLdapExtensions {
    public static RBACRoleInfo[] getAssignedRBACRoles(AdminNamespace adminNamespace) throws JDOMException, IOException, NVDSException, NamingException {
        RBACRoleInfo[] rbacRoleInfo = null;
        String servicePath = "rbacsesmgr";
        Element root = new Element("queryAssignedRolesRequest_v1", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
        Element selection = new Element("selection", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
        selection.setText("1");
        root.addContent(selection);
        Document doc = new Document(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String xmlRequest = xmlOutputter.outputString(doc);
        String response = ((LDAPNamespace)adminNamespace).sendXMLRequest(servicePath, xmlRequest);
        if (response != null) {
            rbacRoleInfo = NvdsLdapExtensions.processRBACRolesResponse(response);
        }
        return rbacRoleInfo;
    }

    public static RBACRoleInfo[] getActiveRBACRoles(AdminNamespace adminNamespace) throws JDOMException, IOException, NVDSException, NamingException {
        RBACRoleInfo[] rbacRoleInfo = null;
        String servicePath = "rbacsesmgr";
        Element root = new Element("queryActiveRolesRequest_v1", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
        Element selection = new Element("selection", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
        selection.setText("1");
        root.addContent(selection);
        Document doc = new Document(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String xmlRequest = xmlOutputter.outputString(doc);
        String response = ((LDAPNamespace)adminNamespace).sendXMLRequest(servicePath, xmlRequest);
        if (response != null) {
            rbacRoleInfo = NvdsLdapExtensions.processRBACRolesResponse(response);
        }
        return rbacRoleInfo;
    }

    public static void activateRBACRoles(AdminNamespace adminNamespace, RBACRoleInfo[] rbacRoleInfo) throws JDOMException, IOException, NVDSException, NamingException {
        String servicePath = "rbacsesmgr";
        Element rootElement = new Element("modifyActiveRolesRequest_v1", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
        for (int i = 0; i < rbacRoleInfo.length; ++i) {
            Element activate = new Element("activate", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
            Element roleNameElement = new Element("roleName", "rsm", "http://www.novell.com/delphi/rbacsesmgr");
            roleNameElement.setText(rbacRoleInfo[i].getRoleName());
            activate.addContent(roleNameElement);
            rootElement.addContent(activate);
        }
        XMLOutputter xmlOutputter = new XMLOutputter();
        Document doc = new Document(rootElement);
        String xmlRequest = xmlOutputter.outputString(doc);
        String response = ((LDAPNamespace)adminNamespace).sendXMLRequest(servicePath, xmlRequest);
        if (response != null) {
            NvdsLdapExtensions.processActivateRBACRolesResponse(response);
        }
    }

    private static void processActivateRBACRolesResponse(String response) throws JDOMException, IOException, NVDSException {
        Element rootElement = NvdsLdapExtensions.getRootElementFromResponseString(response);
        NvdsLdapExtensions.processStatusElement(rootElement);
    }

    private static RBACRoleInfo[] processRBACRolesResponse(String response) throws JDOMException, IOException, NVDSException {
        RBACRoleInfo[] rbacRoleInfo = null;
        Element rootElement = NvdsLdapExtensions.getRootElementFromResponseString(response);
        Namespace rsmNamespace = Namespace.getNamespace((String)"http://www.novell.com/delphi/rbacsesmgr");
        NvdsLdapExtensions.processStatusElement(rootElement);
        List list = rootElement.getChildren("role", rsmNamespace);
        if (list.size() > 0) {
            rbacRoleInfo = new RBACRoleInfo[list.size()];
            int count = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                rbacRoleInfo[count++] = new RBACRoleInfo((Element)iter.next());
            }
        }
        return rbacRoleInfo;
    }

    private static void processStatusElement(Element rootElement) throws NVDSException {
        String code;
        Integer errorCode;
        Element codeElement;
        Namespace baseNamespace = Namespace.getNamespace((String)"http://www.novell.com/destiny/base");
        Element statusElement = rootElement.getChild("status", baseNamespace);
        if (statusElement != null && (codeElement = statusElement.getChild("code", baseNamespace)) != null && (errorCode = new Integer(code = codeElement.getTextTrim())) != 0) {
            Element diagnosticsElement;
            String errorDescription = null;
            String errorDiagnostics = null;
            Element descriptionElement = statusElement.getChild("status", baseNamespace);
            if (descriptionElement != null) {
                errorDescription = descriptionElement.getTextTrim();
            }
            if ((diagnosticsElement = statusElement.getChild("diagnostics", baseNamespace)) != null) {
                errorDiagnostics = diagnosticsElement.getTextTrim();
            }
            throw new NVDSException(errorCode, errorDescription, errorDiagnostics);
        }
    }

    private static Element getRootElementFromResponseString(String response) throws JDOMException, IOException {
        StringReader stringReader = new StringReader(response);
        SAXBuilder saxBuilder = new SAXBuilder(false);
        Document doc = saxBuilder.build((Reader)stringReader);
        Element rootElement = doc.getRootElement();
        return rootElement;
    }

    public static DMITaskInfo[] getAllDMITaskOperations(AdminNamespace adminNamespace) throws NamingException, JDOMException, IOException, NVDSException {
        DMITaskInfo[] dmiTaskInfo = null;
        String servicePath = "srvreg/operations";
        Element root = new Element("listAllOperations_v1", "sr", "http://www.novell.com/destiny/srvreg");
        Element operationFilter = new Element("OperationFilter", "sr", "http://www.novell.com/destiny/srvreg");
        operationFilter.setAttribute(new Attribute("wsdlOnly", "true"));
        root.addContent(operationFilter);
        Document doc = new Document(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String xmlRequest = xmlOutputter.outputString(doc);
        String response = ((LDAPNamespace)adminNamespace).sendXMLRequest(servicePath, xmlRequest);
        if (response != null) {
            dmiTaskInfo = NvdsLdapExtensions.processDMITaskResponse(response);
        }
        return dmiTaskInfo;
    }

    private static DMITaskInfo[] processDMITaskResponse(String response) throws JDOMException, IOException, NVDSException {
        Object[] dmiTaskInfo = null;
        Vector<DMITaskInfo> dmiTaskInfoV = new Vector<DMITaskInfo>();
        Element rootElement = NvdsLdapExtensions.getRootElementFromResponseString(response);
        NvdsLdapExtensions.processStatusElement(rootElement);
        Namespace srNamespace = Namespace.getNamespace((String)"http://www.novell.com/destiny/srvreg");
        List listServiceElement = rootElement.getChildren("service", srNamespace);
        if (listServiceElement.size() > 0) {
            Iterator iterService = listServiceElement.iterator();
            while (iterService.hasNext()) {
                List listSchemaElement;
                String srvName = "";
                Element serviceElement = (Element)iterService.next();
                Attribute srvNameAttribute = serviceElement.getAttribute("srvName");
                if (srvNameAttribute != null) {
                    srvName = srvNameAttribute.getValue();
                }
                if ((listSchemaElement = serviceElement.getChildren("schema", srNamespace)).size() <= 0) continue;
                Iterator iterSchema = listSchemaElement.iterator();
                while (iterSchema.hasNext()) {
                    Element schemaElement = (Element)iterSchema.next();
                    List listOperationElement = schemaElement.getChildren("operation", srNamespace);
                    if (listOperationElement.size() <= 0) continue;
                    Iterator iterOperation = listOperationElement.iterator();
                    while (iterOperation.hasNext()) {
                        dmiTaskInfoV.add(new DMITaskInfo((Element)iterOperation.next(), srvName));
                    }
                }
            }
        }
        if (dmiTaskInfoV.size() > 0) {
            dmiTaskInfo = new DMITaskInfo[dmiTaskInfoV.size()];
            dmiTaskInfoV.copyInto(dmiTaskInfo);
        }
        return dmiTaskInfo;
    }

    public static DMITaskInfo[] getUserDMITaskOperations(AdminNamespace adminNamespace) throws NamingException, JDOMException, IOException, NVDSException {
        DMITaskInfo[] dmiTaskInfo = null;
        String servicePath = "srvreg/operations";
        Element root = new Element("listUserOperations_v1", "sr", "http://www.novell.com/destiny/srvreg");
        Element operationFilter = new Element("OperationFilter", "sr", "http://www.novell.com/destiny/srvreg");
        operationFilter.setAttribute(new Attribute("wsdlOnly", "true"));
        root.addContent(operationFilter);
        Document doc = new Document(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String xmlRequest = xmlOutputter.outputString(doc);
        String response = ((LDAPNamespace)adminNamespace).sendXMLRequest(servicePath, xmlRequest);
        if (response != null) {
            dmiTaskInfo = NvdsLdapExtensions.processDMITaskResponse(response);
        }
        return dmiTaskInfo;
    }

    private static String testFromFile() throws JDOMException, IOException {
        File file = new File("C:\\nakoma\\iManager\\run\\tomcat\\webapps\\nps\\portal\\modules\\listAllOperationsResp.xml");
        SAXBuilder saxBuilder = new SAXBuilder(false);
        Document jdomDocumemt = saxBuilder.build(file);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String response = xmlOutputter.outputString(jdomDocumemt);
        return response;
    }
}

