/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.SymbolTableEntry;
import com.novell.webaccess.common.TemplateCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

class Decompiler {
    InputStream m_is = null;
    OutputStream m_os = null;
    Vector m_vSymTab = null;
    int m_iTotalRead = 0;

    Decompiler(InputStream inputStream, OutputStream outputStream, Vector vector) {
        this.m_is = inputStream;
        this.m_os = outputStream;
        this.m_vSymTab = vector;
        byte[] byArray = new byte[4];
        try {
            while (true) {
                this.writeOffset(this.m_iTotalRead);
                int n = this.readBytes(byArray);
                if (n < 2) {
                    return;
                }
                int n2 = TemplateCompiler.fourByteToInt(byArray);
                int n3 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_NOP);
                int n4 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_OUT);
                int n5 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_PUSH);
                int n6 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_ADD);
                int n7 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SUB);
                int n8 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_MULT);
                int n9 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DIV);
                int n10 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_MOD);
                int n11 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SET);
                int n12 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SETG);
                int n13 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_PRN);
                int n14 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_CAT);
                int n15 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_LINE);
                int n16 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_INCL);
                int n17 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_EOIN);
                int n18 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_QUIT);
                int n19 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_FLSH);
                int n20 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DUMP);
                int n21 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_REPL);
                int n22 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_INC);
                int n23 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DEC);
                int n24 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_STAB);
                int n25 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DEF);
                int n26 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JZ);
                int n27 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JNZ);
                int n28 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JMP);
                int n29 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_CMP);
                int n30 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_BAND);
                int n31 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_BOR);
                int n32 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_FNC);
                int n33 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_IDXV);
                int n34 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_NOT);
                int n35 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_TST);
                int n36 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DREF);
                int n37 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_HDR);
                int n38 = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_COOK);
                String string = Integer.toHexString(n2);
                if (n2 == n3) {
                    this.op_NOP(string);
                    continue;
                }
                if (n2 == n4) {
                    this.op_OUT(string);
                    continue;
                }
                if (n2 == n5) {
                    this.op_PUSH(string);
                    continue;
                }
                if (n2 == n6) {
                    this.op_ADD(string);
                    continue;
                }
                if (n2 == n7) {
                    this.op_SUB(string);
                    continue;
                }
                if (n2 == n8) {
                    this.op_MULT(string);
                    continue;
                }
                if (n2 == n9) {
                    this.op_DIV(string);
                    continue;
                }
                if (n2 == n10) {
                    this.op_MOD(string);
                    continue;
                }
                if (n2 == n11) {
                    this.op_SET(string);
                    continue;
                }
                if (n2 == n12) {
                    this.op_SETG(string);
                    continue;
                }
                if (n2 == n13) {
                    this.op_PRN(string);
                    continue;
                }
                if (n2 == n14) {
                    this.op_CAT(string);
                    continue;
                }
                if (n2 == n18) {
                    this.op_QUIT(string);
                    continue;
                }
                if (n2 == n19) {
                    this.op_FLSH(string);
                    continue;
                }
                if (n2 == n20) {
                    this.op_DUMP(string);
                    continue;
                }
                if (n2 == n21) {
                    this.op_REPL(string);
                    continue;
                }
                if (n2 == n22) {
                    this.op_INC(string);
                    continue;
                }
                if (n2 == n23) {
                    this.op_DEC(string);
                    continue;
                }
                if (n2 == n24) {
                    this.op_STAB(string);
                    continue;
                }
                if (n2 == n25) {
                    this.op_DEF(string);
                    continue;
                }
                if (n2 == n26) {
                    this.op_JZ(string);
                    continue;
                }
                if (n2 == n27) {
                    this.op_JNZ(string);
                    continue;
                }
                if (n2 == n28) {
                    this.op_JMP(string);
                    continue;
                }
                if (n2 == n29) {
                    this.op_CMP(string);
                    continue;
                }
                if (n2 == n30) {
                    this.op_BAND(string);
                    continue;
                }
                if (n2 == n31) {
                    this.op_BOR(string);
                    continue;
                }
                if (n2 == n32) {
                    this.op_FNC(string);
                    continue;
                }
                if (n2 == n33) {
                    this.op_IDXV(string);
                    continue;
                }
                if (n2 == n34) {
                    this.op_NOT(string);
                    continue;
                }
                if (n2 == n35) {
                    this.op_TST(string);
                    continue;
                }
                if (n2 == n36) {
                    this.op_DREF(string);
                    continue;
                }
                if (n2 == n37) {
                    this.op_HDR(string);
                    continue;
                }
                if (n2 == n38) {
                    this.op_COOK(string);
                    continue;
                }
                if (n2 == n15) {
                    this.op_LINE(string);
                    continue;
                }
                if (n2 == n16) {
                    this.op_INCL(string);
                    continue;
                }
                if (n2 == n17) {
                    this.op_EOIN(string);
                    continue;
                }
                this.op_UNKNOWN(string);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    int readBytes(byte[] byArray) throws IOException {
        int n = this.m_is.read(byArray);
        this.m_iTotalRead += n;
        return n;
    }

    void op_NOP(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("NOP");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_PUSH(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        SymbolTableEntry symbolTableEntry = (SymbolTableEntry)this.m_vSymTab.elementAt(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("PUSH");
        this.writeStringParam(symbolTableEntry.getName().toString());
        this.writeComment(symbolTableEntry.getValue().toString());
    }

    void op_OUT(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        String string3 = Integer.toHexString(n);
        byte[] byArray2 = new byte[n];
        this.readBytes(byArray2);
        this.writeHex(string, string2);
        this.writeStringOpcode("OUT");
        this.writeStringParam(string3);
        this.writeComment("Output " + n + " bytes");
    }

    void op_ADD(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("ADD");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_SUB(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("SUB");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_MULT(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("MULT");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_DIV(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("DIV");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_MOD(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("DIV");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_SET(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("SET");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_SETG(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("SETG");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_PRN(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("PRN");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_CAT(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("CAT");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_QUIT(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("QUIT");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_FLSH(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("FLSH");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_DUMP(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("DUMP");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_REPL(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("REPL");
        this.writeStringParam(string2);
        this.writeComment(null);
    }

    void op_INC(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("INC");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_DEC(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("DEC");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_STAB(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("STAB");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_DEF(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("DEF");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_JZ(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("JZ");
        this.writeStringParam(string2);
        this.writeComment(null);
    }

    void op_JNZ(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("JNZ");
        this.writeStringParam(string2);
        this.writeComment(null);
    }

    void op_JMP(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("JMP");
        this.writeStringParam(string2);
        this.writeComment(null);
    }

    void op_CMP(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("CMP");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_BAND(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("BAND");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_BOR(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("BOR");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_FNC(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("FNC");
        this.writeStringParam(string2);
        this.writeComment(TemplateCompiler.getFunctionName(n));
    }

    void op_IDXV(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        SymbolTableEntry symbolTableEntry = (SymbolTableEntry)this.m_vSymTab.elementAt(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("IDXV");
        this.writeStringParam(symbolTableEntry.getName().toString());
        this.writeComment(symbolTableEntry.getValue().toString());
    }

    void op_NOT(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("NOT");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void op_TST(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("TST");
        this.writeStringParam(string2);
        this.writeComment("Test top of stack for " + string2);
    }

    void op_DREF(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        String string2 = Integer.toHexString(n);
        this.writeHex(string, string2);
        this.writeStringOpcode("DREF");
        this.writeStringParam(string2);
        if (n == 0) {
            this.writeComment("VAR lookup of var on stack");
        } else {
            this.writeComment("STRING lookup of var on stack");
        }
    }

    void op_HDR(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("HDR");
        this.writeStringParam(null);
        this.writeComment("Set header for transaction back to browser");
    }

    void op_COOK(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("COOK");
        this.writeStringParam(null);
        this.writeComment("Set cookie for browser");
    }

    void op_LINE(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        this.readBytes(byArray);
        int n2 = TemplateCompiler.fourByteToInt(byArray);
        byte[] byArray2 = new byte[n2];
        String string2 = Integer.toHexString(n2);
        this.readBytes(byArray2);
        this.writeHex(string, string2);
        this.writeStringOpcode("LINE");
        this.writeStringParam(string2);
        this.writeComment(null);
        String string3 = " <<<<< Line: " + n + ": ";
        this.m_os.write(string3.getBytes());
        this.m_os.write(byArray2);
        this.m_os.write(new String(" >>>>>\n\n").getBytes());
    }

    void op_INCL(String string) throws IOException {
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        int n = TemplateCompiler.fourByteToInt(byArray);
        byte[] byArray2 = new byte[n];
        String string2 = Integer.toHexString(n);
        this.readBytes(byArray2);
        this.writeHex(string, string2);
        this.writeStringOpcode("INCL");
        this.writeStringParam(new String(byArray2));
        this.writeComment("Include file");
    }

    void op_EOIN(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("EOIN");
        this.writeStringParam(null);
        this.writeComment("End of include file");
    }

    void op_UNKNOWN(String string) throws IOException {
        this.writeHex(string, null);
        this.writeStringOpcode("UNKN");
        this.writeStringParam(null);
        this.writeComment(null);
    }

    void writeOffset(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("00000000");
        String string = Integer.toHexString(n);
        stringBuffer.setLength(stringBuffer.length() - string.length());
        String string2 = "0x" + stringBuffer.toString() + string + "  ";
        this.m_os.write(string2.getBytes());
    }

    void writeHex(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("00000000");
        StringBuffer stringBuffer2 = null;
        if (string2 == null) {
            string2 = "";
            stringBuffer2 = new StringBuffer("        ");
        } else {
            stringBuffer2 = new StringBuffer("00000000");
        }
        stringBuffer.setLength(stringBuffer.length() - string.length());
        stringBuffer2.setLength(stringBuffer2.length() - string2.length());
        String string3 = "0x" + stringBuffer.toString() + string + " " + stringBuffer2 + string2 + "  ";
        this.m_os.write(string3.getBytes());
    }

    void writeStringOpcode(String string) throws IOException {
        int n = 4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer + "  ";
        this.m_os.write(string2.getBytes());
    }

    void writeStringParam(String string) throws IOException {
        int n = 15;
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(' ');
        String string2 = stringBuffer.toString();
        this.m_os.write(string2.getBytes());
    }

    void writeComment(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        String string2 = "; " + string + "\n";
        this.m_os.write(string2.getBytes());
    }
}

