/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.Browser;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class I18NLocale
implements Serializable {
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String VARIANT_ISO = "ISO";
    private static final String VARIANT_ANSI = "ANSI";
    private static final String VARIANT_MAC = "MAC";
    private static final String VARIANT_UNIX = "UNIX";
    private static final String VARIANT_WIN = "WIN";
    public static final int CHARSET_ISO = 1;
    public static final int CHARSET_ANSI = 2;
    public static final int CHARSET_MAC = 3;
    public static final int CHARSET_UNIX = 4;
    public static final int LOCALE_LANGUAGE = 1;
    public static final int LOCALE_COUNTRY = 2;
    public static final int LOCALE_VARIANT = 3;
    private static final String[][] m_tblCharset = new String[][]{{"af", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"sq", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"ar", "ISO-8859-6", "Cp1256", "ISO-8859-6", "ISO-8859-6"}, {"bg", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"be", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"ca", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"zh", "Cp950", "Cp950", "Cp950", "Cp950"}, {"zh_CN", "GBK", "GBK", "GBK", "GBK"}, {"zh_SG", "GBK", "GBK", "GBK", "GBK"}, {"zh_TW", "Cp950", "Cp950", "Cp950", "Cp950"}, {"zh_HK", "Cp950", "Cp950", "Cp950", "Cp950"}, {"hr", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"cs", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"da", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"nl", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"en", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"et", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"fi", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"fr", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"de", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"el", "ISO-8859-7", "Cp1253", "ISO-8859-7", "ISO-8859-7"}, {"iw", "ISO-8859-8", "Cp1255", "ISO-8859-8", "ISO-8859-8"}, {"he", "ISO-8859-8", "Cp1255", "ISO-8859-8", "ISO-8859-8"}, {"hu", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"is", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"it", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"ja", "SJIS", "SJIS", "SJIS", "SJIS"}, {"ko", "Cp949", "Cp949", "Cp949", "Cp949"}, {"lv", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"lt", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"mk", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"no", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"pl", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"pt", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"ro", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"ru", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"sr", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"sk", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"sl", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"es", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"sv", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"th", "Cp874", "Cp874", "Cp874", "Cp874"}, {"tr", "ISO-8859-9", "Cp1254", "ISO-8859-9", "ISO-8859-9"}, {"uk", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}};
    private static final int CHARSET_TABLE_ENTRIES = 44;
    private static Hashtable m_hCharsetMappings = new Hashtable();
    private Locale m_locale = null;
    private String m_sCharset = null;

    void update(I18NLocale i18NLocale) {
        this.m_locale = i18NLocale.getLocale();
        this.m_sCharset = i18NLocale.getCharset();
    }

    private static Locale fixupLocale(String string, String string2, String string3) {
        if (string.equals("zh")) {
            string2 = string2 != null && (string2.equals("CN") || string2.equals("SG")) ? "CN" : "TW";
        }
        return new Locale(string, string2, string3);
    }

    public I18NLocale() {
        Locale locale = Locale.getDefault();
        this.m_locale = I18NLocale.fixupLocale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
        if (this.m_locale != null) {
            this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        }
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    public I18NLocale(String string, String string2, String string3) {
        if (string2 != null) {
            string2 = string2.toUpperCase();
        }
        this.m_locale = I18NLocale.fixupLocale(string, string2, string3);
        this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    public I18NLocale(HttpServletRequest httpServletRequest, boolean bl) {
        this.constructI18NLocale(httpServletRequest, bl);
    }

    public I18NLocale(HttpServletRequest httpServletRequest) {
        this.constructI18NLocale(httpServletRequest, true);
    }

    public void constructI18NLocale(HttpServletRequest httpServletRequest, boolean bl) {
        String string = httpServletRequest.getContentType();
        int n = -1;
        if (string != null) {
            n = string.indexOf("; charset=");
        }
        if (n != -1) {
            this.m_sCharset = string.substring(n + 10);
        } else {
            Browser browser = new Browser(httpServletRequest.getHeader("User-Agent"));
            this.m_locale = I18NLocale.getLocaleFromHttp(httpServletRequest.getHeader("Accept-Language"), httpServletRequest.getHeader("Accept-Charset"), browser.getOS(), bl);
            this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        }
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getLocaleIdentifier(int n) {
        return this.getLocaleIdentifier(n, true);
    }

    public String getLocaleIdentifier(int n, boolean bl) {
        String string = null;
        String string2 = null;
        String string3 = null;
        switch (n) {
            case 3: {
                string3 = this.m_locale.getVariant();
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
            }
            case 2: {
                string2 = this.m_locale.getCountry();
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
                if (string2 == null) {
                    string3 = null;
                }
            }
            case 1: {
                string = this.m_locale.getLanguage();
                if (string != null && string.length() == 0) {
                    string = null;
                }
                if (bl || string2 == null || string.equals("zh")) break;
                string2 = null;
                break;
            }
            default: {
                return null;
            }
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append("_").append(string2);
            if (string3 != null) {
                stringBuffer.append("_").append(string3);
            }
        }
        return stringBuffer.toString();
    }

    public void setCharset(String string) {
        this.m_sCharset = string;
    }

    public String getCharset() {
        return this.m_sCharset;
    }

    public String getCharset(int n) {
        return I18NLocale.getCharsetForLocale(this.m_locale, n);
    }

    public static Locale getLocaleFromHttp(String string, String string2, String string3, boolean bl) {
        Locale locale = null;
        String string4 = null;
        String string5 = null;
        if (string == null) {
            string = DEFAULT_LANGUAGE;
        }
        string4 = I18NLocale.mapVariant(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            locale = I18NLocale.getLocaleForLanguage(string6, string4);
            if (bl && locale.getLanguage().equalsIgnoreCase(DEFAULT_LANGUAGE)) {
                locale = null;
                continue;
            }
            string5 = I18NLocale.getCharsetForLocale(locale);
            if (string5 != null) break;
            locale = null;
        }
        if (locale == null) {
            locale = new Locale(DEFAULT_LANGUAGE, "", string4);
        }
        return locale;
    }

    private static String mapVariant(String string) {
        String string2 = string.toUpperCase();
        string2 = string2.startsWith(VARIANT_WIN) ? VARIANT_WIN : (string2.startsWith(VARIANT_MAC) ? VARIANT_MAC : (string2.startsWith(VARIANT_UNIX) ? VARIANT_UNIX : VARIANT_ISO));
        return string2;
    }

    private static Locale getLocaleForLanguage(String string, String string2) {
        int n;
        int n2 = string.indexOf(59);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        Locale locale = (n = (string = string.trim()).indexOf(45)) == -1 ? I18NLocale.fixupLocale(string.toLowerCase(), "", string2) : I18NLocale.fixupLocale(string.substring(0, n).toLowerCase(), string.substring(n + 1).toUpperCase(), string2);
        return locale;
    }

    private static String getCharsetForLocale(Locale locale) {
        int n = locale.getVariant().equals(VARIANT_WIN) ? 2 : (locale.getVariant().equals(VARIANT_MAC) ? 3 : (locale.getVariant().equals(VARIANT_UNIX) ? 4 : 1));
        return I18NLocale.getCharsetForLocale(locale, n);
    }

    private static String getCharsetForLocale(Locale locale, int n) {
        String string = null;
        string = locale.getLanguage().equals("zh") ? (!locale.getCountry().equals("") ? locale.getLanguage() + "_" + locale.getCountry() : locale.getLanguage()) : locale.getLanguage();
        String[] stringArray = (String[])m_hCharsetMappings.get(string);
        if (stringArray != null) {
            switch (n) {
                case 2: {
                    return stringArray[2];
                }
                case 3: {
                    return stringArray[3];
                }
                case 4: {
                    return stringArray[4];
                }
            }
            return stringArray[1];
        }
        return null;
    }

    static {
        int n = 0;
        while (n < 44) {
            m_hCharsetMappings.put(m_tblCharset[n][0], m_tblCharset[n]);
            ++n;
        }
    }
}

