/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.njFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Log
implements Runnable {
    static final int LOG_MAX_AGE_DEFAULT = 7;
    static final int LOG_MAX_SIZE_DEFAULT = 1024;
    static final int LOG_LEVEL_START = 0;
    public static final int LOG_LEVEL_OFF = 0;
    public static final int LOG_LEVEL_NORMAL = 1;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DIAGNOSTIC = 3;
    static final int LOG_LEVEL_END = 3;
    static final int ERR_LEVEL_START = 0;
    public static final int ERR_LEVEL_INFO = 0;
    public static final int ERR_LEVEL_WARN = 1;
    public static final int ERR_LEVEL_ERROR = 2;
    static final int ERR_LEVEL_END = 2;
    static final int LOG_THREAD_WAIT = 1;
    private boolean m_bLogThreadstarted = false;
    private String m_sLogPath = null;
    private boolean m_bFileLog = false;
    private boolean m_bConsoleLog = true;
    private int m_iMaxAge = 7;
    private long m_lMaxSize = 0x100000L;
    private int m_iLevel = 1;
    private Vector m_vFileList = new Vector();
    private I18NLocale m_i18NLoc = new I18NLocale();
    private SimpleDateFormat m_dFormat = null;
    private String m_sLogFileDate = null;
    private String m_sLogRoot = null;
    private String m_sLogFileName = null;
    private long m_lCombinedLogSize = 0L;
    private OutputStreamWriter m_out = null;
    private boolean m_bForce = false;
    private Vector m_vLogQueue = new Vector();
    private long m_lLastThreadRun = 0L;
    private Thread m_logThread = null;

    public Log(String string) {
        this.m_sLogRoot = string;
        this.m_dFormat = new SimpleDateFormat("H:mm:ss");
    }

    public void init(Properties properties) {
        String string = properties.getProperty("Log.path");
        if (string != null) {
            this.setLogPath(string);
        }
        if ((string = properties.getProperty("Log.maxSize")) != null) {
            this.setMaxSize(Long.parseLong(string));
        }
        if ((string = properties.getProperty("Log.maxAge")) != null) {
            this.setMaxAge(Integer.parseInt(string));
        }
        if ((string = properties.getProperty("Log.Console.enable")) != null) {
            if (string.equalsIgnoreCase("true")) {
                this.setConsoleLogging(true);
            } else {
                this.setConsoleLogging(false);
            }
        }
        if ((string = properties.getProperty("Log.enable")) != null) {
            if (string.equalsIgnoreCase("true")) {
                this.setFileLogging(true);
            } else {
                this.setFileLogging(false);
            }
        }
        if ((string = properties.getProperty("Log.level")) != null) {
            if (string.equalsIgnoreCase("none")) {
                this.setLevel(0);
            }
            if (string.equalsIgnoreCase("off")) {
                this.setLevel(0);
            }
            if (string.equalsIgnoreCase("normal")) {
                this.setLevel(1);
            }
            if (string.equalsIgnoreCase("verbose")) {
                this.setLevel(2);
            }
            if (string.equalsIgnoreCase("diagnostic")) {
                this.setLevel(3);
            }
        }
        if ((string = properties.getProperty("Log.timeStamp")) != null) {
            this.setTimeStamp(string);
        }
        string = properties.getProperty("Log.language");
        this.setLanguage(string);
        string = properties.getProperty("Log.immediate");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.m_bForce = true;
        }
        if (!this.m_bLogThreadstarted) {
            this.start();
            this.m_bLogThreadstarted = true;
        }
    }

    protected void finalize() {
        this.stopLog();
    }

    public void setTimeStamp(String string) {
        this.m_dFormat = new SimpleDateFormat(string);
    }

    public void setLanguage(String string) {
        if (string != null) {
            String string2 = null;
            String string3 = "";
            String string4 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                }
            }
            this.m_i18NLoc = new I18NLocale(string2, string3, string4);
        }
    }

    public I18NLocale getI18NLocale() {
        return this.m_i18NLoc;
    }

    public String getLanguage() {
        return this.m_i18NLoc.getLocale().getLanguage();
    }

    public String getCountry() {
        return this.m_i18NLoc.getLocale().getCountry();
    }

    public String getVariant() {
        return this.m_i18NLoc.getLocale().getVariant();
    }

    public void setLogPath(String string) {
        njFile njFile2 = new njFile(string);
        try {
            string = njFile2.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_sLogPath = string;
        if (!njFile2.isDirectory() && !njFile2.mkdirs()) {
            this.error("Error.Log.badPath", string, null, null, null, null, null);
        }
    }

    public String getLogPath() {
        return this.m_sLogPath;
    }

    public void setMaxAge(int n) {
        this.m_iMaxAge = n >= 0 && n <= 350 ? n : 7;
    }

    public int getMaxAge() {
        return this.m_iMaxAge;
    }

    public void setMaxSize(long l) {
        this.m_lMaxSize = l * 1024L;
    }

    public long getMaxSize() {
        return this.m_lMaxSize;
    }

    public void setFileLogging(boolean bl) {
        if (this.getLogPath() == null) {
            this.m_bFileLog = false;
            return;
        }
        this.m_bFileLog = bl;
        if (this.m_bFileLog) {
            this.checkCombinedSize();
            this.openLogFile(true);
            this.closeLogFile();
        }
    }

    public boolean getFileLogging() {
        return this.m_bFileLog;
    }

    public void setConsoleLogging(boolean bl) {
        this.m_bConsoleLog = bl;
    }

    public boolean getConsoleLogging() {
        return this.m_bConsoleLog;
    }

    public void setLevel(int n) {
        if (n >= 0 && n <= 3) {
            this.m_iLevel = n;
        }
    }

    public int getLevel() {
        return this.m_iLevel;
    }

    public void start() {
        this.m_logThread = new Thread(this);
        this.m_logThread.start();
    }

    public void stop() {
        this.m_logThread.stop();
        this.stopLog();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        long l = 1000L;
        while (true) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_vLogQueue.size() > 0) {
                this.openLogFile(false);
                while (this.m_vLogQueue.size() > 0) {
                    LogEntry logEntry = (LogEntry)this.m_vLogQueue.elementAt(0);
                    this.m_vLogQueue.removeElementAt(0);
                    String string = this.formatLogEntry(logEntry);
                    if (this.m_bFileLog) {
                        this.logToFile(string);
                    }
                    if (this.m_bConsoleLog) {
                        System.out.println(string);
                    }
                    Thread.yield();
                }
                this.closeLogFile();
            }
            Thread.yield();
        }
    }

    public void stopLog() {
        if (this.m_vLogQueue.size() > 0) {
            this.openLogFile(false);
            while (this.m_vLogQueue.size() > 0) {
                LogEntry logEntry = (LogEntry)this.m_vLogQueue.elementAt(0);
                this.m_vLogQueue.removeElementAt(0);
                String string = this.formatLogEntry(logEntry);
                if (this.m_bFileLog) {
                    this.logToFile(string);
                }
                if (!this.m_bConsoleLog) continue;
                System.out.println(string);
            }
            this.closeLogFile();
        }
    }

    public void logMessage(String string, String string2, String string3, String string4, int n, int n2) {
        if (n2 > this.m_iLevel) {
            return;
        }
        if (n < 0 || n > 2) {
            n = 0;
        }
        LogEntry logEntry = new LogEntry(string, string2, string3, n, string4);
        if (this.m_bForce) {
            String string5 = this.formatLogEntry(logEntry);
            if (this.m_bFileLog) {
                this.openLogFile(false);
                this.logToFile(string5);
                this.closeLogFile();
            }
            if (this.m_bConsoleLog) {
                System.out.println(string5);
            }
        } else {
            this.m_vLogQueue.addElement(logEntry);
        }
    }

    public void logMessage(String string, String string2, String string3, int n) {
        this.logMessage(string, string2, string3, null, 0, n);
    }

    public void logMessage(String string, String string2, String string3) {
        this.logMessage(string, string2, string3, null, 0, 1);
    }

    private String formatLogEntry(LogEntry logEntry) {
        Date date = logEntry.getDate();
        String string = logEntry.getMessageType();
        String string2 = logEntry.getMessageId();
        String string3 = logEntry.getUser();
        String string4 = logEntry.getMessage();
        String string5 = logEntry.getErrorLevel();
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        stringBuffer = this.m_dFormat.format(date, stringBuffer, fieldPosition);
        stringBuffer.append(", <");
        stringBuffer.append(string);
        stringBuffer.append(">, ");
        stringBuffer.append(string2);
        stringBuffer.append(", ");
        stringBuffer.append(string5);
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    private void logToFile(String string) {
        int n = string.length();
        if (this.m_lCombinedLogSize + (long)n >= this.m_lMaxSize) {
            this.closeLogFile();
            this.reduceCombinedLogSize(n);
            this.openLogFile(false);
        }
        if (this.m_out != null) {
            try {
                this.m_out.write(string, 0, n);
                this.m_out.write("\r\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void openLogFile(boolean bl) {
        Comparable<StringBuffer> comparable;
        Date date = new Date();
        Locale locale = new Locale("en", "");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMdd", locale);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        stringBuffer = simpleDateFormat.format(date, stringBuffer, fieldPosition);
        if (bl || !this.m_sLogFileDate.equals(stringBuffer.toString())) {
            this.checkMaxDays();
            this.m_sLogFileDate = stringBuffer.toString();
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append(this.m_sLogFileDate);
            ((StringBuffer)comparable).append(this.m_sLogRoot);
            String string = null;
            int n = 1;
            boolean bl2 = false;
            StringBuffer stringBuffer2 = new StringBuffer();
            do {
                stringBuffer2.setLength(0);
                if (n < 10) {
                    stringBuffer2.append(".00");
                } else if (n < 100) {
                    stringBuffer2.append(".0");
                }
                stringBuffer2.append(String.valueOf(n));
                string = ((StringBuffer)comparable).toString() + stringBuffer2.toString();
                File file = new File(this.m_sLogPath, string);
                if (!file.exists()) {
                    bl2 = true;
                }
                ++n;
            } while (!bl2);
            this.m_sLogFileDate = stringBuffer.toString();
            this.m_sLogFileName = string;
        }
        try {
            comparable = new File(this.m_sLogPath, this.m_sLogFileName);
            this.m_out = new OutputStreamWriter((OutputStream)new FileOutputStream(((File)comparable).toString(), true), this.m_i18NLoc.getCharset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeLogFile() {
        try {
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_out = null;
    }

    protected void reduceCombinedLogSize(long l) {
        File file = null;
        int n = this.m_vFileList.size() - 1;
        while (this.m_lCombinedLogSize + l > this.m_lMaxSize && n >= 0) {
            file = (File)this.m_vFileList.elementAt(n);
            this.m_vFileList.removeElementAt(n);
            this.m_lCombinedLogSize -= file.length();
            file.delete();
            n = this.m_vFileList.size() - 1;
        }
    }

    protected void checkCombinedSize() {
        this.m_lCombinedLogSize = 0L;
        String string = this.getLogPath();
        if (string == null) {
            return;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            file = new File(string, stringArray[n2]);
            if (file.isFile()) {
                n = (int)((long)n + file.length());
                int n3 = 0;
                while (n3 < this.m_vFileList.size()) {
                    File file2 = (File)this.m_vFileList.elementAt(n3);
                    if (file.lastModified() > file2.lastModified()) {
                        this.m_vFileList.insertElementAt(file, n3);
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        this.m_lCombinedLogSize = n;
    }

    protected void checkMaxDays() {
        String string = this.getLogPath();
        if (string == null) {
            return;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        long l = (long)this.getMaxAge() * 1000L * 60L * 60L * 24L;
        long l2 = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            file = new File(string, stringArray[n]);
            if (file.isFile() && l2 - file.lastModified() > l) {
                file.delete();
            }
            ++n;
        }
    }

    private void error(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NLocale i18NLocale = null;
        i18NLocale = new I18NLocale(this.getLanguage(), this.getCountry(), this.getVariant());
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.Log", i18NLocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        this.logMessage(string8, "LOG", null);
    }

    private class LogEntry {
        private Date m_dEntry;
        private String m_sMsg;
        private String m_sMsgType;
        private String m_sMsgId;
        private String m_sUser;
        private String m_sErrLevel;

        public LogEntry(String string, String string2, String string3, int n, String string4) {
            if (string == null) {
                string = "-";
            }
            if (string2 == null) {
                string2 = "-";
            }
            if (string3 == null) {
                string3 = "-";
            }
            if (string4 == null) {
                string4 = "-";
            }
            switch (n) {
                case 1: {
                    this.m_sErrLevel = "WARN";
                    break;
                }
                case 2: {
                    this.m_sErrLevel = "ERROR";
                    break;
                }
                default: {
                    this.m_sErrLevel = "INFO";
                }
            }
            this.m_dEntry = new Date();
            this.m_sMsg = string;
            this.m_sMsgType = string2;
            this.m_sMsgId = string3;
            this.m_sUser = string4;
        }

        public Date getDate() {
            return this.m_dEntry;
        }

        public String getMessage() {
            return this.m_sMsg;
        }

        public String getMessageType() {
            return this.m_sMsgType;
        }

        public String getMessageId() {
            return this.m_sMsgId;
        }

        public String getUser() {
            return this.m_sUser;
        }

        public String getErrorLevel() {
            return this.m_sErrLevel;
        }
    }
}

