/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.LockNotHeld;
import com.novell.webaccess.common.UpgradeNotAllowed;
import java.util.Vector;

public class RWLock {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private Vector m_vWaiters = new Vector();
    private boolean m_bAllowUpgrades = true;

    public RWLock() {
    }

    public RWLock(boolean bl) {
        this();
        this.m_bAllowUpgrades = bl;
    }

    public synchronized void lockRead() {
        RWNode rWNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            rWNode = new RWNode(thread, 1);
            this.m_vWaiters.addElement(rWNode);
        } else {
            rWNode = (RWNode)this.m_vWaiters.elementAt(n);
        }
        if (rWNode.m_iLockCount > 0) {
            ++rWNode.m_iLockCount;
            return;
        }
        int n2 = this.getFirstWriter();
        while (n2 != -1 && this.getIndex(thread) > n2) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = this.getFirstWriter();
        }
        ++rWNode.m_iLockCount;
    }

    public synchronized void lockWrite() throws UpgradeNotAllowed {
        RWNode rWNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            rWNode = new RWNode(thread, 2);
            this.m_vWaiters.addElement(rWNode);
        } else {
            rWNode = (RWNode)this.m_vWaiters.elementAt(n);
            if (rWNode.m_iLockType == 1) {
                throw new UpgradeNotAllowed();
            }
            rWNode.m_iLockType = 2;
        }
        while (this.getIndex(thread) != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++rWNode.m_iLockCount;
    }

    public synchronized void unlock() throws LockNotHeld {
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            throw new LockNotHeld();
        }
        RWNode rWNode = (RWNode)this.m_vWaiters.elementAt(n);
        --rWNode.m_iLockCount;
        if (rWNode.m_iLockCount == 0) {
            this.m_vWaiters.removeElementAt(n);
        }
        this.notifyAll();
    }

    public synchronized void downgrade() throws LockNotHeld {
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            throw new LockNotHeld();
        }
        RWNode rWNode = (RWNode)this.m_vWaiters.elementAt(n);
        if (rWNode.m_iLockType == 2) {
            rWNode.m_iLockType = 1;
            this.notifyAll();
        }
    }

    private int getFirstWriter() {
        int n = 0;
        int n2 = this.m_vWaiters.size();
        while (n < n2) {
            RWNode rWNode = (RWNode)this.m_vWaiters.elementAt(n);
            if (rWNode.m_iLockType == 2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getIndex(Thread thread) {
        int n = 0;
        int n2 = this.m_vWaiters.size();
        while (n < n2) {
            RWNode rWNode = (RWNode)this.m_vWaiters.elementAt(n);
            if (rWNode.m_t == thread) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private class RWNode {
        public Thread m_t;
        public int m_iLockType;
        public int m_iLockCount = 0;

        public RWNode(Thread thread, int n) {
            this.m_t = thread;
            this.m_iLockType = n;
        }
    }
}

