/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import java.util.Vector;

public class SBTokenizer {
    static final String DELIMS = " \t\r\n";
    static final String RETDELIMS = "";
    private boolean m_bReturnQuotedStrings = true;
    private StringBuffer m_sbBuffer;
    private StringBuffer m_sbOriginal;
    private Vector m_vTokens = new Vector();
    private Vector m_vTokenPosition = new Vector();
    private int m_iCurrentToken = 0;
    private StringBuffer m_sbQuotes = new StringBuffer();
    private StringBuffer m_sbRetQuotes = new StringBuffer();
    private char m_escapeChar = '\u0000';
    private StringBuffer m_sbDelims = new StringBuffer();
    private StringBuffer m_sbReturnableDelims = new StringBuffer();

    public SBTokenizer(StringBuffer stringBuffer) {
        this.m_sbDelims.append(DELIMS);
        this.m_sbReturnableDelims.append(RETDELIMS);
        this.m_sbBuffer = stringBuffer;
        int n = this.m_sbBuffer.length();
        char[] cArray = new char[n];
        this.m_sbOriginal = new StringBuffer();
        if (n > 0) {
            this.m_sbBuffer.getChars(0, n, cArray, 0);
            this.m_sbOriginal.append(cArray);
        }
    }

    public int tokenize() {
        this.fillVector();
        return this.m_vTokens.size();
    }

    public int getRemainingCount() {
        return this.m_vTokens.size();
    }

    public void returnQuotedStrings(boolean bl) {
        this.m_bReturnQuotedStrings = bl;
    }

    public void setDelims(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null) {
            this.m_sbDelims = stringBuffer;
        }
        if (stringBuffer2 != null) {
            this.m_sbReturnableDelims = stringBuffer2;
        }
    }

    public void setQuotes(StringBuffer stringBuffer, StringBuffer stringBuffer2, char c) {
        this.m_sbQuotes = stringBuffer;
        this.m_sbRetQuotes = stringBuffer2;
        this.m_escapeChar = c;
    }

    private void fillVector() {
        int n = this.m_sbBuffer.length();
        while (this.m_sbBuffer.length() > 0) {
            int n2 = n - this.m_sbBuffer.length();
            StringBuffer stringBuffer = this.buildNextToken();
            if (stringBuffer.length() <= 0) continue;
            this.m_vTokens.addElement(stringBuffer);
            this.m_vTokenPosition.addElement(new Integer(n2));
        }
        this.m_iCurrentToken = 0;
    }

    public StringBuffer getRemaining() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_iCurrentToken >= this.m_vTokenPosition.size()) {
            return stringBuffer;
        }
        Integer n = (Integer)this.m_vTokenPosition.elementAt(this.m_iCurrentToken);
        int n2 = n;
        int n3 = this.m_sbOriginal.length();
        char[] cArray = new char[n3 - n2];
        this.m_sbOriginal.getChars(n2, n3, cArray, 0);
        stringBuffer.append(cArray);
        return stringBuffer;
    }

    public StringBuffer nextToken() {
        if (this.m_iCurrentToken < this.m_vTokens.size()) {
            return (StringBuffer)this.m_vTokens.elementAt(this.m_iCurrentToken++);
        }
        return null;
    }

    public boolean hasMoreTokens() {
        return this.m_iCurrentToken < this.m_vTokens.size();
    }

    public void putBackToken() {
        if (this.m_iCurrentToken > 0) {
            --this.m_iCurrentToken;
        }
    }

    protected StringBuffer buildNextToken() {
        int n = 0;
        boolean bl = false;
        int n2 = this.m_sbBuffer.length();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        while (n < n2) {
            char c = this.m_sbBuffer.charAt(n++);
            if (this.m_bReturnQuotedStrings && this.isQuote(c, this.m_sbQuotes, true)) {
                if (stringBuffer.length() == 0) {
                    return this.getQuotedToken(c, n);
                }
                this.removeChars(n - 1);
                return stringBuffer;
            }
            if (this.isDelimeter(c, this.m_sbDelims)) {
                if (this.isDelimeter(c, this.m_sbReturnableDelims)) {
                    bl2 = true;
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append(c);
                        this.removeChars(n);
                        return stringBuffer;
                    }
                    this.removeChars(n - 1);
                    return stringBuffer;
                }
                if (stringBuffer.length() <= 0) continue;
                this.removeChars(n);
                return stringBuffer;
            }
            stringBuffer.append(c);
        }
        this.removeChars(n);
        return stringBuffer;
    }

    public StringBuffer getQuotedToken(char c, int n) {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.isDelimeter(c, this.m_sbRetQuotes);
        if (bl) {
            stringBuffer.append(c);
        }
        int n2 = this.m_sbBuffer.length();
        int n3 = 1;
        do {
            c2 = this.m_sbBuffer.charAt(n++);
            if (this.m_escapeChar != '\u0000' && c2 == this.m_escapeChar) {
                if (n >= n2) continue;
                c2 = this.m_sbBuffer.charAt(n++);
                stringBuffer.append(c2);
                continue;
            }
            if (this.isEndQuote(c2, c)) {
                if (--n3 <= 0) continue;
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c2);
            if (c2 != c) continue;
            ++n3;
        } while (n < n2 && n3 > 0);
        this.removeChars(n);
        if (bl) {
            stringBuffer.append(c2);
        }
        return stringBuffer;
    }

    public boolean isQuote(char c, StringBuffer stringBuffer, boolean bl) {
        int n = stringBuffer.length();
        int n2 = 0;
        if (!bl) {
            n2 = 1;
        }
        while (n2 < n) {
            char c2 = stringBuffer.charAt(n2);
            if (c == c2) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public boolean isEndQuote(char c, char c2) {
        int n = this.m_sbQuotes.length();
        int n2 = 0;
        while (n2 < n - 1) {
            char c3 = this.m_sbQuotes.charAt(n2);
            if (c2 == c3 && c == this.m_sbQuotes.charAt(n2 + 1)) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public boolean isDelimeter(char c, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        while (n > 0) {
            char c2 = stringBuffer.charAt(n - 1);
            if (c == c2) {
                return true;
            }
            --n;
        }
        return false;
    }

    private void removeChars(int n) {
        int n2 = this.m_sbBuffer.length();
        if (n2 == n) {
            this.m_sbBuffer.setLength(0);
            return;
        }
        int n3 = n2 - n;
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        char[] cArray = new char[n2 - n];
        this.m_sbBuffer.getChars(n, n2, cArray, 0);
        stringBuffer.append(cArray);
        this.m_sbBuffer = stringBuffer;
    }
}

