/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.Provider;
import com.novell.webaccess.common.ProviderLoader;
import com.novell.webaccess.common.Session;
import com.novell.webaccess.common.njFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class SessionManager
implements Runnable {
    private static final int DEFAULT_TIMEOUT = 600000;
    private static final int DEFAULT_TIMEOUT_LIFE = 86400000;
    private static final int DEFAULT_TIMEOUT_INTERVAL = 60000;
    private static final int DEFAULT_CLEANUP_INTERVAL = 60;
    private static final String TIMEOUT_FILE_EXTENSION = ".tmp";
    private static final String TIMEOUT_FILTER = "*.tmp";
    private Hashtable m_pSessionList = new Hashtable();
    private Hashtable m_pCookieSessions = new Hashtable();
    private long m_lTimeout = 600000L;
    private int m_iMaximumUsers = 0;
    private String m_sRedirectURL = null;
    private String m_sTimeoutPath = null;
    private Thread m_sessionThread = null;
    private boolean m_bUseClientIP = true;
    private String m_TrustedServer = null;
    private static byte m_bContextMask1 = 0;
    private static byte m_bContextMask2 = (byte)-1;
    private static int m_iUniqueCookie = 0;

    public void init(Properties properties) {
        String string;
        try {
            string = (String)((Hashtable)properties).get("Security.UseClientIP.enable");
            if (string != null && string.equalsIgnoreCase("false")) {
                this.m_bUseClientIP = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_lTimeout = Long.parseLong((String)((Hashtable)properties).get("Security.timeout"));
            this.m_lTimeout *= 60000L;
        }
        catch (Exception exception) {
            this.m_lTimeout = 600000L;
        }
        this.m_TrustedServer = (String)((Hashtable)properties).get("Security.Authenticate.header");
        string = (String)((Hashtable)properties).get("Security.Timeout.path");
        if (string != null) {
            njFile njFile2 = new njFile(string);
            try {
                string = njFile2.getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!njFile2.isDirectory() && !njFile2.mkdirs()) {
                System.out.println("Bad directory name for security timeout files");
            }
            this.m_sTimeoutPath = string;
            if (!this.m_sTimeoutPath.endsWith("\\") && !this.m_sTimeoutPath.endsWith("/")) {
                this.m_sTimeoutPath = this.m_sTimeoutPath + njFile.separator;
            }
        }
        if ((string = (String)((Hashtable)properties).get("load.max.users")) != null) {
            try {
                this.m_iMaximumUsers = new Integer(string);
            }
            catch (Exception exception) {
                this.m_iMaximumUsers = 0;
            }
        }
        if ((string = (String)((Hashtable)properties).get("load.redirect.url")) != null) {
            this.m_sRedirectURL = string;
        } else {
            this.m_iMaximumUsers = 0;
        }
        this.cleanup(0L);
    }

    public void destroy() {
        Enumeration enumeration = this.m_pSessionList.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Session session = (Session)this.m_pSessionList.get(string);
            session.destroy(1);
        }
        this.cleanup(0L);
    }

    public void start() {
        this.m_sessionThread = new Thread(this);
        this.m_sessionThread.start();
    }

    public void stop() {
        this.m_sessionThread.stop();
    }

    public Session getSession(HttpServletRequest httpServletRequest) {
        I18NServletRequest i18NServletRequest = (I18NServletRequest)httpServletRequest;
        String string = i18NServletRequest.getSessionCookie();
        Session session = this.getSessionByCookie(string);
        if (session == null) {
            // empty if block
        }
        ((I18NServletRequest)httpServletRequest).setSessionByCookie(true);
        return session;
    }

    public Session getSession(HttpServletRequest httpServletRequest, String string) {
        int n = 0;
        Session session = null;
        String string2 = null;
        long l = 0L;
        Object var8_7 = null;
        I18NServletRequest i18NServletRequest = (I18NServletRequest)httpServletRequest;
        if (string == null) {
            session = this.getSession(httpServletRequest);
        } else {
            String string3;
            string2 = httpServletRequest.getParameter(string);
            if (string2 == null && (string3 = httpServletRequest.getPathInfo()) != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "/,");
                    string2 = stringTokenizer.nextToken();
                    if (httpServletRequest.getServletPath().endsWith(string2)) {
                        string2 = stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : null;
                    }
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            if (string2 == null) {
                if (this.getRedirectThreshhold() != 0 && this.getCount() >= this.getRedirectThreshhold()) {
                    return null;
                }
                return this.createSession(httpServletRequest, null);
            }
            session = (Session)this.m_pSessionList.get(string2);
        }
        if (session != null) {
            if (session.useCookie() && !session.getSessionCookie().equals(i18NServletRequest.getSessionCookie())) {
                n |= 0x10;
            }
            if (this.m_bUseClientIP) {
                l = SessionManager.generateHash(httpServletRequest, 0L);
                if (session.getHash() != l) {
                    n |= 8;
                }
            }
            if (n != 0) {
                session = this.createSession(httpServletRequest, null);
                session.setFlags(n);
            }
            session.setLastAccessedTime();
            ((I18NServletRequest)httpServletRequest).setSessionByCookie(false);
            return session;
        }
        n = this.loadTimedOutSession(httpServletRequest, i18NServletRequest, string2, n);
        session = (Session)this.m_pSessionList.get(string2);
        if (session == null || n != 0) {
            session = this.createSession(httpServletRequest, null);
            session.setLoggedIn(false);
            session.setFlags(n);
        }
        return session;
    }

    private int loadTimedOutSession(HttpServletRequest httpServletRequest, I18NServletRequest i18NServletRequest, String string, int n) {
        if (this.m_sTimeoutPath != null && string != null) {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            String string2 = this.m_sTimeoutPath + string + TIMEOUT_FILE_EXTENSION;
            try {
                fileInputStream = new FileInputStream(string2);
                objectInputStream = new ObjectInputStream(fileInputStream);
                Session session = (Session)objectInputStream.readObject();
                if (!session.getLoggedIn()) {
                    this.RemoveSessionTimeoutFile(session);
                    return n |= 8;
                }
                session.setSessionManager(this);
                if (session.useCookie()) {
                    i18NServletRequest.synchronizeSessionCookie(session);
                    if (!session.getSessionCookie().equals(i18NServletRequest.getSessionCookie())) {
                        n |= 0x10;
                        session = null;
                    }
                }
                if (session != null && this.m_bUseClientIP) {
                    long l = SessionManager.generateHash(httpServletRequest, 0L);
                    if (session.getHash() != l) {
                        n |= 8;
                        session = null;
                    }
                }
                if (session != null) {
                    this.m_pSessionList.put(string, session);
                    this.m_pCookieSessions.put(session.getSessionCookie(), session);
                    String string3 = httpServletRequest.getRemoteAddr();
                    String string4 = httpServletRequest.getRemoteHost();
                    if (this.m_TrustedServer == null || this.m_TrustedServer.indexOf(string4) == -1 && this.m_TrustedServer.indexOf(string3) == -1) {
                        session.setFlags(3);
                        session.setLoggedIn(false);
                    } else {
                        session.setFlags(1);
                        session.setLoggedIn(false);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InvalidClassException invalidClassException) {
                invalidClassException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                n |= 8;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n |= 8;
            }
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        } else {
            n = 8;
        }
        return n;
    }

    public Session getSessionByCookie(String string) {
        return (Session)this.m_pCookieSessions.get(string);
    }

    public Session getSessionById(String string) {
        return (Session)this.m_pSessionList.get(string);
    }

    public Session createSession(HttpServletRequest httpServletRequest, String string) {
        Session session = null;
        String string2 = null;
        if (string == null) {
            string = SessionManager.generateContext(System.currentTimeMillis());
        }
        long l = SessionManager.generateHash(httpServletRequest, 0L);
        string2 = SessionManager.generateSessionCookie(httpServletRequest);
        session = new Session(string, l, string2);
        session.setSessionManager(this);
        session.setMaxInactiveInterval((int)(this.m_lTimeout / 1000L));
        ((I18NServletRequest)httpServletRequest).setSessionByCookie(false);
        this.m_pSessionList.put(string, session);
        this.m_pCookieSessions.put(string2, session);
        return session;
    }

    public void invalidate(Session session) {
        this.m_pSessionList.remove(session.getId());
        this.m_pCookieSessions.remove(session.getSessionCookie());
        Enumeration enumeration = session.getProviders();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            ProviderLoader.removeProviderContext(provider);
        }
        this.RemoveSessionTimeoutFile(session);
    }

    void RemoveSessionTimeoutFile(Session session) {
        if (this.m_sTimeoutPath != null) {
            String string = this.m_sTimeoutPath + session.getId() + TIMEOUT_FILE_EXTENSION;
            try {
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getRedirectURL() {
        if (this.m_iMaximumUsers != 0 && this.m_sRedirectURL != null) {
            return this.m_sRedirectURL;
        }
        return null;
    }

    public int getRedirectThreshhold() {
        return this.m_iMaximumUsers;
    }

    public int getCount() {
        return this.m_pSessionList.size();
    }

    public Hashtable getSessionList() {
        return this.m_pSessionList;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        int n = 60;
        while (true) {
            Session session;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                return;
            }
            int n2 = 0;
            long l = System.currentTimeMillis();
            Enumeration enumeration = this.m_pSessionList.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                session = (Session)this.m_pSessionList.get(string);
                int n3 = session.getMaxInactiveInterval();
                long l2 = n3 == 0 ? this.m_lTimeout : (long)(n3 * 1000);
                if (l - session.getLastAccessedTime() <= l2 || l2 <= 0L) continue;
                session = (Session)this.m_pSessionList.remove(string);
                this.m_pCookieSessions.remove(session.getSessionCookie());
                Enumeration enumeration2 = session.getProviders();
                while (enumeration2.hasMoreElements()) {
                    object = (Provider)enumeration2.nextElement();
                    ProviderLoader.removeProviderContext((Provider)object);
                }
                session.destroy(2);
                if (this.m_sTimeoutPath != null) {
                    object = null;
                    ObjectOutputStream objectOutputStream = null;
                    String string2 = this.m_sTimeoutPath + string + TIMEOUT_FILE_EXTENSION;
                    try {
                        object = new FileOutputStream(string2);
                        objectOutputStream = new ObjectOutputStream((OutputStream)object);
                        objectOutputStream.writeObject(session);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                    }
                    catch (NotSerializableException notSerializableException) {
                        notSerializableException.printStackTrace();
                    }
                    catch (InvalidClassException invalidClassException) {
                        invalidClassException.printStackTrace();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            session = null;
            if (this.m_sTimeoutPath != null && --n <= 0) {
                n = 60;
                this.cleanup(86400000L);
            }
            if (n2 <= 0) continue;
            System.runFinalization();
        }
    }

    private static String generateContext(long l) {
        char[] cArray = new char[12];
        SessionManager.calculateContext(cArray, 0, m_bContextMask2, 'c', 'j');
        SessionManager.calculateContext(cArray, 2, (byte)(l & 0xFFL), 'g', 'k');
        SessionManager.calculateContext(cArray, 4, (byte)(l >>> 24 & 0xFFL), 'K', 'a');
        SessionManager.calculateContext(cArray, 6, (byte)(l >>> 8 & 0xFFL), 'f', 'h');
        SessionManager.calculateContext(cArray, 8, (byte)(l >>> 16 & 0xFFL), 'b', 'd');
        SessionManager.calculateContext(cArray, 10, m_bContextMask1, 'A', 'i');
        m_bContextMask1 = (byte)(m_bContextMask1 + 4);
        m_bContextMask2 = (byte)(m_bContextMask2 - 13);
        return new String(cArray);
    }

    private static void calculateContext(char[] cArray, int n, byte by, char c, char c2) {
        cArray[n] = (char)((byte)c + (by >>> 4 & 0xF));
        cArray[n + 1] = (char)((byte)c2 + (by & 0xF));
    }

    private static long generateHash(HttpServletRequest httpServletRequest, long l) {
        String string = httpServletRequest.getRemoteAddr();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            long l2 = 0L;
            if (((l ^= (long)string.charAt(n2)) & Integer.MIN_VALUE) != 0L) {
                ++l2;
            }
            l <<= 1;
            l += l2;
            ++n2;
        }
        return l;
    }

    public static String generateSessionCookie(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRemoteAddr();
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(System.currentTimeMillis()));
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = string.indexOf(46);
        while (n2 >= 0) {
            stringBuffer2.setCharAt(n2, stringBuffer.charAt(--n));
            n2 = string.indexOf(46, n2 + 1);
        }
        String string2 = String.valueOf(++m_iUniqueCookie);
        if (++m_iUniqueCookie > 1000) {
            m_iUniqueCookie = 0;
        }
        stringBuffer.setLength(n);
        stringBuffer2.append((Object)stringBuffer);
        stringBuffer2.append(string2);
        return stringBuffer2.toString();
    }

    private void cleanup(long l) {
        block8: {
            if (this.m_sTimeoutPath != null) {
                String[] stringArray = null;
                try {
                    File file = new File(this.m_sTimeoutPath);
                    stringArray = file.list();
                    if (stringArray == null) break block8;
                    int n = stringArray.length;
                    long l2 = System.currentTimeMillis();
                    int n2 = 0;
                    while (n2 < n) {
                        if (stringArray[n2].endsWith(TIMEOUT_FILE_EXTENSION)) {
                            try {
                                File file2 = new File(this.m_sTimeoutPath + stringArray[n2]);
                                if (l2 - file2.lastModified() > l) {
                                    file2.delete();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

