/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.BaseServlet;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.Variable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class VariableList {
    Hashtable m_locals = new Hashtable();
    Hashtable m_globals = new Hashtable();
    Properties m_propUser = null;
    Properties m_propProvider = null;
    Properties m_cfgProperties = null;
    ServletRequest m_request = null;
    ServletRequest m_rootRequest = null;

    public VariableList(Properties properties, Properties properties2, ServletRequest servletRequest, Properties properties3) {
        this.m_propUser = properties;
        this.m_propProvider = properties2;
        this.m_request = servletRequest;
        this.m_rootRequest = ((I18NServletRequest)servletRequest).getRootHttpServletRequest();
        this.m_cfgProperties = properties3;
    }

    public VariableList() {
    }

    VariableList(Properties properties, Properties properties2, ServletRequest servletRequest, Properties properties3, Hashtable hashtable) {
        this.m_request = servletRequest;
        this.m_rootRequest = ((I18NServletRequest)servletRequest).getRootHttpServletRequest();
        this.m_locals = hashtable;
        this.m_propUser = properties;
        this.m_propProvider = properties2;
        this.m_cfgProperties = properties3;
    }

    public String getHeader(String string) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.m_request;
        return httpServletRequest.getHeader(string);
    }

    public synchronized Variable get(Object object) {
        Object object2;
        String string = null;
        String string2 = (String)object;
        if (!BaseServlet.isServletVersionAbove(2, 0)) {
            object2 = this.m_locals.get(object);
            if (object2 != null) {
                return (Variable)object2;
            }
        } else if (this.m_request != null && (object2 = this.m_request.getAttribute(string2)) != null) {
            if (object2 instanceof Variable) {
                return (Variable)object2;
            }
            string = object2.toString();
            if (string != null) {
                return new Variable(string);
            }
        }
        if ((string = this.m_propProvider.getProperty(string2)) != null) {
            return new Variable(string);
        }
        string = this.m_propProvider.getProperty(string2 + ".x");
        if (string != null) {
            return new Variable(string);
        }
        string = this.m_cfgProperties.getProperty(string2);
        if (string != null) {
            return new Variable(string);
        }
        if (this.m_request != null) {
            string = this.m_request.getParameter(string2);
            if (string != null) {
                return new Variable(string);
            }
            string = this.m_request.getParameter(string2 + ".x");
            if (string != null) {
                return new Variable(string);
            }
        }
        if (this.m_request != null) {
            try {
                object2 = (HttpServletRequest)this.m_request;
                string = object2.getHeader(string2);
                if (string != null) {
                    return new Variable(string);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.m_propUser != null && (string = this.m_propUser.getProperty(string2)) != null) {
            return new Variable(string);
        }
        return null;
    }

    public synchronized void put(Object object, Variable variable) {
        if (!BaseServlet.isServletVersionAbove(2, 0)) {
            this.m_locals.put(object, variable);
        } else {
            this.m_request.setAttribute((String)object, (Object)variable);
            this.m_rootRequest.setAttribute((String)object, (Object)variable);
        }
    }

    public synchronized void putGlobal(Object object, Variable variable) {
        ((Hashtable)this.m_propUser).put(object, variable.getStringValue());
    }

    public String toString() {
        Variable variable;
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = null;
        Vector<String> vector = new Vector<String>(100, 20);
        Enumeration enumeration = this.m_locals.keys();
        Enumeration enumeration2 = null;
        if (!BaseServlet.isServletVersionAbove(2, 0)) {
            stringBuffer.append("\n============ Local variables ============\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                variable = this.get(string);
                stringBuffer.append(string + "=" + variable.getStringValue() + "\n");
            }
            vector.removeAllElements();
        } else if (this.m_request != null) {
            enumeration = this.m_request.getAttributeNames();
            stringBuffer.append("\n============ Local variables ============\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(string + "=" + this.m_request.getAttribute(string).toString() + "\n");
            }
            vector.removeAllElements();
        }
        if (this.m_propProvider != null) {
            enumeration = this.m_propProvider.propertyNames();
            stringBuffer.append("\n\n======= Provider variables =======\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(string + "=" + this.m_propProvider.getProperty(string) + "\n");
            }
            vector.removeAllElements();
        }
        if (this.m_cfgProperties != null) {
            enumeration = this.m_cfgProperties.propertyNames();
            stringBuffer.append("\n\n======= Configuration variables =======\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.indexOf("password") != -1 || string.indexOf("Password") != -1 || string.indexOf("PASSWORD") != -1 || string.indexOf("PWD") != -1 || string.indexOf("Pwd") != -1 || string.indexOf("pwd") != -1) continue;
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(string + "=" + this.m_cfgProperties.getProperty(string) + "\n");
            }
            vector.removeAllElements();
        }
        if (this.m_request != null) {
            enumeration = this.m_request.getParameterNames();
            stringBuffer.append("\n======== HTTP request parameters ========\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(string + "=" + this.m_request.getParameter(string) + "\n");
            }
            vector.removeAllElements();
            try {
                variable = (HttpServletRequest)this.m_request;
                enumeration = variable.getHeaderNames();
                stringBuffer.append("\n======== HTTP request headers ========\n");
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    vector.addElement(string);
                }
                VariableList.sortStringVector(vector);
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                    stringBuffer.append(string + "=" + variable.getHeader(string) + "\n");
                }
                vector.removeAllElements();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.m_propUser != null) {
            enumeration = this.m_propUser.propertyNames();
            stringBuffer.append("\n\n======= User/Global variables =======\n");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            VariableList.sortStringVector(vector);
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                stringBuffer.append(string + "=" + this.m_propUser.getProperty(string) + "\n");
            }
            vector.removeAllElements();
        }
        return new String(stringBuffer);
    }

    public static void sortStringVector(Vector vector) {
        boolean bl;
        String string = null;
        String string2 = null;
        int n = vector.size();
        do {
            bl = false;
            int n2 = 0;
            while (n2 < n - 1) {
                string = (String)vector.elementAt(n2);
                if (string.compareTo(string2 = (String)vector.elementAt(n2 + 1)) > 0) {
                    vector.setElementAt(string2, n2);
                    vector.setElementAt(string, n2 + 1);
                    bl = true;
                }
                ++n2;
            }
        } while (bl);
    }

    public Object clone() {
        return new VariableList(this.m_propUser, this.m_propProvider, this.m_request, this.m_cfgProperties, this.m_locals);
    }
}

