/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ClearLockoutTask
extends Task {
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        String targetName = eMFrameUtils.getSingleTarget((HttpServletRequest)this.req);
        try {
            TargetObjects objTargets;
            if ((nextState == null || nextState.equalsIgnoreCase("initialState") && targetName != null && targetName.length() > 0) && (objTargets = new TargetObjects(targetName, context)).getCount() > 0) {
                ((I18NServletRequest)this.req).setParameter("merge", "dev.GenConf");
                ((I18NServletRequest)this.req).setParameter("error", "dev.GenFatal");
                return this.doClearLockout(objTargets.getObjectEntry().getFullName());
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        if (nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doClearLockout")) {
            try {
                String targetNames = this.req.getParameter("eDir$target");
                if (targetNames != null) {
                    TargetObjects objTargets = new TargetObjects(targetNames, context);
                    Exception[] errors = objTargets.getErrors();
                    if (errors != null && errors.length > 0) {
                        D.log((Throwable)errors[0]);
                        if (errors[0] instanceof UniqueSPIException) {
                            this.setUIPage("base/ClrLock.jsp");
                            this.showInitialForm();
                            eMFrameUtils.setErrorMessage((Throwable)errors[0], (MContext)context);
                            return false;
                        }
                    }
                    if (objTargets.getCount() > 0) {
                        return this.doClearLockout(objTargets.getObjectEntry().getFullName());
                    }
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        throw new RuntimeException("Task received invalid nextState:" + nextState);
    }

    private boolean showInitialForm() {
        eMFrameUtils.setupTargetChooser((String[])new String[]{"User"}, (MContext)this.context);
        return true;
    }

    private boolean doClearLockout(String strUserName) {
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry oeUser = null;
        try {
            oeUser = namespace.getObjectEntry(treeOE, strUserName);
        }
        catch (SPIException e) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.Failure", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.UserNotFound", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
            return false;
        }
        if (!DirUtils.isOfType((ObjectType)oeUser.getObjectType(), (String)"User", (boolean)true)) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.Failure", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotAUser", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
            return false;
        }
        try {
            this.context.addToHistory(oeUser);
            if (!this.setBooleanAttribute(oeUser, "Locked By Intruder", false, true)) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.NotPerformed", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.NotPerformedForUser", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
                return true;
            }
            this.setCounterAttribute(oeUser, "Login Intruder Attempts", 0, true);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.Success", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ClearLockout.SuccessForUser", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName);
        return true;
    }

    boolean setCounterAttribute(ObjectEntry userOE, String attrName, int value, boolean bNoAttrEqualsSuccess) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        NDSNamespace ns = (NDSNamespace)userOE.getObjectType().getNamespace();
        boolean changeNeeded = false;
        ObjectAttribute objAttr = null;
        try {
            objAttr = ns.getAttribute(userOE, attrName);
        }
        catch (SPIException ex) {
            objAttr = null;
        }
        ValueComponent newValue = NDSSyntax.SYN_COUNTER.createValueComponent((Object)new Integer(value));
        if (objAttr == null) {
            if (bNoAttrEqualsSuccess) {
                return false;
            }
            AttributeDefinition attrDef = ns.getAttributeDefinition(userOE, attrName);
            objAttr = new ObjectAttribute(attrDef);
            objAttr.addComponent(newValue);
            changeNeeded = true;
        } else {
            Enumeration valueSet = objAttr.getValueComponents();
            if (valueSet.hasMoreElements()) {
                ValueComponent oldValue = (ValueComponent)valueSet.nextElement();
                if (!oldValue.equals((Object)newValue)) {
                    objAttr.replaceComponent(oldValue, newValue);
                    changeNeeded = true;
                }
            } else {
                objAttr.addComponent(newValue);
                changeNeeded = true;
            }
        }
        if (changeNeeded) {
            ns.setAttribute(userOE, objAttr);
        }
        return changeNeeded;
    }

    boolean setBooleanAttribute(ObjectEntry userOE, String attrName, boolean value, boolean bNoAttrEqualsSuccess) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        NDSNamespace ns = (NDSNamespace)userOE.getObjectType().getNamespace();
        boolean changeNeeded = false;
        ObjectAttribute objAttr = null;
        try {
            objAttr = ns.getAttribute(userOE, attrName);
        }
        catch (SPIException ex) {
            objAttr = null;
        }
        ValueComponent newValue = NDSSyntax.SYN_BOOLEAN.createValueComponent((Object)new Boolean(value));
        if (objAttr == null) {
            if (bNoAttrEqualsSuccess) {
                return false;
            }
            AttributeDefinition attrDef = ns.getAttributeDefinition(userOE, attrName);
            objAttr = new ObjectAttribute(attrDef);
            objAttr.addComponent(newValue);
            changeNeeded = true;
        } else {
            Enumeration valueSet = objAttr.getValueComponents();
            if (valueSet.hasMoreElements()) {
                ValueComponent oldValue = (ValueComponent)valueSet.nextElement();
                if (!oldValue.equals((Object)newValue)) {
                    objAttr.replaceComponent(oldValue, newValue);
                    changeNeeded = true;
                }
            } else {
                objAttr.addComponent(newValue);
                changeNeeded = true;
            }
        }
        if (changeNeeded) {
            ns.setAttribute(userOE, objAttr);
        }
        return changeNeeded;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

