/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreateObjectUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;

public class CloneObjectTask
extends Task {
    public static final String HTMLPARAM_SOURCEOBJECT = "SourceObjectName";
    public static final String HTMLPARAM_COPYTYPE = "copytype";
    public static final String HTMLPARAM_TARGETOBJECT = "TargetObjectName";
    public static final String HTMLPARAM_TARGETCONTEXT = "TargetContextName";
    public static final String HTMLPARAM_UPDATEOBJECT = "UpdateObjectName";
    public static final String HTMLPARAM_UPDATEACLS = "UpdateExpAcls";
    public static final String HTMLPARAM_SEARCHCONTEXT = "SearchContextName";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    AdminNamespace ns;
    private ArrayList nonElligibleAttrList = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log((String)"execute start");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        D.log((String)("nextState = " + nextState));
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCloneObject")) {
            try {
                D.log((String)"doCloneObject");
                return this.doCloneObject();
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return false;
            }
        }
        D.log((String)("Task received invalid state " + nextState));
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        String[] ovSelectedObject = null;
        String ovTargets = this.req.getParameter("targetNames");
        if (null != ovTargets && ovTargets.length() > 0) {
            ovSelectedObject = eMFrameUtils.unpack((String)ovTargets, (MContext)this.context);
            this.resultStrings.put("targetNames", ovSelectedObject[0]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCloneObject() {
        String[] stringArray;
        String strBody;
        String strTitle8;
        D.log((String)"doCloneObject::start");
        String sourceObject = this.req.getParameter(HTMLPARAM_SOURCEOBJECT);
        boolean create = this.req.getParameter(HTMLPARAM_COPYTYPE).equalsIgnoreCase("create");
        String targetObject = this.req.getParameter(HTMLPARAM_TARGETOBJECT);
        String targetContext = this.req.getParameter(HTMLPARAM_TARGETCONTEXT);
        String updateObject = this.req.getParameter(HTMLPARAM_UPDATEOBJECT);
        String updateExpAcls = this.req.getParameter(HTMLPARAM_UPDATEACLS);
        String searchContext = this.req.getParameter(HTMLPARAM_SEARCHCONTEXT);
        this.nonElligibleAttrList = new ArrayList();
        int derefAlias = 1;
        ObjectEntry targetOE = null;
        ObjectEntry uoe = null;
        try {
            NSObject snso;
            ObjectEntry soe;
            AuthenticationBroker broker = this.context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.ns = (AdminNamespace)treeOE.getNamespace();
            if (this.ns instanceof NDSNamespace) {
                derefAlias = ((NDSNamespace)this.ns).getAliasDereference();
                ((NDSNamespace)this.ns).setAliasDereference(2);
            }
            try {
                soe = this.ns.getObjectEntry(sourceObject);
                snso = this.ns.getDetails(soe);
            }
            catch (SPIException e) {
                D.log((Throwable)e);
                String strTitle2 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateError", (MContext)this.context);
                String strBody2 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.SourceNotFound", (MContext)this.context);
                eMFrameUtils.setMessage((String)"error", (String)strTitle2, (String)eMFrameUtils.formatMessage((String)strBody2, (Object[])new String[]{sourceObject}), (MContext)this.context);
                boolean bl = false;
                try {
                    if (this.ns instanceof NDSNamespace) {
                        ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                    }
                }
                catch (NamespaceException e2) {
                    return false;
                }
                return bl;
            }
            ClassDefinition[] classDefs = snso.getClassDefinitions();
            String classType = classDefs[0].getName();
            D.log((String)("doCloneObject::classType: " + classType));
            boolean updateGID = false;
            long updateGIDto = 0L;
            Syntax longValueSynatax = null;
            ArrayList<String> classes = new ArrayList<String>();
            for (int j = 0; j < classDefs.length; ++j) {
                classes.add(classDefs[j].getName());
            }
            if (classes.contains("Group") && classes.contains("posixGroup") && classes.contains("uamPosixGroup")) {
                long endGID = 0L;
                long lastGID = 0L;
                long nextGID = 0L;
                boolean found = false;
                String filter = "(objectClass=uamPosixConfig*)";
                SearchControls sc = new SearchControls(2, 0L, 0, new String[]{"givenName", "SN"}, false, false);
                LdapContext lctx = null;
                lctx = (LdapContext)broker.getAPIObject("JndiLdap", (Properties)null);
                NamingEnumeration<SearchResult> ne = lctx.search("", filter, sc);
                while (ne != null && ne.hasMoreElements() && !found) {
                    LongValue assigval;
                    ObjectAttribute endGIDAttr;
                    Enumeration endvalues;
                    Value ev;
                    LongValue elv;
                    NSObject nsobjentry;
                    ObjectEntry objentry;
                    SearchResult sr = (SearchResult)ne.nextElement();
                    String name = sr.getName();
                    String ndapName = MappingObject.LDAPNameToNDSName((String)name);
                    try {
                        objentry = this.ns.getObjectEntry(ndapName);
                        nsobjentry = this.ns.getDetails(objentry);
                    }
                    catch (SPIException e) {
                        D.log((Throwable)e);
                        String strTitle3 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateError", (MContext)this.context);
                        String strBody3 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.SourceNotFound", (MContext)this.context);
                        eMFrameUtils.setMessage((String)"error", (String)strTitle3, (String)eMFrameUtils.formatMessage((String)strBody3, (Object[])new String[]{sourceObject}), (MContext)this.context);
                        boolean bl = false;
                        try {
                            if (this.ns instanceof NDSNamespace) {
                                ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                            }
                        }
                        catch (NamespaceException e3) {
                            return false;
                        }
                        return bl;
                    }
                    ObjectAttribute assiGIDAttrvalue = nsobjentry.getAttribute("uamPosixGidNumberLastAssigned");
                    Enumeration values = assiGIDAttrvalue.getValueComponents();
                    Value gv = (Value)values.nextElement();
                    LongValue glv = (LongValue)gv;
                    longValueSynatax = glv.getSyntax();
                    lastGID = glv.getValue();
                    if (lastGID > (endGID = (elv = (LongValue)(ev = (Value)(endvalues = (endGIDAttr = nsobjentry.getAttribute("uamPosixGidNumberEnd")).getValueComponents()).nextElement())).getValue())) continue;
                    nextGID = lastGID + 1L;
                    LongValue assgidVal = assigval = new LongValue(longValueSynatax, nextGID);
                    assiGIDAttrvalue.replaceComponent((ValueComponent)assgidVal);
                    this.ns.setAttribute(objentry, assiGIDAttrvalue);
                    this.ns.getAttribute(objentry, "uamPosixGidNumberLastAssigned");
                    updateGID = true;
                    updateGIDto = nextGID;
                }
            }
            AttributeDefinition[] namingAttrs = classDefs[0].getNamingAttributes();
            if (create) {
                ObjectEntry parentEntry;
                try {
                    if (targetContext.equalsIgnoreCase("[root]")) {
                        targetContext = treeOE.getName();
                    }
                    parentEntry = treeOE.getName().equalsIgnoreCase(targetContext) ? this.ns.getObjectEntry(targetContext) : this.ns.getObjectEntry(treeOE, targetContext);
                }
                catch (SPIException e) {
                    D.log((Throwable)e);
                    String strTitle4 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateError", (MContext)this.context);
                    String strBody4 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.ContainerNotFound", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"error", (String)strTitle4, (String)eMFrameUtils.formatMessage((String)strBody4, (Object[])new String[]{targetContext}), (MContext)this.context);
                    boolean bl = false;
                    try {
                        if (this.ns instanceof NDSNamespace) {
                            ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                        }
                    }
                    catch (NamespaceException e4) {
                        return false;
                    }
                    return bl;
                }
                try {
                    targetOE = this.ns.createObjectEntry(parentEntry, targetObject, classType);
                }
                catch (SPIException e) {
                    D.log((Throwable)e);
                    String strTitle5 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateError", (MContext)this.context);
                    String strBody5 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateErrorMsg", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"error", (String)strTitle5, (String)eMFrameUtils.formatMessage((String)strBody5, (Object[])new String[]{targetObject}), (MContext)this.context);
                    if (this.ns instanceof NDSNamespace) {
                        ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                    }
                    boolean bl = false;
                    try {
                        if (this.ns instanceof NDSNamespace) {
                            ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                        }
                    }
                    catch (NamespaceException e5) {
                        return false;
                    }
                    return bl;
                }
                Vector<Object> targetAttrs = new Vector<Object>();
                String[] sourceAttrs = snso.getAttributes();
                for (int i = 0; i < sourceAttrs.length; ++i) {
                    if (!this.isCloneableAttr(soe, namingAttrs, sourceAttrs[i], create)) continue;
                    if (sourceAttrs[i].equals("gidNumber") && updateGID) {
                        LongValue lv;
                        ObjectAttribute oldGIDAttr = snso.getAttribute(sourceAttrs[i]);
                        LongValue lvc = lv = new LongValue(longValueSynatax, updateGIDto);
                        ObjectAttribute GIDAttr = new ObjectAttribute(oldGIDAttr.getAttributeDefinition(), (ValueComponent)lvc);
                        targetAttrs.addElement(GIDAttr);
                        continue;
                    }
                    targetAttrs.addElement(snso.getAttribute(sourceAttrs[i]));
                }
                if (namingAttrs.length > 0) {
                    for (int j = 0; j < namingAttrs.length; ++j) {
                        if (snso.getAttribute(namingAttrs[j].getName()) == null) continue;
                        AttributeDefinition attrDef = this.ns.getAttributeDefinition(targetOE, namingAttrs[j].getName());
                        Syntax syn = attrDef.getSyntax();
                        targetAttrs.addElement(new NDSObjectAttribute(attrDef, new ValueComponent[]{syn.createValueComponent((Object)targetObject)}));
                    }
                }
                try {
                    this.ns.create(this.ns.createNSObject(targetOE, targetAttrs));
                    this.context.addToHistory(targetOE);
                    this.resultStrings.put("dev.refreshOV", "true");
                    JobData data = JobData.getJobData((GadgetInstance)this);
                    if (null != data) {
                        data.setObjectNames(new String[]{this.ns.getUnrootedName(targetOE)});
                    }
                }
                catch (SPIException e) {
                    D.log((Throwable)e);
                    String strTitle6 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.CreateError", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"error", (String)strTitle6, (String)e.getLocalizedMessage(), (MContext)this.context);
                    if (this.ns instanceof NDSNamespace) {
                        ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                    }
                    boolean syn = false;
                    try {
                        if (this.ns instanceof NDSNamespace) {
                            ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                        }
                    }
                    catch (NamespaceException e6) {
                        return false;
                    }
                    return syn;
                }
                ObjectAttribute acl = snso.getAttribute("ACL");
                if (acl != null) {
                    D.log((String)"doCloneObject::Reading ACLs");
                    CreateObjectUtils.modifyACL((String)sourceObject, (String)this.ns.getUnrootedName(targetOE), (ObjectAttribute)acl);
                    NSObject modNSO = this.ns.getDetails(targetOE);
                    modNSO.deleteAttribute("ACL");
                    this.ns.update(modNSO);
                    modNSO.addAttribute(acl);
                    this.ns.update(modNSO);
                }
            } else {
                ObjectAttribute acl;
                uoe = this.ns.getObjectEntry(updateObject);
                NSObject unso = this.ns.getDetails(uoe);
                ClassDefinition[] updateClassDefs = unso.getClassDefinitions();
                String updateClassType = updateClassDefs[0].getName();
                D.log((String)("doCloneObject::updateClassType: " + updateClassType));
                if (!classType.equalsIgnoreCase(updateClassType)) {
                    D.log((String)"doCloneObject::mismatched class types");
                    String strTitle7 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.TypeMismatchError", (MContext)this.context);
                    String strBody6 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.TypeMismatchErrorMsg", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"error", (String)strTitle7, (String)strBody6, (MContext)this.context);
                    boolean e6 = false;
                    return e6;
                }
                boolean update = false;
                String[] sourceAttrs = snso.getAttributes();
                for (int i = 0; i < sourceAttrs.length; ++i) {
                    if (!this.isCloneableAttr(uoe, namingAttrs, sourceAttrs[i], create)) continue;
                    update = true;
                    ObjectAttribute soa = snso.getAttribute(sourceAttrs[i]);
                    if (unso.getAttribute(sourceAttrs[i]) == null && this.isElligibleForCopy(unso, soa)) {
                        unso.addAttribute(soa);
                        continue;
                    }
                    ObjectAttribute toa = unso.getAttribute(sourceAttrs[i]);
                    if (toa == null) continue;
                    toa.removeAllComponents();
                    Enumeration myenum = soa.getValueComponents();
                    while (myenum.hasMoreElements()) {
                        toa.addComponent((ValueComponent)myenum.nextElement());
                    }
                }
                if (update) {
                    this.ns.update(unso);
                }
                if ((acl = snso.getAttribute("ACL")) != null) {
                    ObjectAttribute tmpACL = CreateObjectUtils.replaceACL((String)sourceObject, (ObjectEntry)uoe, (ObjectAttribute)acl, (AdminNamespace)this.ns);
                    NSObject modNSO = this.ns.getDetails(uoe);
                    modNSO.deleteAttribute("ACL");
                    this.ns.update(modNSO);
                    modNSO.addAttribute(tmpACL);
                    this.ns.update(modNSO);
                }
            }
            if (updateExpAcls != null) {
                FilterResultModifier.FilterItemGroup filterItem = new FilterResultModifier.FilterItemGroup();
                filterItem.addFilterItem("ACL", "~=", "0#subtree#" + sourceObject + "#*", null);
                FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
                filter.addFilterItemGroupPair(filterItem, null);
                FilterResultModifier resultModifier = new FilterResultModifier("", filter, true);
                ObjectEntry oe = this.ns.getObjectEntry(searchContext);
                this.context.addToHistory(oe);
                ObjectEntryEnumeration oee = this.ns.getChildren(oe, (ResultModifier)resultModifier);
                while (oee.hasMoreElements()) {
                    ObjectEntry ooe = oee.next();
                    if (ooe.getName().equalsIgnoreCase(sourceObject)) continue;
                    NSObject nso = this.ns.getDetails(ooe);
                    ObjectAttribute objAcl = nso.getAttribute("ACL");
                    if (create) {
                        CreateObjectUtils.appendACL((String)sourceObject, (String)this.ns.getUnrootedName(targetOE), (ObjectAttribute)objAcl);
                    } else {
                        CreateObjectUtils.appendACL((String)sourceObject, (String)updateObject, (ObjectAttribute)objAcl);
                    }
                    this.ns.update(nso);
                }
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            if (e instanceof NamespaceException && e.getMessage() != null && e.getMessage().equals("BAD_CONTAINMENT")) {
                strTitle8 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.BadContainerTitle", (MContext)this.context);
                strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.BadContainerErrorMsg", (MContext)this.context);
                eMFrameUtils.setMessage((String)"error", (String)strTitle8, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{sourceObject}), (MContext)this.context);
            } else {
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            }
            boolean strTitle8 = false;
            return strTitle8;
        }
        finally {
            try {
                if (this.ns instanceof NDSNamespace) {
                    ((NDSNamespace)this.ns).setAliasDereference(derefAlias);
                }
            }
            catch (NamespaceException e) {
                return false;
            }
        }
        if (create) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = sourceObject;
            stringArray = stringArray2;
            stringArray2[1] = this.ns.getUnrootedName(targetOE);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sourceObject;
            stringArray = stringArray3;
            stringArray3[1] = this.ns.getUnrootedName(uoe);
        }
        String[] display = stringArray;
        if (create) {
            if (targetOE != null) {
                this.context.addToHistory(targetOE.getObjectType().getName(), display[0]);
            }
        } else if (uoe != null) {
            this.context.addToHistory(uoe.getObjectType().getName(), display[1]);
        }
        if (this.nonElligibleAttrList != null && this.nonElligibleAttrList.size() > 0) {
            String notCopied = "[ ";
            for (int count = 0; count < this.nonElligibleAttrList.size(); ++count) {
                if (count > 0) {
                    notCopied = notCopied + " , ";
                }
                notCopied = notCopied + this.nonElligibleAttrList.get(count);
                if (count != this.nonElligibleAttrList.size() - 1) continue;
                notCopied = notCopied + " ]";
            }
            String strTitle9 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.Success", (MContext)this.context);
            String strBody7 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.SuccessForObjectWithNonElligibleList", (MContext)this.context);
            eMFrameUtils.setMessage((String)"success", (String)strTitle9, (String)eMFrameUtils.formatMessage((String)strBody7, (Object[])new String[]{display[0], display[1], notCopied}), (MContext)this.context);
        } else {
            strTitle8 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.Success", (MContext)this.context);
            strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CloneObject.SuccessForObject", (MContext)this.context);
            eMFrameUtils.setMessage((String)"success", (String)strTitle8, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{display[0], display[1]}), (MContext)this.context);
        }
        this.resultStrings.put("GeneralMsg.ShowModifyObject", "true");
        this.resultStrings.put("GeneralMsg.ModifyObjectName", eMFrameUtils.pack((String[])new String[]{display[1]}, (MContext)this.context));
        D.log((String)"doCloneObject: Clone object succeeded");
        return true;
    }

    private boolean isElligibleForCopy(NSObject uso, ObjectAttribute soa) throws NamespaceException {
        String nonElligibleAttr;
        boolean isElligible = false;
        isElligible = uso.isAddPossible(soa, false);
        if (!isElligible && (nonElligibleAttr = soa.getName()) != null) {
            this.nonElligibleAttrList.add(nonElligibleAttr);
        }
        return isElligible;
    }

    private boolean isCloneableAttr(ObjectEntry targetOE, AttributeDefinition[] namingAttrs, String attr, boolean isCreating) throws SPIException, NamespaceException {
        for (int i = 0; i < namingAttrs.length; ++i) {
            if (!attr.equalsIgnoreCase(namingAttrs[i].getName())) continue;
            return false;
        }
        if (this.isReadOnlyAttr(targetOE, attr)) {
            return false;
        }
        if (attr.startsWith("rbs") || attr.equalsIgnoreCase("Security Equals") || attr.equalsIgnoreCase("Group Membership") || attr.equalsIgnoreCase("Member") || attr.equalsIgnoreCase("Equivalent To Me") || attr.equalsIgnoreCase("CN") || attr.equalsIgnoreCase("ACL") || attr.equalsIgnoreCase("groupMember")) {
            return false;
        }
        if (!isCreating && attr.equalsIgnoreCase("Object Class")) {
            return false;
        }
        DirUtils dirUtils = this.context.getDirUtils();
        if ((dirUtils.isOfAuxClass(targetOE, "dynamicGroupAux") || DirUtils.isOfType((ObjectType)targetOE.getObjectType(), (String)"dynamicGroup", (boolean)true)) && attr.equals("Member")) {
            return false;
        }
        return !attr.equalsIgnoreCase("DirXML-Associations");
    }

    private boolean isReadOnlyAttr(ObjectEntry targetOE, String attr) throws SPIException, NamespaceException {
        return this.ns.getAttributeDefinition(targetOE, attr).isReadOnly();
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

