/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class CreateAliasTask
extends Task {
    public static final String HTMLPARAM_FORMNAME = "CreateAliasForm";
    public static final String HTMLPARAM_ALIASOBJECT = "CreateAliasObject";
    public static final String HTMLPARAM_ALIASNAME = "CreateAliasName";
    public static final String HTMLPARAM_ALIASCONTEXT = "CreateAliasContext";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    String objectClass = null;
    private static final String ALIAS_CLASS_NAME = "Alias";
    private static final String OBJECT_CLASS_ATTR_NAME = "Object Class";
    private static final String ALIAS_ATTR_NAME = "Aliased Object Name";

    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log((String)"CreateAliasTask::execute start");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String scripting = this.req.getParameter("scripting");
        if (scripting != null && scripting.equalsIgnoreCase("true")) {
            String aliasObject = this.req.getParameter("scriptParam1");
            String id = this.req.getParameter("scriptParam2");
            String aliasContext = this.req.getParameter("scriptParam3");
            this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
            if (this.objectClass == "") {
                this.objectClass = ALIAS_CLASS_NAME;
            }
            return this.doCreateAlias(this.objectClass, aliasObject, id, aliasContext);
        }
        String nextState = this.req.getParameter("nextState");
        D.log((String)("nextState = " + nextState));
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateAlias")) {
            try {
                D.log((String)"doCreateAlias");
                String aliasObject = this.req.getParameter(HTMLPARAM_ALIASOBJECT);
                String id = this.req.getParameter(HTMLPARAM_ALIASNAME);
                String aliasContext = this.req.getParameter(HTMLPARAM_ALIASCONTEXT);
                return this.doCreateAlias(this.objectClass, aliasObject, id, aliasContext);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                return false;
            }
        }
        D.log((String)("Task received invalid state " + nextState));
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
        if (this.objectClass == null || this.objectClass.length() == 0) {
            this.objectClass = ALIAS_CLASS_NAME;
        }
        this.resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, this.context.getDirUtils().getObjectTypeDisplayName(this.objectClass, (MContext)this.context));
        this.resultStrings.put(HTMLPARAM_GIFNAME, this.context.getDirUtils().getObjectTypeImageName(this.objectClass));
        String[] ovSelectedObject = null;
        String ovTargets = this.req.getParameter("targetNames");
        if (null != ovTargets && ovTargets.length() > 0) {
            ovSelectedObject = eMFrameUtils.unpack((String)ovTargets, (MContext)this.context);
            this.resultStrings.put("targetNames", ovSelectedObject[0]);
        }
        return true;
    }

    private boolean doCreateAlias(String objectClass, String strObject, String strAliasName, String strContext) {
        String modifyName;
        String strAliasName2;
        String strTitle;
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        String newAliasName = strAliasName;
        if (strContext.equalsIgnoreCase("[root]")) {
            strContext = treeOE.getName();
        }
        D.log((String)("CreateAliasTask: Creating: Name: " + newAliasName + ", Object: " + strObject + ", Context: " + strContext));
        ObjectEntry parentEntry = null;
        try {
            parentEntry = treeOE.getName().equalsIgnoreCase(strContext) ? namespace.getObjectEntry(strContext) : namespace.getObjectEntry(treeOE, strContext);
            this.context.addToHistory(parentEntry);
        }
        catch (SPIException e) {
            D.log((Throwable)e);
            String strTitle2 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.Failure", (MContext)this.context);
            String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.ContainerNotFound", (MContext)this.context);
            eMFrameUtils.setMessage((String)"error", (String)strTitle2, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{strContext}), (MContext)this.context);
            return false;
        }
        ObjectEntry objEntry = null;
        try {
            objEntry = namespace.getObjectEntry(treeOE, strObject);
            this.context.addToHistory(objEntry);
            SchemaDefinition sd = null;
            String strObjectType = objEntry.getObjectType().getName();
            sd = namespace.getSchemaDefinition(parentEntry);
            boolean canContain = sd.canContain(parentEntry.getObjectType().getName(), strObjectType);
            if (!canContain) {
                String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.Failure", (MContext)this.context);
                String strBadParentType = eMFrameUtils.getLocalizedString((String)"FwResources", (String)"FwConsts.RES_INVALID_OBJECTTYPE", (MContext)this.context);
                eMFrameUtils.setMessage((String)"error", (String)strFailure, (String)eMFrameUtils.formatMessage((String)strBadParentType, (Object[])new String[]{strObjectType}), (MContext)this.context);
                return false;
            }
        }
        catch (SPIException e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        String strException = null;
        try {
            AdminNamespace adminns = (AdminNamespace)parentEntry.getObjectType().getNamespace();
            this.createAlias(parentEntry, newAliasName, objEntry, adminns);
        }
        catch (NamespaceException nse) {
            D.log((Throwable)nse);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)nse), (MContext)this.context);
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            if (spie instanceof UniqueSPIException && ((UniqueSPIException)spie).getErrorCode() == -613) {
                if (objEntry.getObjectType().getName().equals("Country") || objEntry.getObjectType().getName().equals("C")) {
                    String strTitle3 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.Failure", (MContext)this.context);
                    String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.InvalidCountryName", (MContext)this.context);
                    eMFrameUtils.setMessage((String)"error", (String)strTitle3, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{newAliasName}), (MContext)this.context);
                    return false;
                }
            }
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.context);
            return false;
        }
        catch (SnapinVetoException sve) {
            D.log((Throwable)sve);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), (MContext)this.context);
        }
        catch (ComponentCreationException e) {
            D.log((Throwable)e);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), (MContext)this.context);
        }
        if (null != strException) {
            strTitle = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.Failure", (MContext)this.context);
            String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.FailureExplain", (MContext)this.context);
            eMFrameUtils.setMessage((String)"error", (String)strTitle, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{strException}), (MContext)this.context);
            return false;
        }
        strTitle = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.Success", (MContext)this.context);
        String strBody = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateAlias.SuccessForAlias", (MContext)this.context);
        if (parentEntry.getObjectType().getName().equals("Top")) {
            this.resultStrings.put("dev.refreshOV", "true");
            strAliasName2 = newAliasName + strContext;
            modifyName = newAliasName;
        } else {
            strAliasName2 = newAliasName + "." + parentEntry.getFullName();
            modifyName = newAliasName + "." + strContext;
        }
        eMFrameUtils.setMessage((String)"success", (String)strTitle, (String)eMFrameUtils.formatMessage((String)strBody, (Object[])new String[]{strAliasName2}), (MContext)this.context);
        this.resultStrings.put("GeneralMsg.ShowModifyObject", "true");
        this.resultStrings.put("GeneralMsg.ModifyObjectName", eMFrameUtils.pack((String[])new String[]{modifyName}, (MContext)this.context));
        D.log((String)"CreateAliasTask::CreateAlias Create alias succeeded");
        return true;
    }

    private void createAlias(ObjectEntry parentEntry, String newObjectName, ObjectEntry oldOE, AdminNamespace adminns) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        Object newOE = null;
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ValueComponent aliasNameVal = NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)ALIAS_CLASS_NAME);
        ValueComponent[] aliasNameVals = new ValueComponent[]{aliasNameVal};
        NDSObjectAttribute objClassAttr = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)ns.getAttributeDefinition(oldOE, OBJECT_CLASS_ATTR_NAME)), aliasNameVals);
        ValueComponent distNameVal = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(oldOE));
        ValueComponent[] distNameVals = new ValueComponent[]{distNameVal};
        NDSObjectAttribute aliasNameAttr = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)ns.getAttributeDefinition(oldOE, ALIAS_ATTR_NAME)), distNameVals);
        Vector<NDSObjectAttribute> attrNDSOV = new Vector<NDSObjectAttribute>();
        attrNDSOV.addElement(aliasNameAttr);
        attrNDSOV.addElement(objClassAttr);
        ObjectEntry aliasObjectEntry = ns.createObjectEntry(parentEntry, newObjectName, ALIAS_CLASS_NAME);
        NSObject aliasObj = adminns.createNSObject(aliasObjectEntry, attrNDSOV);
        ns.create(aliasObj);
        this.context.addToHistory(aliasObjectEntry);
    }
}

