/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CreateUserTask
extends Task {
    public static final String HTMLPARAM_FORMNAME = "CreateUserForm";
    public static final String HTMLPARAM_USERCONTEXT = "CreateUserContext";
    public static final String HTMLPARAM_USERNAME = "CreateUserName";
    public static final String HTMLPARAM_USERSURNAME = "CreateUserSurName";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    String objectClass = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log((String)"CreateUserTask::execute start");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String scripting = this.req.getParameter("scripting");
        if (scripting != null && scripting.equalsIgnoreCase("true")) {
            String userContext = this.req.getParameter("scriptParam1");
            String id = this.req.getParameter("scriptParam2");
            String surname = this.req.getParameter("scriptParam3");
            this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
            if (this.objectClass == "") {
                this.objectClass = "User";
            }
            return this.doCreateUser(this.objectClass, userContext, id, surname);
        }
        String nextState = this.req.getParameter("nextState");
        D.log((String)("nextState = " + nextState));
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateUser")) {
            try {
                D.log((String)"doCreateUser");
                String userContext = this.req.getParameter(HTMLPARAM_USERCONTEXT);
                String id = this.req.getParameter(HTMLPARAM_USERNAME);
                String surname = this.req.getParameter(HTMLPARAM_USERSURNAME);
                return this.doCreateUser(this.objectClass, userContext, id, surname);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                return false;
            }
        }
        D.log((String)("Task received invalid state " + nextState));
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
        if (this.objectClass == null || this.objectClass.length() == 0) {
            this.objectClass = "User";
        }
        this.resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, this.context.getDirUtils().getObjectTypeDisplayName(this.objectClass, (MContext)this.context));
        this.resultStrings.put(HTMLPARAM_GIFNAME, this.context.getDirUtils().getObjectTypeImageName(this.objectClass));
        return true;
    }

    private boolean doCreateUser(String objectClass, String strContext, String strUserName, String strSurName) {
        String strFailure;
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        String newUserName = strUserName;
        if (strUserName.indexOf(".") != -1) {
            newUserName = namespace.escapeTheRDNDot(strUserName);
        }
        if (0 == strContext.indexOf("\\")) {
            strContext = strContext.substring(1);
        }
        D.log((String)("CreateUserTask: Creating: Name: " + newUserName + ", Surname: " + strSurName + ", Context: " + strContext));
        ObjectEntry parentEntry = null;
        try {
            parentEntry = namespace.getObjectEntry(treeOE, strContext);
        }
        catch (SPIException e) {
            String strFailure2 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.context);
            String strContainerNotFound = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.ContainerNotFound", (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure2);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)strContainerNotFound, (Object[])new String[]{strContext}));
            return false;
        }
        String strType = parentEntry.getObjectType().getName();
        if (0 != strType.compareTo("Organization") && 0 != strType.compareTo("Organizational Unit")) {
            String strFailure3 = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.context);
            String strNotAContainer = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotAContainer", (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure3);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)strNotAContainer, (Object[])new String[]{strContext}));
            return false;
        }
        String strException = null;
        try {
            DirUtils.createUser((String)objectClass, (ObjectEntry)parentEntry, (String)newUserName, (String)strSurName);
        }
        catch (NamespaceException nse) {
            D.log((Throwable)nse);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)nse), (MContext)this.context);
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), (MContext)this.context);
        }
        catch (SnapinVetoException sve) {
            D.log((Throwable)sve);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), (MContext)this.context);
        }
        if (null != strException) {
            strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Failure", (MContext)this.context);
            String strCommonError = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.FailureExplain", (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
            this.resultStrings.put("GeneralMsg.MsgBody", strCommonError + " " + strException);
            return false;
        }
        try {
            namespace.setPassword(namespace.getObjectEntry(parentEntry, newUserName), "");
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), (MContext)this.context);
        }
        if (null != strException) {
            strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.CredentialFailureE", (MContext)this.context);
            String strCommonError = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.CredentialFailureExplain", (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)strCommonError, (Object[])new String[]{newUserName}) + " " + strException);
            return false;
        }
        String strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.Success", (MContext)this.context);
        String strUserName2 = newUserName + "." + parentEntry.getFullName();
        this.resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateUser.SuccessForUser", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strUserName2);
        D.log((String)"CreateUserTask::CreateUser Create user succeeded");
        return true;
    }
}

