/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class DeleteAttributeTask
extends Task {
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private ObjectEntry m_treeOE = null;
    private NDSNamespace m_ns = null;
    private Locale m_locale = null;
    private NDSSchemaDefinition m_schemaDef = null;
    private Properties m_resultStrings = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        this.m_locale = this.m_context.getBrowserLocale().getLocale();
        this.getDeletableAttrs();
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getSelectedAttr")) {
            return this.getSelectedAttr(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private void getDeletableAttrs() {
        ArrayList<String> removeableAttrs = new ArrayList<String>();
        String strAttrName = null;
        try {
            this.m_schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
            AttributeDefinition[] attribs = this.m_schemaDef.getAttributeDefinitions();
            for (int i = 0; i < attribs.length; ++i) {
                strAttrName = attribs[i].getName();
                NDSAttributeDefinition attrDef = (NDSAttributeDefinition)this.m_schemaDef.getAttributeDefinition(strAttrName);
                if (attrDef.getAttributeFlag().isFlagSet(4) || strAttrName.equals("[Anything]") || strAttrName.equals("[Nothing]")) continue;
                removeableAttrs.add(strAttrName);
            }
        }
        catch (NamespaceException nex) {
            D.log((Throwable)nex);
            eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
        }
        catch (SPIException spie) {
            D.log((Throwable)spie);
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
        }
        Collections.sort(removeableAttrs, Collator.getInstance(this.m_locale));
        this.m_resultStrings.put("AvailableAttrList", removeableAttrs);
    }

    private boolean getSelectedAttr(String selectedButton) {
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strSelectedAttr = this.m_req.getParameter("SelectedAttribute");
            String strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteAttr.Success", (MContext)this.m_context);
            String strSuccessLong = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteAttr.SuccessLong", (MContext)this.m_context);
            String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteAttr.Failure", (MContext)this.m_context);
            try {
                this.m_schemaDef.removeAttributeDefinition(strSelectedAttr);
            }
            catch (PropertyVetoException pex) {
                D.log((Throwable)pex);
                eMFrameUtils.setErrorMessage((Throwable)pex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                if (nex == NamespaceException.ATTRIBUTE_IN_USE) {
                    this.m_resultStrings.put("GeneralMsg.MsgTitle", strFailure);
                    this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DeleteAttr.AttrUsedInClassDef", (MContext)this.m_context));
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                    return false;
                }
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            this.m_resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
            this.m_resultStrings.put("GeneralMsg.MsgBody", strSuccessLong);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenConf");
        }
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

