/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class GetFSVolumesTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties m_resultStrings;
    private ObjectEntry HostServerOE;
    private NDSNamespace namespace;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.m_resultStrings = resultStrings;
        this.req = context.getRequest();
        String HostServerStr = this.req.getParameter("HostServerObject");
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            this.namespace = (NDSNamespace)treeOE.getNamespace();
            this.HostServerOE = this.namespace.getObjectEntry(HostServerStr);
            String objType = this.HostServerOE.getObjectType().getName();
            if (!objType.equals("NCP Server")) {
                String errMsg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotANCPServer", (MContext)context);
                errMsg = eMFrameUtils.formatMessage((String)errMsg, (Object[])new String[]{HostServerStr});
                throw new Exception(errMsg);
            }
            String[] FSVolumes = this.namespace.getVolumesOnServer(this.HostServerOE);
            this.m_resultStrings.put("FSVolumes", eMFrameUtils.pack((String[])FSVolumes, (MContext)context));
        }
        catch (SPIException spiex) {
            if (spiex.getErrorCode() == -251) {
                String errMsg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NoVolumes", (MContext)context);
                errMsg = eMFrameUtils.formatMessage((String)errMsg, (Object[])new String[]{HostServerStr});
                resultStrings.put("FSVolumesError", errMsg);
            } else {
                resultStrings.put("FSVolumesError", spiex.getLocalizedMessage());
            }
            D.log((Throwable)spiex);
        }
        catch (Throwable t) {
            resultStrings.put("FSVolumesError", t.getLocalizedMessage());
            D.log((Throwable)t);
            return false;
        }
        return true;
    }
}

