/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.dev.rights.eDirObjectRightsData;
import com.novell.emframe.dev.rights.eDirPropertyRightsData;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class ModifyTrusteesTask
extends Task {
    public static final String HTMLPARAM_OBJECTNAME = "ObjectName";
    public static final String HTMLPARAM_TRUSTEENAME = "assignedTrustee";
    public static final String HTMLPARAM_ADDEDTRUSTEES = "addedTrustees";
    public static final String HTMLPARAM_REMOVEDTRUSTEES = "removedTrustees";
    public static final String HTMLPARAM_SHOWPROPERTIES = "showProperties";
    public static final String HTMLPARAM_ADDEDPROPERTY = "addedProperty";
    public static final String HTMLPARAM_REMOVEDPROPERTIES = "removedProperties";
    public static final String HTMLPARAM_PROPERTYRIGHTS = "propertyRights";
    public static final String[] delayedAttributes = new String[]{"Member"};
    TaskContext context;
    Properties resultStrings;
    AdminNamespace namespace;
    ObjectEntry treeOE = null;
    eDirRightsObject rObj = null;
    String strObjectName = "";
    String strTrusteeName = "";
    String userContext;
    boolean isContainer = false;
    boolean firstTimeThru = true;
    private boolean deletionOccurred = false;

    public boolean execute(TaskContext context, Properties resultStrings) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        if (this.firstTimeThru) {
            this.strObjectName = eMFrameUtils.getSingleTarget((HttpServletRequest)req);
            if (this.strObjectName.length() > 0) {
                nextState = "buildInitialTrusteesTable";
                ((I18NServletRequest)req).setParameter("merge", "base.ModifyTrustees");
                ((I18NServletRequest)req).setParameter("error", "dev.GenErr");
            }
            this.firstTimeThru = false;
        }
        try {
            this.userContext = req.getParameter("User.context");
            this.treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.context = context;
            this.resultStrings = resultStrings;
            this.namespace = (AdminNamespace)this.treeOE.getNamespace();
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
            return false;
        }
        if (this.strObjectName != null) {
            resultStrings.put("ObjectDisplayName", this.strObjectName);
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("buildInitialTrusteesTable")) {
            if (this.strObjectName.length() == 0) {
                this.strObjectName = req.getParameter(HTMLPARAM_OBJECTNAME);
            }
            try {
                if (this.strObjectName.equalsIgnoreCase("[root]")) {
                    this.strObjectName = this.treeOE.getName();
                }
                this.rObj = new eDirRightsObject(this.namespace.getDelayedAttibuteDetails(this.namespace.getObjectEntry(this.treeOE, this.strObjectName), delayedAttributes));
                ObjectEntry whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
                if (!this.rObj.aclWriteRights()) {
                    eMFrameUtils.setMessage((String)"error", (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"ModifyTrusteesTaskDisplayName", (MContext)context), (String)eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"User.InsufficientRights", (MContext)context), (MContext)context);
                    return false;
                }
                resultStrings.put("ObjectDisplayName", this.strObjectName);
                resultStrings.put("ObjectTypeName", this.rObj.getNSObject().getObjectEntry().getObjectType().getName());
                if (this.rObj.getNSObject().getObjectEntry().getObjectType().isContainer()) {
                    this.isContainer = true;
                }
                context.addToHistory(this.namespace.getObjectEntry(this.treeOE, this.strObjectName));
                return this.updateTrusteeTable();
            }
            catch (Exception e) {
                this.firstTimeThru = true;
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                return false;
            }
        }
        if (nextState.equalsIgnoreCase("buildInitialPropertiesTable")) {
            this.strTrusteeName = eMFrameUtils.urlDecode((String)req.getParameter(HTMLPARAM_TRUSTEENAME), (MContext)context);
            resultStrings.put("TrusteeDisplayName", this.strTrusteeName);
            return this.updatePropertyTable(this.strTrusteeName);
        }
        if (nextState.equalsIgnoreCase("buildPropertiesList")) {
            String s = req.getParameter(HTMLPARAM_SHOWPROPERTIES);
            if (s.equals("true")) {
                resultStrings.put("ShowProperties", "true");
                return this.buildPropertyList(true);
            }
            resultStrings.put("ShowProperties", "false");
            return this.buildPropertyList(false);
        }
        if (nextState.equalsIgnoreCase("updateAssignedRights")) {
            resultStrings.put("ObjectDisplayName", this.strObjectName);
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.strTrusteeName);
            }
            return this.updateTrusteeTable();
        }
        if (nextState.equalsIgnoreCase("addTrusteesToTable")) {
            resultStrings.put("ObjectDisplayName", this.strObjectName);
            String newTrustees = req.getParameter(HTMLPARAM_ADDEDTRUSTEES);
            return this.addTrusteesToTable(this.createUnencodedArray(newTrustees, "$"));
        }
        if (nextState.equalsIgnoreCase("addThisToTable")) {
            resultStrings.put("ObjectDisplayName", this.strObjectName);
            String newTrustees = "[This]";
            return this.addTrusteesToTable(this.createUnencodedArray(newTrustees, "$"));
        }
        if (nextState.equalsIgnoreCase("removeTrusteesFromTable")) {
            resultStrings.put("ObjectDisplayName", this.strObjectName);
            String removedTrustees = req.getParameter(HTMLPARAM_REMOVEDTRUSTEES);
            return this.removeTrusteesFromTable(this.createUnencodedArray(removedTrustees, "$"));
        }
        if (nextState.equals("addPropertyToTable")) {
            resultStrings.put("TrusteeDisplayName", this.strTrusteeName);
            String newProperty = req.getParameter(HTMLPARAM_ADDEDPROPERTY);
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.strTrusteeName);
            }
            return this.addPropertyToTable(this.strTrusteeName, eMFrameUtils.urlDecode((String)newProperty, (MContext)context));
        }
        if (nextState.equals("removePropertiesFromTable")) {
            resultStrings.put("TrusteeDisplayName", this.strTrusteeName);
            String removedProperties = req.getParameter(HTMLPARAM_REMOVEDPROPERTIES);
            String propertyRights = req.getParameter(HTMLPARAM_PROPERTYRIGHTS);
            StringTokenizer tokenIzer = new StringTokenizer(propertyRights, "$", false);
            String[] stringArray = new String[tokenIzer.countTokens()];
            int tokenCount = 0;
            while (tokenIzer.hasMoreTokens()) {
                stringArray[tokenCount] = tokenIzer.nextToken();
                ++tokenCount;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.updatePropertyRights(stringArray[i], this.strTrusteeName);
            }
            return this.removePropertiesFromTable(this.createUnencodedArray(removedProperties, "$"), this.strTrusteeName);
        }
        if (nextState.equals("repostPropertiesTable")) {
            resultStrings.put("TrusteeDisplayName", this.strTrusteeName);
            return this.updatePropertyTable(this.strTrusteeName);
        }
        if (nextState.equalsIgnoreCase("update")) {
            if (this.rObj != null) {
                try {
                    this.rObj.updateDataNoCatch();
                    resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.ModifyTrusteesSuccessTitle", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.ModifyTrusteesSuccessMsg", (MContext)context));
                    resultStrings.put("GeneralMsg.MsgBodyBoldText", this.strObjectName);
                }
                catch (Exception e) {
                    D.log((Throwable)e);
                    eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                    return false;
                }
            }
        } else {
            if (nextState.equals("apply")) {
                if (this.rObj != null) {
                    try {
                        this.rObj.updateDataNoCatch();
                    }
                    catch (Exception e) {
                        eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                        return false;
                    }
                }
                ((I18NServletRequest)req).setParameter("merge", "base.ModifyTrustees");
                this.deletionOccurred = false;
                return this.updateTrusteeTable();
            }
            if (nextState.equals("refresh")) {
                try {
                    this.rObj = new eDirRightsObject(this.namespace.getDelayedAttibuteDetails(this.namespace.getObjectEntry(this.treeOE, this.strObjectName), delayedAttributes));
                    if (this.rObj.getNSObject().getObjectEntry().getObjectType().isContainer()) {
                        this.isContainer = true;
                    }
                }
                catch (SPIException e) {
                    e.printStackTrace();
                }
                return this.updateTrusteeTable();
            }
        }
        return true;
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean updateTrusteeTable() {
        if (this.rObj == null) {
            return false;
        }
        boolean dirty = this.deletionOccurred;
        if (this.rObj.isDirty()) {
            dirty = true;
        }
        Enumeration eTrustees = this.rObj.getTrustees();
        TreeSet<String> set = new TreeSet<String>();
        while (eTrustees.hasMoreElements()) {
            String trusteeName = (String)eTrustees.nextElement();
            if (trusteeName.equals("[Inheritance Mask]")) continue;
            set.add(trusteeName);
        }
        Iterator si = set.iterator();
        int trusteeCount = 0;
        while (si.hasNext()) {
            Object so = si.next();
            this.resultStrings.put("Trustee.Member." + ++trusteeCount + ".FullName", so.toString());
            try {
                if (!so.toString().equalsIgnoreCase("[This]")) {
                    ObjectEntry objectEntry = this.rObj.getNameSpace().getObjectEntry(this.treeOE, so.toString());
                    this.resultStrings.put("Trustee.Member." + trusteeCount + ".ImageName", this.context.getDirUtils().getObjectTypeImageName(objectEntry.getTypeName()));
                    continue;
                }
                this.resultStrings.put("Trustee.Member." + trusteeCount + ".ImageName", this.context.getDirUtils().getObjectTypeImageName("Top"));
            }
            catch (SPIException e) {
                D.log((Throwable)e);
            }
        }
        this.resultStrings.put("Trustee.Member.Count", Integer.toString(trusteeCount));
        if (dirty) {
            this.resultStrings.put("RightsDataDirty", "" + dirty);
        }
        return true;
    }

    private boolean updatePropertyTable(String trustee) {
        eDirPropertyRightsData pRights = null;
        eDirObjectRightsData oRights = null;
        if (this.rObj == null) {
            return false;
        }
        try {
            ObjectAttribute oa = this.rObj.getACLAttribute();
            int propertyCount = 0;
            if (oa != null) {
                Vector v = this.sortACLEnumeration(oa.getValueComponents());
                for (int i = 0; i < v.size(); ++i) {
                    ValueList vl = (ValueList)v.elementAt(i);
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName())) continue;
                    ++propertyCount;
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        oRights = new eDirObjectRightsData((int)facade.getPrivileges());
                    } else {
                        pRights = facade.getProtectedAttrName().equals("[All Attributes Rights]") ? new eDirPropertyRightsData((int)facade.getPrivileges(), true) : new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Name", facade.getProtectedAttrName());
                    if (facade.getProtectedAttrName().equals("[Entry Rights]")) {
                        this.resultStrings.put("Property." + propertyCount + ".AddSelf", String.valueOf(oRights.hasAddRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Browse", String.valueOf(oRights.hasBrowseRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Delete", String.valueOf(oRights.hasDeleteRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Inheritable", String.valueOf(oRights.hasInheritableRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Rename", String.valueOf(oRights.hasRenameRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(oRights.hasSupervisorRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Dynamic", String.valueOf(oRights.hasDynamicRights()));
                        this.resultStrings.put("Property." + propertyCount + ".Nested", String.valueOf(oRights.hasNestedRights()));
                        this.resultStrings.put("Property." + propertyCount + ".DisableInherit", String.valueOf(this.disableInheritableRight("[Entry Rights]", trustee)));
                        continue;
                    }
                    this.resultStrings.put("Property." + propertyCount + ".Compare", String.valueOf(pRights.hasCompareRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Inheritable", String.valueOf(pRights.hasInheritableRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Read", String.valueOf(pRights.hasReadRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Write", String.valueOf(pRights.hasWriteRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Self", String.valueOf(pRights.hasSelfRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Supervisor", String.valueOf(pRights.hasSupervisorRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Dynamic", String.valueOf(pRights.hasDynamicRights()));
                    this.resultStrings.put("Property." + propertyCount + ".Nested", String.valueOf(pRights.hasNestedRights()));
                    this.resultStrings.put("Property." + propertyCount + ".DisableInherit", String.valueOf(this.disableInheritableRight(facade.getProtectedAttrName(), trustee)));
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
            if (this.disableCreateRight()) {
                this.resultStrings.put("No_Create", "true");
            } else {
                this.resultStrings.put("No_Create", "false");
            }
            if (this.disableDynamicRight(trustee)) {
                this.resultStrings.put("No_Dynamic", "true");
            } else {
                this.resultStrings.put("No_Dynamic", "false");
            }
            if (this.disableNestedRight(trustee)) {
                this.resultStrings.put("No_Nested", "true");
            } else {
                this.resultStrings.put("No_Nested", "false");
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean buildPropertyList(boolean allSchemaAttrs) {
        if (this.rObj == null) {
            return false;
        }
        try {
            SchemaDefinition sd = this.namespace.getSchemaDefinition(this.rObj.getNSObject().getObjectEntry());
            AttributeDefinition[] ads = sd.getAttributeDefinitions();
            String className = this.rObj.getNSObject().getObjectEntry().getObjectType().getName();
            ClassDefinition cd = sd.getClassDefinition(className);
            TreeSet<String> set = new TreeSet<String>();
            for (int i = 0; i < ads.length; ++i) {
                if (ads[i].isHidden() || ads[i].getName().equals("[Nothing]") || ads[i].getName().equals("[Anything]")) continue;
                set.add(ads[i].getName());
            }
            Iterator si = set.iterator();
            int propertyCount = 0;
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[All Attributes Rights]");
            this.resultStrings.put("Property." + ++propertyCount + ".Name", "[Entry Rights]");
            if (allSchemaAttrs) {
                while (si.hasNext()) {
                    Object so = si.next();
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            } else {
                while (si.hasNext()) {
                    Object so = si.next();
                    String attr = so.toString();
                    if (!cd.isClassUsingAttribute(attr)) continue;
                    this.resultStrings.put("Property." + ++propertyCount + ".Name", so.toString());
                }
            }
            this.resultStrings.put("Property.Count", Integer.toString(propertyCount));
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        return true;
    }

    private boolean addTrusteesToTable(String[] newTrusteesArray) {
        for (int i = 0; i < newTrusteesArray.length; ++i) {
            if (!this.canAddTrustee(newTrusteesArray[i])) continue;
            this.rObj.setAllObjectRights(newTrusteesArray[i], 1);
            int pRights = 1;
            this.rObj.setAllPropertyRights(newTrusteesArray[i], pRights |= 2);
        }
        this.updateTrusteeTable();
        return true;
    }

    private boolean addPropertyToTable(String trustee, String newProperty) {
        boolean ret = true;
        if (!newProperty.equals("")) {
            if (this.canAddProperty(newProperty, trustee)) {
                if (newProperty.equals("[Entry Rights]")) {
                    eDirObjectRightsData oData;
                    Vector v;
                    int oRights = 1;
                    oRights = !this.isContainer ? this.setPropertyInheritance(oRights, "[Entry Rights]", false) : ((v = this.rObj.getAssignedObjectRights(trustee)) != null ? ((oData = (eDirObjectRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(oRights, "[Entry Rights]", false) : this.setPropertyInheritance(oRights, "[Entry Rights]", true)) : this.setPropertyInheritance(oRights, "[Entry Rights]", true));
                    this.rObj.setAllObjectRights(trustee, oRights);
                } else if (newProperty.equals("[All Attributes Rights]")) {
                    eDirPropertyRightsData pData;
                    Vector v;
                    int pRights = 1;
                    pRights |= 2;
                    pRights = !this.isContainer ? this.setPropertyInheritance(pRights, "[All Attributes Rights]", false) : ((v = this.rObj.getAssignedAllPropertyRights(trustee)) != null ? ((pData = (eDirPropertyRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(pRights, "[All Attributes Rights]", false) : this.setPropertyInheritance(pRights, "[All Attributes Rights]", true)) : this.setPropertyInheritance(pRights, "[All Attributes Rights]", true));
                    this.rObj.setAllPropertyRights(trustee, pRights);
                } else {
                    eDirPropertyRightsData pData;
                    Vector v;
                    int pRights = 1;
                    pRights |= 2;
                    pRights = !this.isContainer ? this.setPropertyInheritance(pRights, newProperty, false) : ((v = this.rObj.getAssignedPropertyRights(trustee, newProperty)) != null ? ((pData = (eDirPropertyRightsData)v.elementAt(0)).hasInheritableRights() ? this.setPropertyInheritance(pRights, newProperty, false) : this.setPropertyInheritance(pRights, newProperty, true)) : this.setPropertyInheritance(pRights, newProperty, false));
                    this.rObj.setPropertyRights(newProperty, trustee, pRights, pRights);
                }
            } else {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyTitle", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"eDirRights.DuplicatePropertyMsg", (MContext)this.context));
                String taskID = this.context.getRequest().getParameter("taskId");
                String url = "webacc?taskId=";
                url = url + taskID;
                url = url + "&merge=base.ModifyTrusteesAssignedRights&User.context=";
                url = url + this.userContext;
                url = url + "&nextState=addPropertyToTable&addedProperty=";
                url = url + "";
                url = url + "&propertyRights=";
                url = url + "";
                this.resultStrings.put("GeneralMsg.Url", url);
                ret = false;
            }
        }
        this.updatePropertyTable(trustee);
        return ret;
    }

    private boolean removeTrusteesFromTable(String[] removeTrusteesArray) {
        for (int i = 0; i < removeTrusteesArray.length; ++i) {
            if (!this.canRemoveTrustee(removeTrusteesArray[i])) continue;
            this.rObj.deleteTrustee(removeTrusteesArray[i]);
            this.deletionOccurred = true;
        }
        this.updateTrusteeTable();
        return true;
    }

    private boolean removePropertiesFromTable(String[] removePropertiesArray, String trustee) {
        for (int i = 0; i < removePropertiesArray.length; ++i) {
            this.removeACL(removePropertiesArray[i], trustee);
        }
        this.updatePropertyTable(trustee);
        return true;
    }

    private boolean canAddTrustee(String newTrustee) {
        Enumeration eTrustees = this.rObj.getTrustees();
        while (eTrustees.hasMoreElements()) {
            String currentTrustee = (String)eTrustees.nextElement();
            if (!currentTrustee.equalsIgnoreCase(newTrustee)) continue;
            return false;
        }
        return true;
    }

    private boolean canRemoveTrustee(String removeTrustee) {
        Enumeration eTrustees = this.rObj.getTrustees();
        while (eTrustees.hasMoreElements()) {
            String currentTrustee = (String)eTrustees.nextElement();
            if (!currentTrustee.equalsIgnoreCase(removeTrustee)) continue;
            return true;
        }
        return false;
    }

    private boolean canAddProperty(String property, String trustee) {
        ObjectAttribute oa = this.rObj.getACLAttribute();
        if (oa != null) {
            Enumeration e = oa.getValueComponents();
            if (this.isContainer) {
                int propertyCount = 0;
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    ++propertyCount;
                }
                if (propertyCount > 1) {
                    return false;
                }
            } else {
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int setPropertyInheritance(int rights, String property, boolean inheritance) {
        if (property.equals("[Entry Rights]")) {
            eDirObjectRightsData dataE = new eDirObjectRightsData(rights);
            dataE.setInheritable(inheritance);
            rights = dataE.getRights();
        } else if (property.equals("[All Attributes Rights]")) {
            eDirPropertyRightsData dataA = new eDirPropertyRightsData(rights, true);
            dataA.setInheritable(inheritance);
            rights = dataA.getRights();
        } else {
            eDirPropertyRightsData dataP = new eDirPropertyRightsData(rights, false);
            dataP.setInheritable(inheritance);
            rights = dataP.getRights();
        }
        return rights;
    }

    private void removeACL(String s, String trustee) {
        block10: {
            ObjectAttribute oa;
            String property = "";
            String inherit = "";
            boolean inheritable = true;
            int rights = 0;
            String[] array = new String[]{"", ""};
            if (s.indexOf(":") == s.lastIndexOf(":")) {
                array = this.createUnencodedArray(s, ":");
            } else {
                array[0] = s.substring(0, s.lastIndexOf(":"));
                array[1] = s.substring(s.lastIndexOf(":") + 1, s.length());
            }
            if (array.length != 2) break block10;
            property = array[0];
            inherit = array[1];
            if (inherit.equals("false")) {
                inheritable = false;
            }
            if ((oa = this.rObj.getACLAttribute()) != null) {
                Enumeration e = oa.getValueComponents();
                if (this.isContainer) {
                    while (e.hasMoreElements()) {
                        ValueList vl = (ValueList)e.nextElement();
                        ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                        if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                        if (property.equals("[Entry Rights]")) {
                            eDirObjectRightsData dataE = new eDirObjectRightsData((int)facade.getPrivileges());
                            if (dataE.hasInheritableRights() != inheritable) continue;
                            rights = dataE.getRights();
                            this.rObj.deleteACL(trustee, property, rights);
                            continue;
                        }
                        if (property.equals("[All Attributes Rights]")) {
                            eDirPropertyRightsData dataA = new eDirPropertyRightsData((int)facade.getPrivileges(), true);
                            if (dataA.hasInheritableRights() != inheritable) continue;
                            rights = dataA.getRights();
                            this.rObj.deleteACL(trustee, property, rights);
                            continue;
                        }
                        eDirPropertyRightsData dataP = new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                        if (dataP.hasInheritableRights() != inheritable) continue;
                        rights = dataP.getRights();
                        this.rObj.deleteACL(trustee, property, rights);
                    }
                } else {
                    while (e.hasMoreElements()) {
                        ValueList vl = (ValueList)e.nextElement();
                        ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                        if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                        rights = (int)facade.getPrivileges();
                        this.rObj.deleteACL(trustee, property, rights);
                    }
                }
            }
        }
    }

    private void updatePropertyRights(String delimitedString, String trustee) {
        try {
            String property = delimitedString.substring(0, delimitedString.indexOf("+"));
            String rights = delimitedString.substring(delimitedString.indexOf("+") + 1, delimitedString.length());
            String[] propertyRightsArray = this.createUnencodedArray(rights, ":");
            String inherit = "";
            boolean inheritable = true;
            Vector<Object> oldValue = new Vector<Object>();
            Vector<Object> newValue = new Vector<Object>();
            inherit = propertyRightsArray[5];
            if (inherit.equals("false")) {
                inheritable = false;
            }
            oldValue.addElement(property);
            oldValue.addElement(trustee);
            newValue.addElement(property);
            newValue.addElement(trustee);
            ObjectAttribute oa = this.rObj.getACLAttribute();
            if (oa != null) {
                Syntax syn = oa.getAttributeDefinition().getSyntax();
                Enumeration e = oa.getValueComponents();
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    if (property.equals("[Entry Rights]")) {
                        eDirObjectRightsData dataE = new eDirObjectRightsData((int)facade.getPrivileges());
                        if (this.hasDuplicateProperty(property, trustee)) {
                            if (dataE.hasInheritableRights() != inheritable) continue;
                            dataE.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                            dataE.setBrowse(this.stringToBoolean(propertyRightsArray[1]));
                            dataE.setAdd(this.stringToBoolean(propertyRightsArray[2]));
                            dataE.setRename(this.stringToBoolean(propertyRightsArray[3]));
                            dataE.setDelete(this.stringToBoolean(propertyRightsArray[4]));
                            dataE.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                            dataE.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                            dataE.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                            oldValue.addElement(new Long(facade.getPrivileges()));
                            newValue.addElement(new Long(dataE.getRights()));
                            oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                            this.rObj.externalSetDirty();
                            oldValue.removeAllElements();
                            oldValue.addElement(property);
                            oldValue.addElement(trustee);
                            newValue.removeAllElements();
                            newValue.addElement(property);
                            newValue.addElement(trustee);
                            continue;
                        }
                        dataE.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataE.setBrowse(this.stringToBoolean(propertyRightsArray[1]));
                        dataE.setAdd(this.stringToBoolean(propertyRightsArray[2]));
                        dataE.setRename(this.stringToBoolean(propertyRightsArray[3]));
                        dataE.setDelete(this.stringToBoolean(propertyRightsArray[4]));
                        dataE.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                        dataE.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                        dataE.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                        oldValue.addElement(new Long(facade.getPrivileges()));
                        newValue.addElement(new Long(dataE.getRights()));
                        oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                        continue;
                    }
                    if (property.equals("[All Attributes Rights]")) {
                        eDirPropertyRightsData dataA = new eDirPropertyRightsData((int)facade.getPrivileges(), true);
                        if (this.hasDuplicateProperty(property, trustee)) {
                            if (dataA.hasInheritableRights() != inheritable) continue;
                            dataA.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                            dataA.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                            dataA.setRead(this.stringToBoolean(propertyRightsArray[2]));
                            dataA.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                            dataA.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                            dataA.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                            dataA.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                            dataA.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                            oldValue.addElement(new Long(facade.getPrivileges()));
                            newValue.addElement(new Long(dataA.getRights()));
                            oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                            this.rObj.externalSetDirty();
                            oldValue.removeAllElements();
                            oldValue.addElement(property);
                            oldValue.addElement(trustee);
                            newValue.removeAllElements();
                            newValue.addElement(property);
                            newValue.addElement(trustee);
                            continue;
                        }
                        dataA.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataA.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                        dataA.setRead(this.stringToBoolean(propertyRightsArray[2]));
                        dataA.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                        dataA.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                        dataA.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                        dataA.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                        dataA.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                        oldValue.addElement(new Long(facade.getPrivileges()));
                        newValue.addElement(new Long(dataA.getRights()));
                        oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                        continue;
                    }
                    eDirPropertyRightsData dataP = new eDirPropertyRightsData((int)facade.getPrivileges(), false);
                    if (this.hasDuplicateProperty(property, trustee)) {
                        if (dataP.hasInheritableRights() != inheritable) continue;
                        dataP.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                        dataP.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                        dataP.setRead(this.stringToBoolean(propertyRightsArray[2]));
                        dataP.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                        dataP.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                        dataP.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                        dataP.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                        dataP.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                        oldValue.addElement(new Long(facade.getPrivileges()));
                        newValue.addElement(new Long(dataP.getRights()));
                        oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                        this.rObj.externalSetDirty();
                        oldValue.removeAllElements();
                        oldValue.addElement(property);
                        oldValue.addElement(trustee);
                        newValue.removeAllElements();
                        newValue.addElement(property);
                        newValue.addElement(trustee);
                        continue;
                    }
                    dataP.setSupervisor(this.stringToBoolean(propertyRightsArray[0]));
                    dataP.setCompare(this.stringToBoolean(propertyRightsArray[1]));
                    dataP.setRead(this.stringToBoolean(propertyRightsArray[2]));
                    dataP.setWrite(this.stringToBoolean(propertyRightsArray[3]));
                    dataP.setSelf(this.stringToBoolean(propertyRightsArray[4]));
                    dataP.setDynamic(this.stringToBoolean(propertyRightsArray[6]));
                    dataP.setInheritable(this.stringToBoolean(propertyRightsArray[5]));
                    dataP.setNestedRights(this.stringToBoolean(propertyRightsArray[7]));
                    oldValue.addElement(new Long(facade.getPrivileges()));
                    newValue.addElement(new Long(dataP.getRights()));
                    oa.replaceComponent(syn.createValueComponent(oldValue), syn.createValueComponent(newValue));
                    this.rObj.externalSetDirty();
                }
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
    }

    private boolean stringToBoolean(String s) {
        return s.equals("true");
    }

    private boolean disableCreateRight() {
        return !this.isContainer;
    }

    private boolean disableNestedRight(String trustee) {
        try {
            Enumeration myenum;
            NSObject nsObj = this.namespace.getDetails(this.namespace.getObjectEntry(this.treeOE, trustee));
            ObjectAttribute oa = nsObj.getAttribute("Object Class");
            boolean result = true;
            if (oa != null && (myenum = oa.getValueComponents()) != null) {
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("nestedGroupAux")) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
    }

    private boolean disableDynamicRight(String trustee) {
        try {
            Enumeration myenum;
            NSObject nsObj = this.namespace.getDetails(this.namespace.getObjectEntry(this.treeOE, trustee));
            ObjectAttribute oa = nsObj.getAttribute("Object Class");
            boolean result = true;
            if (oa != null && (myenum = oa.getValueComponents()) != null) {
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("dynamicGroup") && !value.equals("dynamicGroupAux")) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
    }

    private boolean disableInheritableRight(String property, String trustee) {
        return !this.isContainer || this.hasDuplicateProperty(property, trustee);
    }

    private boolean hasDuplicateProperty(String property, String trustee) {
        ObjectAttribute oa = this.rObj.getACLAttribute();
        if (oa != null) {
            Enumeration e = oa.getValueComponents();
            if (this.isContainer) {
                int propertyCount = 0;
                while (e.hasMoreElements()) {
                    ValueList vl = (ValueList)e.nextElement();
                    ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                    if (!trustee.equalsIgnoreCase(facade.getSubjectName()) || !facade.getProtectedAttrName().equals(property)) continue;
                    ++propertyCount;
                }
                if (propertyCount > 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private Vector sortACLEnumeration(Enumeration e) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        for (int a = 1; a < v.size(); ++a) {
            for (int b = v.size() - 1; b >= a; --b) {
                ValueList vl_1 = (ValueList)v.elementAt(b - 1);
                ValueList vl_2 = (ValueList)v.elementAt(b);
                ObjectACLFacade facade_1 = (ObjectACLFacade)vl_1.createFacade();
                ObjectACLFacade facade_2 = (ObjectACLFacade)vl_2.createFacade();
                if (facade_1.getProtectedAttrName().compareTo(facade_2.getProtectedAttrName()) <= 0) continue;
                v.setElementAt(vl_2, b - 1);
                v.setElementAt(vl_1, b);
            }
        }
        return v;
    }

    private String[] createUnencodedArray(String concatString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(concatString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            String s = tokenIzer.nextToken();
            stringArray[tokenCount] = eMFrameUtils.urlDecode((String)s, (MContext)this.context);
            ++tokenCount;
        }
        return stringArray;
    }
}

