/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.RuntimePlugin;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BackLinkUtils;
import com.novell.emframe.fw.FwUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class MultiDNPage
extends DirPropertyBookPage
implements RuntimePlugin {
    ArrayList m_initialValues = null;
    ArrayList m_currentValues = null;
    String m_attributeName = null;
    String m_targetObjectTypeName = null;
    String m_backLinkAttributeName = null;
    String m_backLinkObjectTypeName = null;
    String m_secondayAttributeName = null;
    String m_secondaryBackLinkAttributeName = null;

    public void init(TaskContext context, Document doc) {
        Properties params = eMFrameUtils.getUrlParams((Document)doc);
        this.m_attributeName = params.getProperty("attributeName");
        this.m_targetObjectTypeName = params.getProperty("targetObjectTypeName");
        this.m_backLinkAttributeName = params.getProperty("backLinkAttributeName");
        this.m_backLinkObjectTypeName = params.getProperty("backLinkObjectTypeName");
        this.m_secondayAttributeName = params.getProperty("secondayAttributeName");
        this.m_secondaryBackLinkAttributeName = params.getProperty("secondaryBackLinkAttributeName");
        super.init(context, doc);
    }

    public boolean shouldShow(NSObject ns, TaskContext context) {
        if (this.m_targetObjectTypeName.equalsIgnoreCase("group")) {
            ObjectEntry oe = ns.getObjectEntry();
            DirUtils dirUtils = context.getDirUtils();
            return !dirUtils.isOfAuxClass(oe, "dynamicGroupAux") && !DirUtils.isOfType((ObjectType)oe.getObjectType(), (String)"dynamicGroup", (boolean)true) && !DirUtils.isOfType((ObjectType)oe.getObjectType(), (String)"Group", (boolean)true);
        }
        return true;
    }

    public void show(PropertyPageContext context) throws PageException {
        Properties resultStrings = context.getResultStrings();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ObjectAttribute attrib = nsObj.getAttribute(this.m_attributeName);
        ArrayList<String> list = new ArrayList<String>();
        if (attrib != null) {
            Enumeration myenum = attrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                Value value = (Value)myenum.nextElement();
                list.add(value.toString());
            }
        }
        if (this.m_initialValues == null) {
            this.m_initialValues = (ArrayList)list.clone();
            this.m_currentValues = (ArrayList)list.clone();
        }
        String[] groups = list.toArray(new String[list.size()]);
        String pack = eMFrameUtils.pack((String[])groups, (MContext)context);
        resultStrings.put("Groups", pack);
        String displayName = context.getDirUtils().getAttributeDisplayName(this.m_attributeName, (MContext)context);
        resultStrings.put("attributeDisplayName", displayName);
        resultStrings.put("osFilter", this.m_backLinkObjectTypeName);
        DirUtils dirUtils = context.getDirUtils();
        resultStrings.put("primaryAttributeName", dirUtils.getSafeName(this.m_attributeName));
        if (this.m_secondayAttributeName != null) {
            resultStrings.put("secondaryAttributeName", dirUtils.getSafeName(this.m_secondayAttributeName));
        }
        super.show(context);
    }

    public void cache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        String pack = req.getParameter("Groups");
        String[] groupNames = eMFrameUtils.unpack((String)pack, (MContext)context);
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ObjectAttribute attrib = nsObj.getAttribute(this.m_attributeName);
        ObjectAttribute secondaryAttrib = null;
        if (this.m_secondayAttributeName != null) {
            secondaryAttrib = nsObj.getAttribute(this.m_secondayAttributeName);
        }
        boolean needToAdd = false;
        boolean needToAddSecondary = false;
        try {
            NDSAttributeDefinition ad;
            if (attrib == null) {
                ad = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, this.m_attributeName);
                attrib = new NDSObjectAttribute(ad);
                boolean bl = needToAdd = groupNames.length > 0;
            }
            if (this.m_secondayAttributeName != null && secondaryAttrib == null) {
                ad = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, this.m_secondayAttributeName);
                secondaryAttrib = new NDSObjectAttribute(ad);
                needToAddSecondary = groupNames.length > 0;
            }
            for (int i = 0; i < groupNames.length; ++i) {
                boolean userAdded;
                boolean bl = userAdded = !this.m_initialValues.contains(groupNames[i]);
                if (!userAdded) continue;
                ObjectEntry oe = ns.getObjectEntry(groupNames[i]);
                if (context.getDirUtils().isOfAuxClass(this.m_nsobj.getObjectEntry(), "dynamicGroupAux") || DirUtils.isOfType((ObjectType)this.m_nsobj.getObjectEntry().getObjectType(), (String)"dynamicGroup", (boolean)true) || DirUtils.isOfType((ObjectType)oe.getObjectType(), (String)this.m_backLinkObjectTypeName, (boolean)true)) continue;
                String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
                String pattern = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"MultiDNPage.incorrectObjectType", (MContext)context);
                String name = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)oe.getFullName());
                String body = eMFrameUtils.formatMessage((String)pattern, (Object[])new String[]{name, this.m_backLinkObjectTypeName});
                throw new PageException(header, body);
            }
            attrib.removeAllComponents();
            ArrayList oldValues = (ArrayList)this.m_currentValues.clone();
            this.m_currentValues.clear();
            for (int i = 0; i < groupNames.length; ++i) {
                ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)groupNames[i]);
                attrib.addComponent(vc);
                this.m_currentValues.add(groupNames[i]);
            }
            if (this.m_secondayAttributeName != null) {
                ValueComponent vc;
                String value;
                ArrayList addList = FwUtils.difference((Collection)this.m_currentValues, (Collection)oldValues);
                ArrayList removeList = FwUtils.difference((Collection)oldValues, (Collection)this.m_currentValues);
                if (addList.size() == 0) {
                    needToAddSecondary = false;
                }
                Iterator iter = addList.iterator();
                while (iter.hasNext()) {
                    value = (String)iter.next();
                    vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)value);
                    secondaryAttrib.addComponent(vc);
                }
                iter = removeList.iterator();
                while (iter.hasNext()) {
                    value = (String)iter.next();
                    vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)value);
                    secondaryAttrib.removeComponent(vc);
                }
            }
            if (needToAdd) {
                nsObj.addAttribute(attrib);
            }
            if (this.m_secondayAttributeName != null && needToAddSecondary) {
                nsObj.addAttribute(secondaryAttrib);
            }
        }
        catch (Exception e) {
            throw new PageException(e);
        }
        super.cache(context);
    }

    public void apply(TaskContext context, Properties resultStrings) throws PageException {
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ArrayList addList = FwUtils.difference((Collection)this.m_currentValues, (Collection)this.m_initialValues);
        ArrayList removeList = FwUtils.difference((Collection)this.m_initialValues, (Collection)this.m_currentValues);
        String fullname = nsObj.getObjectEntry().getFullName();
        String name = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)fullname);
        if (this.m_backLinkAttributeName != null && this.m_backLinkAttributeName.length() > 0) {
            BackLinkUtils.updateBacklinks((ArrayList)removeList, (String)this.m_backLinkAttributeName, (String)name, (int)2, (ObjectEntry)treeOE);
            BackLinkUtils.updateBacklinks((ArrayList)addList, (String)this.m_backLinkAttributeName, (String)name, (int)1, (ObjectEntry)treeOE);
        }
        if (this.m_secondaryBackLinkAttributeName != null && this.m_secondaryBackLinkAttributeName.length() > 0) {
            BackLinkUtils.updateBacklinks((ArrayList)removeList, (String)this.m_secondaryBackLinkAttributeName, (String)name, (int)2, (ObjectEntry)treeOE);
            BackLinkUtils.updateBacklinks((ArrayList)addList, (String)this.m_secondaryBackLinkAttributeName, (String)name, (int)1, (ObjectEntry)treeOE);
        }
        this.m_initialValues = null;
    }
}

