/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.DGUtilities;
import com.novell.emframe.base.NGGroupMemberPage;
import com.novell.emframe.base.NGGroupMembershipPage;
import com.novell.emframe.base.NGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BackLinkUtils;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class NGSettingsPage
extends DirPropertyBookPage {
    public static final String JSP_NESTED_SETTINGS = "useNestedSettings";
    public static final String JSP_NESTED_CONFIG = "useNestedConfig";
    public static final String JSP_NESTED_SETTINGS_PARAM = "nestedSettingParam";
    public static final String JSP_NESTED_CONFIG_PARAM = "nestedConfigParam";
    public static final String JSP_HAS_NESTED_ROLE_PARAM = "hasNestedRoleAssignmentsParam";
    public static final String NESTED_CACHE_SELECTED_VALUE_KEY = "NESTED_SELECTED_VALUE";
    public static final String HASHTABLE_NESTED_KEY = "nested";
    public static final String HASHTABLE_CONFIG_KEY = "config";
    public static final String CACHE_NESTED_KEY = "NESTED";
    public static final String CACHE_CONFIG_KEY = "CONFIG";
    private static final String GROUP_MEMBERS_LIST = "GROUP_MEMBERS_LIST";
    private static final String GROUP_MEMBERSHIP_LIST = "GROUP_MEMBERSHIP_LIST";
    ResourceBundle m_res = null;
    DirUtils m_dirUtils = null;

    public void show(PropertyPageContext context) throws PageException {
        D.log((String)"NGSettingsPage.show() called");
        this.m_dirUtils = context.getDirUtils();
        if (this.m_res == null) {
            this.m_res = ResourceBundle.getBundle("BaseResources", context.getLocale());
        }
        this.read(context, this.getDirPropertyBook().getNSObject());
    }

    public void cache(PropertyPageContext context) throws PageException {
        D.log((String)"NGSettingsPage.cache() called");
        this.writeToCache(context, this.getDirPropertyBook());
        this.m_IsDirty = true;
    }

    public void commit(PropertyPageContext context) throws PageException {
        D.log((String)"NGSettingsPage.commit() called");
        this.write(context, true, this.getDirPropertyBook().getNSObject());
    }

    private boolean checkNestedSetting(PropertyPageContext context, boolean bCurrentNestedSetting) {
        D.log((String)"NGSettingsPage.checkNestedSetting() called");
        HttpServletRequest req = context.getRequest();
        String nestedValue = req.getParameter(JSP_NESTED_SETTINGS);
        if (nestedValue == null) {
            return bCurrentNestedSetting;
        }
        Boolean bNestedState = nestedValue.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
        NSObject nsObject = this.getDirPropertyBook().getNSObject();
        DirPropertyBook propertyBook = this.getDirPropertyBook();
        if (bCurrentNestedSetting != bNestedState) {
            NGUtilities.setGroupNested(context, propertyBook, bNestedState);
            if (!bNestedState.booleanValue()) {
                propertyBook.getCache().put("firstMembersLoad", "true");
            }
            if (!(bCurrentNestedSetting = bNestedState.booleanValue())) {
                NGGroupMemberPage.resetMemberList(this.getDirPropertyBook(), context);
                NGGroupMemberPage.clearRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
                NGGroupMembershipPage.resetMemberList(this.getDirPropertyBook(), context);
                NGGroupMembershipPage.clearRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
            } else {
                NGGroupMemberPage.setRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
                NGGroupMembershipPage.setRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
            }
        }
        return bCurrentNestedSetting;
    }

    private String checkNestedConfig(PropertyPageContext context, String bCurrentNestedConfig) {
        D.log((String)"NGSettingsPage.checkNestedConfig() called");
        HttpServletRequest req = context.getRequest();
        String nestedConfigValue = req.getParameter(JSP_NESTED_CONFIG);
        if (nestedConfigValue == null) {
            return bCurrentNestedConfig;
        }
        if (bCurrentNestedConfig != nestedConfigValue) {
            NGUtilities.modifyConfig(context, this.getDirPropertyBook(), nestedConfigValue);
        }
        return nestedConfigValue;
    }

    private void read(PropertyPageContext context, NSObject nsObj) {
        D.log((String)"NGSettingsPage.read() called");
        NGUtilities.outputCommonSettings(this.getDirPropertyBook(), context);
        DGUtilities.outputCommonSettings((DirPropertyBook)this.getDirPropertyBook(), (PropertyPageContext)context);
    }

    private void write(PropertyPageContext context, boolean applyPressed, NSObject nsObj) throws PageException {
        D.log((String)"NGSettingsPage.write() called");
        DirPropertyBook propertyBook = this.getDirPropertyBook();
        if (NGUtilities.isGroupNested(propertyBook, context)) {
            String nestedConfig = (String)propertyBook.getCache().get("IS_NESTED_CONFIG");
            NGUtilities.modifyConfig(context, propertyBook, nestedConfig);
        } else {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            Vector groupMember = new Vector();
            Vector groupMembership = new Vector();
            String[] targetAttributes = new String[1];
            ObjectEntry oe = nsObj.getObjectEntry();
            String ObjectName = ns.getUnrootedName(oe);
            String[] values = new String[]{ObjectName};
            groupMember = (Vector)propertyBook.getCache().get(GROUP_MEMBERS_LIST);
            if (groupMember != null && groupMember.size() > 0) {
                ArrayList groups = new ArrayList(groupMember);
                targetAttributes[0] = SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"Group Membership");
                BackLinkUtils.updateBacklinks(groups, (String[])targetAttributes, (String[])values, (int)2, (ObjectEntry)oe.getRoot());
            }
            if ((groupMembership = (Vector)propertyBook.getCache().get(GROUP_MEMBERSHIP_LIST)) != null && groupMembership.size() > 0) {
                ArrayList groupmship = new ArrayList(groupMembership);
                targetAttributes[0] = SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"groupMember");
                BackLinkUtils.updateBacklinks(groupmship, (String[])targetAttributes, (String[])values, (int)2, (ObjectEntry)oe.getRoot());
            }
        }
    }

    private void writeToCache(PropertyPageContext context, DirPropertyBook propertyBook) throws PageException {
        D.log((String)"NGSettingsPage.writeToCache() called");
        HttpServletRequest req = context.getRequest();
        String nestedConfig = req.getParameter(JSP_NESTED_CONFIG);
        String nestedSetting = req.getParameter(JSP_NESTED_SETTINGS);
        if (nestedSetting.equalsIgnoreCase("true")) {
            NGUtilities.setGroupNested(context, propertyBook, new Boolean(true));
            NGUtilities.modifyConfig(context, propertyBook, nestedConfig);
        } else {
            Vector<String> groupMembers = new Vector<String>();
            Vector<String> GroupMembership = new Vector<String>();
            NGUtilities.setGroupNested(context, propertyBook, new Boolean(false));
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NSObject nsObj = propertyBook.getNSObject();
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            try {
                Enumeration enumMember;
                ObjectAttribute[] oaMember = ns.getAttributes(nsObj.getObjectEntry(), new String[]{"groupMember"}, 1, null, null);
                if (oaMember != null && oaMember[0] != null && (enumMember = oaMember[0].getValueComponents()) != null) {
                    while (enumMember.hasMoreElements()) {
                        groupMembers.add(enumMember.nextElement().toString());
                    }
                    propertyBook.getCache().put(GROUP_MEMBERS_LIST, groupMembers);
                }
                if ((oaMember = ns.getAttributes(nsObj.getObjectEntry(), new String[]{"Group Membership"}, 1, null, null)) != null && oaMember[0] != null && (enumMember = oaMember[0].getValueComponents()) != null) {
                    while (enumMember.hasMoreElements()) {
                        GroupMembership.add(enumMember.nextElement().toString());
                    }
                    propertyBook.getCache().put(GROUP_MEMBERSHIP_LIST, GroupMembership);
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
    }

    private void addValue(PropertyPageContext context, NSObject nsObj, String newValue, String attribute) {
        D.log((String)"NGSettingsPage.addValue() called");
    }

    private static boolean readFromCache(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        D.log((String)"NGSettingsPage.readFromCache() called");
        Properties results = context.getResultStrings();
        boolean bIsNested = NGUtilities.outputCommonSettings(dirPropertyBook, context);
        String svalue = (String)dirPropertyBook.getCache().get(NESTED_CACHE_SELECTED_VALUE_KEY);
        results.put(JSP_NESTED_SETTINGS_PARAM, "");
        results.put(JSP_NESTED_CONFIG_PARAM, "");
        if (bIsNested && svalue != null) {
            try {
                String nestedSettings = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_NESTED_KEY)), (MContext)context);
                String nestedConfig = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_CONFIG_KEY)), (MContext)context);
                results.put(JSP_NESTED_SETTINGS_PARAM, nestedSettings);
                results.put(JSP_NESTED_CONFIG_PARAM, nestedConfig);
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        } else if (dirPropertyBook.getCache().get(CACHE_NESTED_KEY) != null) {
            try {
                String nestedSettings = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_NESTED_KEY)), (MContext)context);
                String nestedConfig = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_CONFIG_KEY)), (MContext)context);
                results.put(JSP_NESTED_SETTINGS_PARAM, nestedSettings);
                results.put(JSP_NESTED_CONFIG_PARAM, nestedConfig);
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return bIsNested;
    }

    private static boolean readFromDS(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        D.log((String)"NGSettingsPage.readFromDS() called");
        boolean bIsNested = NGUtilities.outputCommonSettings(dirPropertyBook, context);
        Properties results = context.getResultStrings();
        Boolean bHasRoleAssignments = new Boolean(NGSettingsPage.hasRoleAssignments(dirPropertyBook));
        results.put(JSP_HAS_NESTED_ROLE_PARAM, bHasRoleAssignments.toString());
        return bIsNested;
    }

    private static boolean hasRoleAssignments(DirPropertyBook dirPropertyBook) {
        D.log((String)"NGSettingsPage.hasRoleAssignments() called");
        try {
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(dirPropertyBook.getNSObject().getObjectEntry());
            RBSAssociation[] rbsAssociations = rbsAssociatedObject.getDirectRoleAssociations2();
            if (null != rbsAssociations && rbsAssociations.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            D.log((String)"Could not read the RBSAssociationObject!");
            D.log((Throwable)e);
            return false;
        }
        return false;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        D.log((String)"NGSettingsPage.shouldRun() called");
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

