/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class Reporting
extends Task {
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        Connection conn = (Connection)context.getAuthAttribute((Object)"Reporting.JdbcConnection");
        if (conn == null) {
            try {
                Class.forName("com.novell.sql.LDAPDriver");
                Driver driver = DriverManager.getDriver("jdbc:ldap");
                conn = driver.connect("jdbc:ldap://137.65.150.89;user=cn=admin,o=Novell;password=novell;useCleartext=true;baseDN=o=Novell", null);
                if (conn != null) {
                    context.setAuthAttribute((Object)"Reporting.JdbcConnection", (Object)conn);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't load com.novell.sql.LDAPDriver", (MContext)context);
                return false;
            }
            catch (SQLException e) {
                eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't load driver or establish connection", (MContext)context);
                return false;
            }
        }
        this.outputReport(conn);
        System.out.println("Reporting: Success");
        eMFrameUtils.setMessage((String)"success", (String)"Success", (String)"", (MContext)context);
        return true;
    }

    public boolean outputReport(Connection conn) {
        try {
            String query = "SELECT CN, lastLoginTime FROM inetOrgPerson";
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            this.resultStrings.put("results.columns.count", "" + numCols);
            for (int col = 0; col < numCols; ++col) {
                this.resultStrings.put("results.columns." + col + ".name", rsmd.getColumnLabel(col + 1));
            }
            int row = 0;
            while (rs.next()) {
                for (int col = 0; col < numCols; ++col) {
                    String val = rs.getString(col + 1);
                    if (val != null) {
                        this.resultStrings.put("results." + row + "." + col, val);
                        continue;
                    }
                    this.resultStrings.put("results." + row + "." + col, "");
                }
                ++row;
            }
            this.resultStrings.put("results.rowcount", "" + row);
        }
        catch (SQLException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't establish connection", (MContext)this.context);
            return false;
        }
        return true;
    }

    public boolean outputMetadata(Connection conn) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet tables = metaData.getTables(null, null, "?", null);
            int tableIndex = 0;
            while (tables.next()) {
                String tableName = tables.getString("NAME");
                this.resultStrings.put("tables." + tableIndex + ".name", tableName);
                ResultSet columns = metaData.getColumns(null, null, tableName, "?");
                int columnIndex = 0;
                while (columns.next()) {
                    this.resultStrings.put("tables." + tableIndex + ".columns." + columnIndex + ".name", columns.getString(4));
                    this.resultStrings.put("tables." + tableIndex + ".columns." + columnIndex + ".type", columns.getString(6));
                    ++columnIndex;
                }
                this.resultStrings.put("tables." + tableIndex + ".columns.count", "" + columnIndex);
                ++tableIndex;
            }
            this.resultStrings.put("tables.count", "" + tableIndex);
        }
        catch (SQLException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't establish connection", (MContext)this.context);
            return false;
        }
        return true;
    }
}

