/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.CreateReport;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class RunReport
extends Task {
    HttpServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    Connection m_conn;

    public boolean execute(TaskContext context, Properties resultStrings) {
        String nextState;
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        if (this.m_conn == null) {
            try {
                this.m_conn = CreateReport.getJDBCConnection(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't load driver or establish connection", (MContext)context);
                return false;
            }
        }
        if ((nextState = this.m_req.getParameter("nextState")).equalsIgnoreCase("initialState")) {
            return true;
        }
        if (nextState.equalsIgnoreCase("ViewReport")) {
            return this.runReport();
        }
        eMFrameUtils.setMessage((String)"success", (String)"Success", (String)"", (MContext)context);
        return true;
    }

    public boolean runReport() {
        Element reportRoot;
        String reportName = this.m_req.getParameter("reportName");
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry oeReport = null;
        try {
            oeReport = namespace.getObjectEntry(treeOE, reportName);
        }
        catch (SPIException e) {
            D.log((Throwable)e);
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Invalid object.", (MContext)this.m_context);
            return false;
        }
        String[] attrNames = new String[]{"ReportQuery"};
        String[] attrVals = null;
        try {
            attrVals = DirUtils.attributeReader((ObjectEntry)oeReport, (String[])attrNames);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Object was created, but failed to write query to object.", (MContext)this.m_context);
            return false;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document reportDoc = builder.build((Reader)new StringReader(attrVals[0]));
            reportRoot = reportDoc.getRootElement();
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Invalid query xml in report object.", (MContext)this.m_context);
            return false;
        }
        try {
            this.outputReport(reportRoot);
        }
        catch (PluginException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            return false;
        }
        return true;
    }

    private void outputReport(Element report) throws PluginException {
        Element query = report.getChild("query");
        this.outputData(query);
        Element format = report.getChild("format");
        if (format != null) {
            this.outputFormat(format);
        }
    }

    private void outputData(Element el) throws PluginException {
        String prefix = "";
        Element root = el.getDocument().getRootElement();
        for (Element parent = el.getParent(); parent != root; parent = parent.getParent()) {
            prefix = prefix + "Report.";
        }
        String sql = el.getChildTextTrim("sql");
        D.log((String)("Reporting: executing query: " + sql));
        try {
            Statement statement = this.m_conn.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            this.m_resultStrings.put(prefix + "Report.results.columns.count", "" + numCols);
            for (int col = 0; col < numCols; ++col) {
                this.m_resultStrings.put(prefix + "Report.results.columns." + col + ".name", rsmd.getColumnLabel(col + 1));
            }
            int row = 0;
            while (rs.next()) {
                for (int col = 0; col < numCols; ++col) {
                    String val = rs.getString(col + 1);
                    this.m_resultStrings.put(prefix + "Report.results." + row + "." + col, val != null ? val : "");
                }
                ++row;
            }
            this.m_resultStrings.put(prefix + "Report.results.rowcount", "" + row);
        }
        catch (SQLException e) {
            D.log((Throwable)e);
            throw new PluginException("SQL Error", e.getMessage());
        }
        catch (Throwable e) {
            D.log((Throwable)e);
            throw new PluginException("SQL Read Error", e.getMessage());
        }
    }

    private void outputFormat(Element el) {
        if (el.hasChildren()) {
            List list = el.getChildren();
            for (int index = 0; index < list.size(); ++index) {
                this.outputFormat((Element)list.get(index));
            }
        } else {
            this.m_resultStrings.put(RunReport.getElementKey(el), el.getTextTrim());
        }
    }

    private static String getElementKey(Element el) {
        String strKey = eMFrameUtils.replaceSubString((String)el.getName(), (String)"-", (String)"_");
        for (Element parent = el.getParent(); parent != null; parent = parent.getParent()) {
            String tmp = eMFrameUtils.replaceSubString((String)parent.getName(), (String)"-", (String)"_");
            tmp = Character.toUpperCase(tmp.charAt(0)) + tmp.substring(1, tmp.length());
            strKey = tmp + "." + strKey;
        }
        return strKey;
    }

    private void safePut(String key, String val) {
        if (val != null) {
            this.m_resultStrings.put(key, val);
        }
    }

    public boolean outputMetadata(Connection conn) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet tables = metaData.getTables(null, null, "?", null);
            int tableIndex = 0;
            while (tables.next()) {
                String tableName = tables.getString("NAME");
                this.m_resultStrings.put("tables." + tableIndex + ".name", tableName);
                ResultSet columns = metaData.getColumns(null, null, tableName, "?");
                int columnIndex = 0;
                while (columns.next()) {
                    this.m_resultStrings.put("tables." + tableIndex + ".columns." + columnIndex + ".name", columns.getString(4));
                    this.m_resultStrings.put("tables." + tableIndex + ".columns." + columnIndex + ".type", columns.getString(6));
                    ++columnIndex;
                }
                this.m_resultStrings.put("tables." + tableIndex + ".columns.count", "" + columnIndex);
                ++tableIndex;
            }
            this.m_resultStrings.put("tables.count", "" + tableIndex);
        }
        catch (SQLException e) {
            eMFrameUtils.setMessage((String)"error", (String)"Error", (String)"Couldn't establish connection", (MContext)this.m_context);
            return false;
        }
        return true;
    }
}

