/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class SharedIdentificationPage
extends DirPropertyBookPage {
    String m_rightsToOtherName = null;

    public void show(PropertyPageContext context) throws PageException {
        boolean isRefreshing = false;
        HttpServletRequest req = context.getRequest();
        String[] values = null;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefreshing = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        values = isRefreshing ? (this.getDirPropertyBook().isMoo() ? new String[]{} : SharedIdentificationPage.readOtherNameForRefresh(this.getDirPropertyBook().getNSObject())) : (this.getDirPropertyBook().isMoo() ? new String[]{} : SharedIdentificationPage.readOtherName(this.getDirPropertyBook().getNSObject()));
        req.setAttribute("otherName", (Object)eMFrameUtils.pack((String[])values, (MContext)context));
        req.setAttribute("otherNameValues", (Object)values);
        this.m_rightsToOtherName = !this.getDirPropertyBook().isMoo() ? this.checkRightsForNamingAttribute((MContext)context) : "NONE";
        req.setAttribute("otherNameRights", (Object)this.m_rightsToOtherName);
        super.show(context);
    }

    public void cache(PropertyPageContext context) throws PageException {
        if (!this.getDirPropertyBook().isMoo() && this.m_rightsToOtherName.equals("RW")) {
            HttpServletRequest req = context.getRequest();
            String pack = req.getParameter("otherName_packedValues");
            if (pack == null) {
                pack = req.getParameter("otherName");
            }
            if (pack != null && pack.length() > 0) {
                String[] values = eMFrameUtils.unpack((String)pack, (MContext)context);
                SharedIdentificationPage.modifyOtherName(this.getDirPropertyBook().getNSObject(), values);
            }
        }
        if (!this.getDirPropertyBook().isMoo() && this.m_nsobj.getObjectEntry().getTypeName().equals("Directory Map")) {
            try {
                ObjectEntry serverObj;
                ObjectEntry volObj;
                String objType;
                AuthenticationBroker broker = context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
                AdminNamespace ns = treeOE.getAdminNamespace();
                HttpServletRequest req = context.getRequest();
                String pack = req.getParameter("_PathVolume");
                if (pack != null && !pack.trim().equals("") && !(objType = (volObj = ns.getObjectEntry(treeOE, pack)).getObjectType().getName()).equals("Volume")) {
                    String header = eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Book.invalidObject", (MContext)context);
                    String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotAVolume", (MContext)context);
                    body = eMFrameUtils.formatMessage((String)body, (Object[])new String[]{pack});
                    throw new PageException(header, body);
                }
                pack = req.getParameter("_Host_Server");
                if (pack != null && !pack.trim().equals("") && !(objType = (serverObj = ns.getObjectEntry(treeOE, pack)).getObjectType().getName()).equals("NCP Server")) {
                    String header = eMFrameUtils.getLocalizedString((String)"FwResources", (String)"Book.invalidObject", (MContext)context);
                    String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotANCPServer", (MContext)context);
                    body = eMFrameUtils.formatMessage((String)body, (Object[])new String[]{pack});
                    throw new PageException(header, body);
                }
            }
            catch (SPIException e) {
                D.log((Throwable)e);
            }
        }
        super.cache(context);
    }

    private String checkRightsForNamingAttribute(MContext context) throws PageException {
        NSObject nsobj = this.getDirPropertyBook().getNSObject();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log((Throwable)e);
        }
        AdminNamespace namespace = treeOE.getAdminNamespace();
        ObjectEntry userOE = null;
        try {
            userOE = namespace.getAuthenticatedIdentity(treeOE);
        }
        catch (SPIException e) {
            D.log((Throwable)e);
            throw new PageException((Exception)((Object)e));
        }
        ObjectEntry targetOE = nsobj.getObjectEntry();
        String[] attribNames = new String[1];
        String[] attribRights = null;
        attribNames[0] = SharedIdentificationPage.getNamingAttribute(nsobj);
        attribRights = DirUtils.getRights((ObjectEntry)targetOE, (ObjectEntry)userOE, (String[])attribNames);
        return attribRights[0];
    }

    public static String[] readOtherName(NSObject nsObj) {
        String attributeName = SharedIdentificationPage.getNamingAttribute(nsObj);
        ObjectAttribute attrib = null;
        attrib = nsObj.getAttribute(attributeName);
        ArrayList<String> values = new ArrayList<String>();
        if (attrib != null) {
            ObjectEntry oe = nsObj.getObjectEntry();
            String name = oe.getName();
            Enumeration valueSet = attrib.getValueComponents();
            while (valueSet.hasMoreElements()) {
                ValueComponent vc = (ValueComponent)valueSet.nextElement();
                String value = vc.toString();
                if (name.equalsIgnoreCase(SharedIdentificationPage.escapeSpecialChars(value))) continue;
                values.add(value);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    public static String[] readOtherNameForRefresh(NSObject nsObj) {
        String attributeName = SharedIdentificationPage.getNamingAttribute(nsObj);
        ObjectEntry objectEntry = nsObj.getObjectEntry();
        AdminNamespace ns = objectEntry.getAdminNamespace();
        ObjectAttribute attrib = null;
        try {
            attrib = ns.getAttribute(objectEntry, attributeName);
        }
        catch (SPIException e) {
            e.printStackTrace();
        }
        ArrayList<String> values = new ArrayList<String>();
        if (attrib != null) {
            ObjectEntry oe = nsObj.getObjectEntry();
            String name = oe.getName();
            Enumeration valueSet = attrib.getValueComponents();
            while (valueSet.hasMoreElements()) {
                ValueComponent vc = (ValueComponent)valueSet.nextElement();
                String value = vc.toString();
                if (name.equalsIgnoreCase(SharedIdentificationPage.escapeSpecialChars(value))) continue;
                values.add(value);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    private static String escapeSpecialChars(String dn) {
        dn = eMFrameUtils.replaceSubString((String)dn, (String)"\\", (String)"\\\\");
        dn = eMFrameUtils.replaceSubString((String)dn, (String)"+", (String)"\\+");
        dn = eMFrameUtils.replaceSubString((String)dn, (String)".", (String)"\\.");
        dn = eMFrameUtils.replaceSubString((String)dn, (String)"=", (String)"\\=");
        return dn;
    }

    private static String getNamingAttribute(NSObject nsObj) {
        ObjectEntry oe = nsObj.getObjectEntry();
        AdminNamespace ns = oe.getAdminNamespace();
        String typedName = ns.getFullyTypedName(oe);
        return typedName.substring(0, typedName.indexOf("="));
    }

    public static void modifyOtherName(NSObject nsObj, String[] items) throws PageException {
        String attributeName = SharedIdentificationPage.getNamingAttribute(nsObj);
        ObjectEntry oe = nsObj.getObjectEntry();
        String tmp = oe.getName();
        String name = tmp.substring(tmp.indexOf("=") + 1, tmp.length());
        ObjectAttribute attrib = nsObj.getAttribute(attributeName);
        try {
            ValueComponent vc;
            ArrayList<ValueComponent> list = new ArrayList<ValueComponent>();
            Enumeration myenum = attrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                ValueComponent vc2 = (ValueComponent)myenum.nextElement();
                list.add(vc2);
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                vc = (ValueComponent)iter.next();
                String vcStringValue = vc.toString();
                if (name.equalsIgnoreCase(SharedIdentificationPage.escapeSpecialChars(vcStringValue))) continue;
                attrib.removeComponent(vc);
            }
            for (int i = 0; i < items.length; ++i) {
                vc = attrib.getAttributeDefinition().getSyntax().createValueComponent((Object)items[i]);
                attrib.addComponent(vc);
            }
        }
        catch (ComponentCreationException e) {
            throw new PageException((Exception)((Object)e));
        }
        catch (NamespaceException e) {
            throw new PageException((Exception)((Object)e));
        }
    }
}

