/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.dataTable.IconTableCell;
import com.novell.emframe.dev.dataTable.LinkTableCell;
import com.novell.emframe.dev.dataTable.TableCell;
import com.novell.emframe.dev.dataTable.TextTableCell;
import com.novell.emframe.dev.eMFrameUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class TemplateVolumeSpaceRestrictions
extends DirPropertyBookPage {
    public void show(PropertyPageContext context) throws PageException {
        PathFacade pathFacade;
        ObjectAttribute vsrAttr;
        String sortColumn;
        TableCell[][] tableData = null;
        ArrayList<PathFacade> arrayList = new ArrayList<PathFacade>();
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        String sortDirection = req.getParameter("sortDirection");
        if (sortDirection == null) {
            sortDirection = "Descending";
            req.setAttribute("sortDirection", (Object)sortDirection);
        }
        if ((sortColumn = req.getParameter("sortColumn")) == null) {
            sortColumn = "1";
            req.setAttribute("sortColumn", (Object)sortColumn);
        }
        if ((vsrAttr = nsObj.getAttribute("Volume Space Restrictions")) != null) {
            Enumeration valueSet = vsrAttr.getValueComponents();
            while (valueSet.hasMoreElements()) {
                pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                arrayList.add(pathFacade);
            }
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Sorter(context, sortDirection, sortColumn));
        }
        if (arrayList.size() > 0) {
            tableData = new TableCell[arrayList.size()][];
            for (int i = 0; i < arrayList.size(); ++i) {
                pathFacade = (PathFacade)arrayList.get(i);
                String volumeName = pathFacade.getVolume();
                String pathName = pathFacade.getPath();
                String limit = new Long(pathFacade.getType()).toString() + " " + eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.KB", (Locale)context.getLocale());
                tableData[i] = new TableCell[5];
                String volumeDisplayName = context.getDirUtils().getObjectTypeDisplayName("Volume", (MContext)context);
                String iconUrl = "dev/dir/Volume.gif";
                tableData[i][0] = new IconTableCell(volumeDisplayName, iconUrl, "vsr");
                tableData[i][1] = new LinkTableCell(volumeName, volumeName);
                String physicalDisplayName = context.getDirUtils().getObjectTypeDisplayName("Netware Volume", (MContext)context);
                iconUrl = "dev/dir/Netware_Volume.gif";
                tableData[i][2] = new IconTableCell(physicalDisplayName, iconUrl, "vsr");
                tableData[i][3] = new TextTableCell(pathName, pathName);
                tableData[i][4] = new TextTableCell(limit, limit);
            }
        }
        if (tableData == null) {
            tableData = new TableCell[][]{};
        }
        req.setAttribute("tableData", (Object)tableData);
    }

    public void cache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        String operation = req.getParameter("operation");
        if (operation == null) {
            return;
        }
        if (operation.equalsIgnoreCase("addVolumeSpaceRestriction")) {
            this.addToCache(context);
        } else if (operation.equalsIgnoreCase("deleteVolumeSpaceRestriction")) {
            this.deleteFromCache(context);
        } else if (operation.equalsIgnoreCase("editVolumeSpaceRestriction")) {
            this.editCache(context);
        } else if (operation.equalsIgnoreCase("changeSortColumnDirection")) {
            return;
        }
    }

    public void addToCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        AdminNamespace ns = DirUtils.getAdminNamespace((MContext)context);
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        String newVolumeName = req.getParameter("volumeNameNewTF");
        ObjectEntry volumeOE = null;
        try {
            volumeOE = ns.getObjectEntry(treeOE, newVolumeName);
            context.addToHistory(volumeOE);
        }
        catch (SPIException exc) {
            throw new PageException((Exception)((Object)exc));
        }
        if (!volumeOE.getObjectType().getName().equalsIgnoreCase("Volume")) {
            String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.Warning", (Locale)context.getLocale());
            String msg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.InvalidObjectType", (Locale)context.getLocale());
            msg = eMFrameUtils.formatMessage((String)msg, (Object[])new String[]{ns.getUnrootedName(volumeOE)});
            throw new PageException(title, msg);
        }
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        ObjectAttribute vsrAttr = nsObj.getAttribute("Volume Space Restrictions");
        if (vsrAttr != null) {
            Enumeration valueSet = vsrAttr.getValueComponents();
            while (valueSet.hasMoreElements()) {
                PathFacade pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                String volumeName = pathFacade.getVolume();
                if (!ns.getUnrootedName(volumeOE).equalsIgnoreCase(volumeName)) continue;
                String title = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.Warning", (Locale)context.getLocale());
                String msg = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Template.ObjectExist", (Locale)context.getLocale());
                msg = eMFrameUtils.formatMessage((String)msg, (Object[])new String[]{ns.getUnrootedName(volumeOE)});
                throw new PageException(title, msg);
            }
        }
        String rootName = this.mapVolumeToRootName(volumeOE);
        String limitStr = req.getParameter("limitNewTF");
        long limit = Math.max(4, new Long(limitStr).intValue() / 4 * 4);
        try {
            if (vsrAttr == null) {
                vsrAttr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(volumeOE, "Volume Space Restrictions"));
                vsrAttr.addComponent((ValueComponent)PathFacade.createValueList((long)limit, (String)newVolumeName, (String)rootName));
                nsObj.addAttribute(vsrAttr);
            } else {
                vsrAttr.addComponent((ValueComponent)PathFacade.createValueList((long)limit, (String)newVolumeName, (String)rootName));
            }
        }
        catch (Exception exc) {
            throw new PageException(exc);
        }
    }

    public void deleteFromCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        String packedItemsToDelete = req.getParameter("packedItemsToDelete");
        String[] itemsToDelete = eMFrameUtils.unpack((String)packedItemsToDelete, (MContext)context);
        if (itemsToDelete != null && itemsToDelete.length > 0) {
            block0: for (int count = 0; count < itemsToDelete.length; ++count) {
                String volumeToDelete = itemsToDelete[count];
                ObjectAttribute vsrAttr = nsObj.getAttribute("Volume Space Restrictions");
                if (vsrAttr == null) continue;
                Enumeration valueSet = vsrAttr.getValueComponents();
                while (valueSet.hasMoreElements()) {
                    ValueList vl = (ValueList)valueSet.nextElement();
                    PathFacade pathFacade = (PathFacade)vl.createFacade();
                    String volumeName = pathFacade.getVolume();
                    if (!volumeToDelete.equalsIgnoreCase(volumeName)) continue;
                    vsrAttr.removeComponent((ValueComponent)vl);
                    continue block0;
                }
            }
        }
    }

    public void editCache(PropertyPageContext context) throws PageException {
        HttpServletRequest req = context.getRequest();
        NSObject nsObj = this.getDirPropertyBook().getNSObject();
        String limitStr = req.getParameter("limitEditTF");
        long limit = Math.max(4, new Long(limitStr).intValue() / 4 * 4);
        String packedItemsToEdit = req.getParameter("packedItemsToEdit");
        String[] itemsToEdit = eMFrameUtils.unpack((String)packedItemsToEdit, (MContext)context);
        if (itemsToEdit != null && itemsToEdit.length > 0) {
            for (int count = 0; count < itemsToEdit.length; ++count) {
                String volumeToEdit = itemsToEdit[count];
                ObjectAttribute vsrAttr = nsObj.getAttribute("Volume Space Restrictions");
                if (vsrAttr == null) continue;
                Enumeration valueSet = vsrAttr.getValueComponents();
                while (valueSet.hasMoreElements()) {
                    ValueList oldvl = (ValueList)valueSet.nextElement();
                    PathFacade pathFacade = (PathFacade)oldvl.createFacade();
                    String volumeName = pathFacade.getVolume();
                    if (!volumeToEdit.equalsIgnoreCase(volumeName)) continue;
                    ValueList newvl = PathFacade.createValueList((long)limit, (String)pathFacade.getVolume(), (String)pathFacade.getPath());
                    try {
                        vsrAttr.replaceComponent((ValueComponent)oldvl, (ValueComponent)newvl);
                    }
                    catch (NamespaceException exc) {
                        throw new PageException((Exception)((Object)exc));
                    }
                }
            }
        }
    }

    private String mapVolumeToRootName(ObjectEntry volumeOE) throws PageException {
        String rootName = "";
        AdminNamespace ns = volumeOE.getAdminNamespace();
        try {
            ObjectAttribute hostVolumeAttrib = ns.getAttribute(volumeOE, "Host Resource Name");
            ObjectAttribute hostServerAttrib = ns.getAttribute(volumeOE, "Host Server");
            String volumeLocalId = "";
            String serverNameDN = "";
            if (hostVolumeAttrib != null) {
                volumeLocalId = ((StringValue)hostVolumeAttrib.getValueComponents().nextElement()).getValue();
            }
            if (hostServerAttrib != null) {
                serverNameDN = ((StringValue)hostServerAttrib.getValueComponents().nextElement()).getValue();
            }
            String serverLocalId = this.getSimpleServerNameFromServerDN(serverNameDN);
            rootName = serverLocalId + "/" + volumeLocalId + ":";
        }
        catch (SPIException exc) {
            throw new PageException((Exception)((Object)exc));
        }
        return rootName;
    }

    private String getSimpleServerNameFromServerDN(String fullServerName) {
        int dotidx;
        int slen = fullServerName.length();
        for (dotidx = 0; dotidx < slen && fullServerName.charAt(dotidx) != '.'; ++dotidx) {
            if (fullServerName.charAt(dotidx) != '\\') continue;
            ++dotidx;
        }
        return fullServerName.substring(0, dotidx);
    }

    public class Sorter
    implements Comparator {
        private Collator m_collator = null;
        private PropertyPageContext m_context = null;
        private String m_sortDirection = null;
        private String m_sortColumn = null;
        public static final String SORT_ASCENDING = "Ascending";
        public static final String SORT_DESCENDING = "Descending";
        public static final String SORT_VOLUME = "1";
        public static final String SORT_PATH = "3";
        public static final String SORT_LIMIT = "4";

        public Sorter(PropertyPageContext context, String sortDirection, String sortColumn) {
            this.m_context = context;
            this.m_sortDirection = sortDirection;
            this.m_sortColumn = sortColumn;
            this.m_collator = Collator.getInstance(this.m_context.getLocale());
        }

        public int compare(Object object1, Object object2) {
            int compare = 0;
            if (this.m_sortColumn.equalsIgnoreCase(SORT_VOLUME)) {
                String str1 = ((PathFacade)object1).getVolume();
                String str2 = ((PathFacade)object2).getVolume();
                compare = this.compareString(str1, str2);
            } else if (this.m_sortColumn.equalsIgnoreCase(SORT_PATH)) {
                String str1 = ((PathFacade)object1).getPath();
                String str2 = ((PathFacade)object2).getPath();
                compare = this.compareString(str1, str2);
            } else if (this.m_sortColumn.equalsIgnoreCase(SORT_LIMIT)) {
                long long1 = ((PathFacade)object1).getType();
                long long2 = ((PathFacade)object2).getType();
                compare = this.compareLong(long1, long2);
            }
            return compare;
        }

        public int compareString(Object object1, Object object2) {
            int compare = 0;
            compare = this.m_sortDirection.equalsIgnoreCase(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
            return compare;
        }

        private int compareLong(long num1, long num2) {
            int compare = 0;
            Long long1 = new Long(num1);
            Long long2 = new Long(num2);
            compare = this.m_sortDirection.equals(SORT_DESCENDING) ? long1.compareTo(long2) : long2.compareTo(long1);
            return compare;
        }
    }
}

