/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base.partition;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.OperationStatus;
import com.novell.admin.ns.PartitionOperationCallBack;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.partition.Preconditions;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class MergePartitionTask
extends Task {
    private final int CONTINUE = 0;
    private final int ABORT = 1;
    private final int NO_WAIT = 2;
    private final int EXCEPTION = 3;
    private TaskContext context;
    private Properties resultStrings;
    private HttpServletRequest req;
    private String strException;
    private UpdateThread thread;
    private OperationStatus status;
    private int flag;
    private Exception exception;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("mergePartition")) {
            return this.mergePartition();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("close")) {
            return this.close();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
        this.resultStrings.put("ObjectNameInstructions", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.PartitionInstructions", (MContext)this.context));
        this.resultStrings.put("ObjectNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Partition", (MContext)this.context));
        this.resultStrings.put("Next.State", "mergePartition");
        this.resultStrings.put("MemberTypeFilter", "[partitions]");
        this.resultStrings.put("GifName", this.context.getDirUtils().getObjectTypeImageName("MergePartition16"));
        this.resultStrings.put("helpNameTag", "base/mergepartition.html");
        return true;
    }

    private boolean mergePartition() {
        String selectedContainer = this.req.getParameter("eDir$target");
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry partitonOE = null;
        try {
            partitonOE = namespace.getObjectEntry(treeOE, selectedContainer);
            if (!ObjectFlags.isContainer((long)partitonOE.getObjectFlags())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAContainer", (MContext)this.context));
                return false;
            }
            if (!ObjectFlags.isPartition((long)partitonOE.getObjectFlags())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAPartition", (MContext)this.context));
                return false;
            }
            if (!Preconditions.hasPartitionSupervisorRights(partitonOE)) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NoParentRights", (MContext)this.context));
                return false;
            }
            if (!Preconditions.areServersInReplicaRingUp(partitonOE)) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.AllServersNotUp", (MContext)this.context));
                return false;
            }
            NDSPartitionService partitionService = (NDSPartitionService)namespace.getPartitionService(partitonOE);
            this.status = partitionService.mergePartition(partitonOE);
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        this.context.addToHistory(partitonOE);
        String taskId = this.req.getParameter("taskId");
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode((String)taskId, (MContext)this.context) + "&merge=base.partition.PartitionProgress&User.context=" + "&nextState=refresh");
        this.resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.req).setParameter("merge", "fw.UrlTask");
        this.flag = 0;
        this.thread = new UpdateThread();
        this.thread.start();
        return true;
    }

    private boolean refresh() {
        if (this.flag == 2) {
            this.resultStrings.put("dev.refreshOV", "true");
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartitionSuccessful", (MContext)this.context));
            ((I18NServletRequest)this.req).setParameter("merge", "dev.GenConf");
        }
        if (this.flag == 3) {
            D.log((Throwable)this.exception);
            eMFrameUtils.setErrorMessage((Throwable)this.exception, (MContext)this.context);
            ((I18NServletRequest)this.req).setParameter("merge", "dev.GenErr");
        }
        return true;
    }

    private boolean cancel() {
        this.flag = 1;
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartitionCancel", (MContext)this.context));
        ((I18NServletRequest)this.req).setParameter("merge", "dev.GenConf");
        return true;
    }

    private boolean close() {
        this.flag = 2;
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartition", (MContext)this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.MergePartitionClose", (MContext)this.context));
        ((I18NServletRequest)this.req).setParameter("merge", "dev.GenConf");
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }

    class UpdateThread
    extends Thread
    implements PartitionOperationCallBack {
        public UpdateThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            try {
                int state = MergePartitionTask.this.status.getStatus();
                if (state == 1) {
                    MergePartitionTask.this.flag = 2;
                } else {
                    MergePartitionTask.this.status.waitForOperation(2000, (PartitionOperationCallBack)this);
                }
            }
            catch (SPIException e) {
                MergePartitionTask.this.exception = (Exception)((Object)e);
                MergePartitionTask.this.flag = 3;
                return;
            }
        }

        public int toDo() {
            int state;
            try {
                state = MergePartitionTask.this.status.getStatus();
            }
            catch (SPIException e) {
                MergePartitionTask.this.exception = (Exception)((Object)e);
                MergePartitionTask.this.flag = 3;
                return 2;
            }
            if (state == 1) {
                MergePartitionTask.this.flag = 2;
                return 2;
            }
            if (MergePartitionTask.this.flag == 2) {
                return 2;
            }
            if (MergePartitionTask.this.flag == 1) {
                return 0;
            }
            return 1;
        }
    }
}

