/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base.partition;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.Replica;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;

public class Preconditions {
    public static boolean hasPartitionSupervisorRights(ObjectEntry oe) throws SPIException {
        boolean hasSupervisorRights = false;
        NDSNamespace ndsns = (NDSNamespace)oe.getObjectType().getNamespace();
        ObjectEntry trustee = ndsns.getAuthenticatedIdentity(oe);
        for (ObjectEntry parent = oe.getParent(); parent != null; parent = parent.getParent()) {
            if (!ObjectFlags.isPartition((long)parent.getObjectFlags())) continue;
            NDSObjectRights objRights = (NDSObjectRights)ndsns.getObjectEffectiveRights(parent, trustee);
            if (!objRights.hasSupervisorRights()) break;
            hasSupervisorRights = true;
            break;
        }
        return hasSupervisorRights;
    }

    static boolean areServersInReplicaRingUp(ObjectEntry oe) throws SPIException {
        boolean areServersInReplicaRingUp = true;
        NDSNamespace ndsns = (NDSNamespace)oe.getObjectType().getNamespace();
        NDSPartitionService partService = (NDSPartitionService)ndsns.getPartitionService(oe);
        block0: for (ObjectEntry partObjEntry = oe; partObjEntry != null; partObjEntry = partObjEntry.getParent()) {
            if (!ObjectFlags.isPartition((long)partObjEntry.getObjectFlags())) continue;
            Replica[] replicas = partService.getPartitionReplicaList(partObjEntry, null);
            if (replicas == null || replicas.length <= 0) break;
            for (int i = 0; i < replicas.length; ++i) {
                if (ndsns.isServerUp(replicas[i].getStoredOnServer())) continue;
                areServersInReplicaRingUp = false;
                break block0;
            }
            break;
        }
        return areServersInReplicaRingUp;
    }
}

