/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base.partition;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSPartitionInfo;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.DateFormat;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ViewPartitionInfoTask
extends Task {
    private TaskContext context;
    private Properties resultStrings;
    private HttpServletRequest req;
    private boolean firstTimeThru = true;
    private String selectedContainer = "";

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (this.firstTimeThru) {
            this.selectedContainer = eMFrameUtils.getSingleTarget((HttpServletRequest)this.req);
            if (this.selectedContainer.length() > 0) {
                nextState = "viewPartitionInfo";
                ((I18NServletRequest)this.req).setParameter("merge", "base.partition.PartitionInformation");
                ((I18NServletRequest)this.req).setParameter("error", "dev.GenErr");
            }
            this.firstTimeThru = false;
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("viewPartitionInfo")) {
            return this.viewPartitionInfo();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ViewPartitionInfo", (MContext)this.context));
        this.resultStrings.put("ObjectNameInstructions", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ViewPartitionInstructions", (MContext)this.context));
        this.resultStrings.put("ObjectNameTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.Partition", (MContext)this.context));
        this.resultStrings.put("Next.State", "viewPartitionInfo");
        this.resultStrings.put("Merge.Template", "base.partition.PartitionInformation");
        this.resultStrings.put("MemberTypeFilter", "[partitions],[root]");
        this.resultStrings.put("GifName", this.context.getDirUtils().getObjectTypeImageName("partition16"));
        return true;
    }

    private boolean viewPartitionInfo() {
        ObjectEntry partitonOE;
        if (this.selectedContainer.length() == 0) {
            this.selectedContainer = this.req.getParameter("eDir$target");
        }
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        try {
            if (this.selectedContainer.startsWith(".") && this.selectedContainer.endsWith(".") && this.selectedContainer.equalsIgnoreCase(treeOE.getName()) || this.selectedContainer.equalsIgnoreCase("[root]")) {
                partitonOE = treeOE;
                this.selectedContainer = "[Root]";
            } else {
                partitonOE = namespace.getObjectEntry(treeOE, this.selectedContainer);
            }
            if (!ObjectFlags.isContainer((long)partitonOE.getObjectFlags())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ViewPartitionInfo", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAContainer", (MContext)this.context));
                return false;
            }
            if (!ObjectFlags.isPartition((long)partitonOE.getObjectFlags())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.ViewPartitionInfo", (MContext)this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"PartitionReplica.NotAPartition", (MContext)this.context));
                return false;
            }
            NDSPartitionService partitionService = (NDSPartitionService)namespace.getPartitionService(treeOE);
            NDSPartitionInfo partInfo = partitionService.getPartitionInfo(partitonOE);
            this.resultStrings.put("PartitionInfo.Partition", partInfo.getPartitionFDN());
            this.resultStrings.put("PartitionInfo.ServerRead", partInfo.getServerReadFDN());
            this.resultStrings.put("PartitionInfo.MasterReplica", partInfo.getMasterReplicaFDN());
            this.resultStrings.put("PartitionInfo.NumberReplica", new Integer(partInfo.getNumOfReplicas()).toString());
            this.resultStrings.put("PartitionInfo.SubReferences", new Integer(partInfo.getNumOfSubRefs()).toString());
            this.resultStrings.put("PartitionInfo.LastSuccessSync", DateFormat.getDateTimeInstance(1, 1, this.context.getLocale()).format(partInfo.getLastSuccessfulSyncTime()));
            this.resultStrings.put("PartitionInfo.LastAttemtSync", DateFormat.getDateTimeInstance(1, 1, this.context.getLocale()).format(partInfo.getLastAttemptedSyncTime()));
        }
        catch (Exception e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        this.context.addToHistory(partitonOE);
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

