/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

public class ASNTypes {
    static int MAX_SUBID = -1;
    static int MAX_OID_LEN = 64;
    static final byte ASN_BOOLEAN = 1;
    static final byte ASN_INTEGER = 2;
    static final byte ASN_BIT_STR = 3;
    static final byte ASN_OCTET_STR = 4;
    static final byte ASN_NULL = 5;
    static final byte ASN_OBJECT_ID = 6;
    static final byte ASN_SEQUENCE = 16;
    static final byte ASN_SET = 17;
    static final byte ASN_UNIVERSAL = 0;
    static final byte ASN_APPLICATION = 64;
    static final byte ASN_CONTEXT = -128;
    static final byte ASN_PRIVATE = -64;
    static final int ASN_EXCEPTION = 128;
    static final byte ASN_PRIMITIVE = 0;
    static final byte ASN_CONSTRUCTOR = 32;
    static final byte ASN_LONG_LEN = -128;
    static final byte ASN_EXTENSION_ID = 31;
    static final byte ASN_BIT8 = -128;

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    static boolean IS_CONSTRUCTOR(byte b) {
        return (b & 0x20) != 0;
    }

    static boolean IS_EXTENSION_ID(byte b) {
        return (b & 0x1F) == 31;
    }

    private static int encodeLength(byte[] buff, int space, int value) throws ArrayIndexOutOfBoundsException {
        if (value < 128) {
            buff[--space] = (byte)value;
        } else {
            int len = 0;
            do {
                buff[--space] = (byte)(value & 0xFF);
                ++len;
            } while ((value >>>= 8) != 0);
            buff[--space] = (byte)(len | 0x80);
        }
        return space;
    }

    static int encodeInt(byte[] buff, int space, int value, int id) throws ArrayIndexOutOfBoundsException {
        int residual = value < 0 ? -128 : 0;
        int len = 0;
        while (true) {
            buff[--space] = (byte)(value & 0xFF);
            ++len;
            if ((value & 0xFFFFFF80) == residual) break;
            value >>= 8;
        }
        buff[--space] = (byte)len;
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeUInt(byte[] buff, int space, int value, int id) throws ArrayIndexOutOfBoundsException {
        int len = 0;
        while (true) {
            buff[--space] = (byte)(value & 0xFF);
            ++len;
            if ((value & 0xFFFFFF80) == 0) break;
            value >>>= 8;
        }
        buff[--space] = (byte)len;
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeUInt(byte[] buff, int space, long value, int id) throws ArrayIndexOutOfBoundsException {
        int len = 0;
        while (true) {
            buff[--space] = (byte)(value & 0xFFL);
            ++len;
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            value >>>= 8;
        }
        buff[--space] = (byte)len;
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeOctets(byte[] buff, int space, byte[] octets, int offset, int count, int id) throws ArrayIndexOutOfBoundsException {
        if (octets != null) {
            System.arraycopy(octets, offset, buff, space - count, count);
        } else {
            count = 0;
        }
        space = ASNTypes.encodeLength(buff, space - count, count);
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeString(byte[] buff, int space, String string, int offset, int count, int id) throws ArrayIndexOutOfBoundsException {
        if (string != null) {
            string.getBytes(offset, offset + count, buff, space - count);
        } else {
            count = 0;
        }
        space = ASNTypes.encodeLength(buff, space - count, count);
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeOid(byte[] buff, int space, int[] oid, int count, int id) throws ArrayIndexOutOfBoundsException {
        int len = 1;
        if (count < 2) {
            buff[--space] = 0;
        } else {
            int i = count - 1;
            while (i > 1) {
                int val = oid[i];
                buff[--space] = (byte)(val & 0x7F);
                ++len;
                while ((val & 0xFFFFFF80) != 0) {
                    buff[--space] = (byte)((val >>>= 7) & 0x7F | 0x80);
                    ++len;
                }
                --i;
            }
            buff[--space] = (byte)(40 * oid[0] + oid[1]);
        }
        space = ASNTypes.encodeLength(buff, space, len);
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeNull(byte[] buff, int space, int id) throws ArrayIndexOutOfBoundsException {
        buff[--space] = 0;
        buff[--space] = (byte)id;
        return space;
    }

    static int encodeSequence(byte[] buff, int space, int length, int id) throws ArrayIndexOutOfBoundsException {
        space = ASNTypes.encodeLength(buff, space, length);
        buff[--space] = (byte)id;
        return space;
    }
}

