/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.LeafSyntax;
import Snmp2.MibException;
import Snmp2.MibMacro;
import Snmp2.MibNode;
import Snmp2.MibTC;
import Snmp2.MibTrap;
import Snmp2.SnmpAPI;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibModule {
    public String name;
    public long[] rootOID;
    public String[] rootOIDString;
    public MibNode root;
    public Hashtable macroList = new Hashtable();
    public static Hashtable nodeList = new Hashtable();
    public Hashtable syntaxList = new Hashtable();
    public Hashtable trapList = new Hashtable();
    public Hashtable tcList = new Hashtable();
    protected String filename;
    protected boolean inModule = false;
    protected InputStream fstr;
    protected boolean DEBUG = false;
    protected SnmpAPI API;
    protected Applet applet;
    protected boolean fromModuleCompliance = false;
    protected String mibFileDir;
    StringBuffer sb = new StringBuffer();
    public DataOutputStream ostr;

    public MibModule(SnmpAPI api) throws MibException, IOException, FileNotFoundException {
        this.API = api;
    }

    public MibModule(String file, SnmpAPI api, boolean debug) throws MibException, IOException, FileNotFoundException {
        this(file, null, api, debug);
    }

    public MibModule(String file, String enc, SnmpAPI api, boolean debug) throws MibException, IOException, FileNotFoundException {
        this.DEBUG = debug;
        this.API = api;
        this.filename = file;
        int index = file.lastIndexOf("/");
        if (index < 0) {
            index = file.lastIndexOf("\\");
        }
        this.mibFileDir = index > 0 ? file.substring(0, index + 1) : "." + File.separator;
        this.fstr = new FileInputStream(file);
        BufferedReader isReader = enc == null ? new BufferedReader(new InputStreamReader(this.fstr)) : new BufferedReader(new InputStreamReader(this.fstr, enc));
        StreamTokenizer tok = new StreamTokenizer(isReader);
        this.parseMibModule(tok);
        this.fstr.close();
    }

    public MibModule(InputStream stream, SnmpAPI api, boolean debug) throws MibException, IOException {
        this(stream, api, debug, null);
    }

    public MibModule(InputStream stream, SnmpAPI api, boolean debug, Applet app) throws MibException, IOException {
        this(stream, null, api, debug, app);
    }

    public MibModule(InputStream stream, String enc, SnmpAPI api, boolean debug, Applet app) throws MibException, IOException {
        this.DEBUG = debug;
        this.API = api;
        if (app != null) {
            this.applet = app;
            this.mibFileDir = app.getParameter("MIBS_DIR");
        }
        this.mibFileDir = this.mibFileDir == null ? "./" : String.valueOf(this.mibFileDir) + "/";
        this.fstr = new BufferedInputStream(stream);
        InputStreamReader isReader = enc == null ? new InputStreamReader(this.fstr) : new InputStreamReader(this.fstr, enc);
        StreamTokenizer tok = new StreamTokenizer(isReader);
        this.parseMibModule(tok);
    }

    public MibModule(InputStream stream, String enc, SnmpAPI api, boolean debug) throws MibException, IOException {
        this(stream, enc, api, debug, null);
    }

    protected void parseMibModule(StreamTokenizer tok) throws MibException, IOException, FileNotFoundException {
        if (this.API.client == null) {
            this.DEBUG = false;
        }
        tok.wordChars(35, 122);
        tok.ordinaryChar(34);
        tok.ordinaryChar(59);
        tok.ordinaryChar(40);
        tok.ordinaryChar(41);
        tok.ordinaryChar(46);
        tok.ordinaryChar(44);
        this.initSyntaxes();
        this.initMacros();
        if (nodeList.isEmpty()) {
            this.initNodes();
        } else {
            this.root = (MibNode)nodeList.get("INIT::=iso");
            this.rootOID = new long[1];
            this.rootOID[0] = 1L;
            this.rootOIDString = new String[1];
            this.rootOIDString[0] = "iso";
        }
        String currentToken = null;
        LeafSyntax syntax = null;
        currentToken = this.getToken(tok);
        if (currentToken == null) {
            this.errorToken("No valid data", tok);
        }
        this.name = currentToken;
        currentToken = this.getToken(tok);
        if (currentToken == null) {
            this.errorToken("Module: Unexpected end of data", tok);
        }
        if (currentToken.equals("{")) {
            tok.pushBack();
            Vector oid = this.parseOID(tok);
            if (oid == null) {
                this.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
            }
            if ((currentToken = this.getToken(tok)) == null) {
                this.errorToken("Module: Unexpected end of data", tok);
            }
        }
        if (!currentToken.equals("DEFINITIONS")) {
            this.errorToken("Module: Bad parse, expected DEFINITIONS", tok);
        }
        if ((currentToken = this.getToken(tok)) == null) {
            this.errorToken("Module: Unexpected end of data", tok);
        }
        if (!currentToken.equals("::=")) {
            this.errorToken("Module: Bad parse, expected ::=", tok);
        }
        if ((currentToken = this.getToken(tok)) == null) {
            this.errorToken("Module: Unexpected end of data", tok);
        }
        if (!currentToken.equals("BEGIN")) {
            this.errorToken("Module: Bad parse, expected BEGIN", tok);
        }
        this.inModule = true;
        while ((currentToken = this.getToken(tok)) != null && !currentToken.equals("END")) {
            if (currentToken.equals("IMPORTS")) {
                currentToken = this.getToken(tok);
                if (currentToken == null) {
                    this.errorToken("IMPORTS: Unexpected end of data", tok);
                }
                while (!currentToken.equals(";")) {
                    Vector<String> imports = new Vector<String>();
                    while (!currentToken.equals("FROM")) {
                        if (!currentToken.equals(",")) {
                            imports.addElement(currentToken);
                        }
                        if ((currentToken = this.getToken(tok)) != null) continue;
                        this.errorToken("IMPORTS: Unexpected end of data", tok);
                    }
                    currentToken = this.getToken(tok);
                    if (currentToken == null) {
                        this.errorToken("IMPORTS: Unexpected end of data", tok);
                    }
                    this.parseImports(imports, currentToken);
                    currentToken = this.getToken(tok);
                    if (currentToken != null) continue;
                    this.errorToken("IMPORTS: Unexpected end of data", tok);
                }
                continue;
            }
            if (this.DEBUG) {
                this.API.client.debugPrint("Current Name: " + currentToken);
            }
            this.isLabel(currentToken, tok);
            String label = currentToken;
            currentToken = this.getToken(tok);
            if (currentToken == null) {
                this.errorToken("Unexpected end of data", tok);
                return;
            }
            if (this.DEBUG) {
                this.API.client.debugPrint("Next Token: " + currentToken);
            }
            if (currentToken.equals("MACRO")) {
                while (!currentToken.equals("END")) {
                    currentToken = this.getToken(tok);
                    if (currentToken != null) continue;
                    this.errorToken("MACRO: Unexpected end of data", tok);
                }
                if (this.macroList.get(label) != null) continue;
                this.errorToken("Unable to parse MACRO definition.", tok);
                continue;
            }
            if (currentToken.equals("OBJECT IDENTIFIER")) {
                Vector oid;
                String addKeyName = this.name;
                MibModule addKeyModule = this;
                currentToken = this.getToken(tok);
                if (currentToken == null) {
                    this.errorToken("OID: Unexpected end of data", tok);
                }
                if (!currentToken.equals("::=")) {
                    this.errorToken("OID: Bad parse, expecting ::= ", tok);
                }
                if ((oid = this.parseOID(tok)) == null) {
                    this.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
                }
                if (this.DEBUG) {
                    this.API.client.debugPrint("OID: " + oid);
                }
                MibNode node = new MibNode();
                try {
                    node.subid = new Long((String)oid.lastElement());
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorToken("OID: Cannot parse Sub-ID", tok);
                }
                node.label = label;
                if (nodeList.get(new String("INIT::=" + label)) != null) {
                    MibNode tempNode = (MibNode)nodeList.get(new String("INIT::=" + label));
                    addKeyName = "INIT";
                    oid.removeElement(oid.lastElement());
                    if (tempNode.parent == this.getNode(oid) && node.subid == tempNode.subid) {
                        node = tempNode;
                    }
                    oid.addElement(new Long(node.subid).toString());
                } else {
                    Enumeration ae = this.API.modules.elements();
                    while (ae.hasMoreElements()) {
                        MibModule tempModule = (MibModule)ae.nextElement();
                        if (nodeList.get(new String(String.valueOf(tempModule.name) + "::=" + label)) == null) continue;
                        MibNode tempNode = (MibNode)nodeList.get(new String(String.valueOf(tempModule.name) + "::=" + label));
                        oid.removeElement(oid.lastElement());
                        if (tempNode.parent == tempModule.getNode(oid) && node.subid == tempNode.subid) {
                            node = tempNode;
                            addKeyModule = tempModule;
                            addKeyName = tempModule.name;
                        }
                        oid.addElement(new Long(node.subid).toString());
                        break;
                    }
                }
                oid.removeElement(oid.lastElement());
                node.parent = addKeyModule.getNode(oid);
                if (node.parent == null) {
                    this.errorToken("MIB node has no parent", tok);
                } else {
                    int insertIndex = 0;
                    boolean insert = false;
                    int i = 0;
                    while (i < node.parent.childList.size()) {
                        if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                            node.parent.childList.removeElementAt(i);
                            insertIndex = i;
                            insert = true;
                            break;
                        }
                        ++i;
                    }
                    if (insert) {
                        node.parent.childList.insertElementAt(node, insertIndex);
                    } else {
                        node.parent.childList.addElement(node);
                    }
                }
                if (this.root == (MibNode)nodeList.get("INIT::=iso")) {
                    this.root = node;
                    this.rootOID = node.getOID();
                    int i = 0;
                    Vector v = node.getOIDVector();
                    if (v == null) {
                        this.errorToken("MIB root string returns null", tok);
                    }
                    this.rootOIDString = new String[v.size()];
                    Enumeration e = v.elements();
                    while (e.hasMoreElements()) {
                        this.rootOIDString[i++] = (String)e.nextElement();
                    }
                } else {
                    int length = 0;
                    boolean changeRoot = false;
                    long[] nodeOID = node.getOID();
                    length = nodeOID.length >= this.rootOID.length ? this.rootOID.length : nodeOID.length;
                    int i = 0;
                    while (i < length) {
                        if (this.rootOID[i] != nodeOID[i]) {
                            changeRoot = true;
                            length = i;
                            break;
                        }
                        ++i;
                    }
                    long[] subnodeOID = new long[length];
                    int j = 0;
                    while (j < length) {
                        subnodeOID[j] = nodeOID[j];
                        ++j;
                    }
                    if (changeRoot) {
                        this.rootOID = subnodeOID;
                        this.root = (MibNode)nodeList.get("INIT::=iso");
                        int j2 = 1;
                        while (j2 < subnodeOID.length) {
                            if (this.root == null) {
                                this.errorToken("Bad oid, cannot be the root", tok);
                            }
                            if (this.root.syntax != null) break;
                            Enumeration e = this.root.childList.elements();
                            while (e.hasMoreElements()) {
                                this.root = (MibNode)e.nextElement();
                                if (subnodeOID[j2] == this.root.subid) break;
                                this.root = null;
                            }
                            ++j2;
                        }
                        if (this.root == null) {
                            this.errorToken("Bad oid, cannot be the root", tok);
                        }
                        int i2 = 0;
                        Vector v = this.root.getOIDVector();
                        if (v == null) {
                            this.errorToken("MIB root string returns null", tok);
                        }
                        this.rootOIDString = new String[v.size()];
                        Enumeration e = v.elements();
                        while (e.hasMoreElements()) {
                            this.rootOIDString[i2++] = (String)e.nextElement();
                        }
                    }
                }
                String temp = new String(String.valueOf(addKeyName) + "::=" + label);
                node.moduleName = node.moduleName != null && node.moduleName.indexOf(this.name) == -1 ? String.valueOf(node.moduleName) + " " + this.name : this.name;
                nodeList.put(temp, node);
                continue;
            }
            MibMacro macro = (MibMacro)this.macroList.get(currentToken);
            if (macro != null) {
                Object output = macro.parseMacro(label, currentToken, this, tok);
                if (output == null) continue;
                if (output.getClass().getName().equals("Snmp2.MibNode")) {
                    MibNode node = (MibNode)output;
                    String temp1 = new String(String.valueOf(this.name) + "::=" + label);
                    node.moduleName = this.name;
                    nodeList.put(temp1, node);
                    continue;
                }
                if (output.getClass().getName().equals("Snmp2.MibTrap")) {
                    MibTrap trap = (MibTrap)output;
                    trap.moduleName = this.name;
                    this.trapList.put(label, trap);
                    continue;
                }
                this.errorToken("Incorrect return from MACRO: Type:" + output.getClass().getName(), tok);
                continue;
            }
            if (currentToken.equals("::=")) {
                currentToken = this.getToken(tok);
                if (currentToken == null) {
                    this.errorToken("MACRO: Unexpected end of data", tok);
                }
                if (this.DEBUG) {
                    this.API.client.debugPrint("Parsing: label ::=  " + currentToken);
                }
                if (currentToken.equals("SEQUENCE")) {
                    Vector tableColumns = this.parseSequence(tok);
                    MibNode nod = null;
                    Enumeration e = nodeList.elements();
                    while (e.hasMoreElements()) {
                        nod = (MibNode)e.nextElement();
                        if (label.equals(nod.tableSequence)) break;
                    }
                    if (nod == null) continue;
                    nod.tableItems = tableColumns;
                    continue;
                }
                syntax = (LeafSyntax)this.syntaxList.get(currentToken);
                if (syntax != null) {
                    tok.pushBack();
                    syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                    if (syntax == null) continue;
                    this.syntaxList.put(label, syntax);
                    continue;
                }
                if (currentToken.equals("TEXTUAL-CONVENTION")) {
                    MibTC textconv = new MibTC();
                    currentToken = this.getToken(tok);
                    if (currentToken == null) {
                        this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                    }
                    while (!currentToken.equals("SYNTAX")) {
                        if (currentToken.equals("DISPLAY-HINT")) {
                            currentToken = this.getToken(tok);
                            if (currentToken == null) {
                                this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                            }
                            textconv.displayHint = currentToken;
                        } else if (currentToken.equals("STATUS")) {
                            currentToken = this.getToken(tok);
                            if (currentToken == null) {
                                this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                            }
                            textconv.status = currentToken;
                        } else if (currentToken.equals("DESCRIPTION")) {
                            currentToken = this.getToken(tok);
                            if (currentToken == null) {
                                this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                            }
                            textconv.description = currentToken;
                        } else if (currentToken.equals("REFERENCE")) {
                            currentToken = this.getToken(tok);
                            if (currentToken == null) {
                                this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                            }
                            textconv.reference = currentToken;
                        } else {
                            this.errorToken("TEXTUAL-CONVENTION: Unexpected word in macro", tok);
                        }
                        currentToken = this.getToken(tok);
                        if (currentToken != null) continue;
                        this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                    }
                    if (currentToken.equals("SYNTAX")) {
                        currentToken = this.getToken(tok);
                        if (currentToken == null) {
                            this.errorToken("TEXTUAL-CONVENTION: Unexpected end of data", tok);
                            continue;
                        }
                        syntax = (LeafSyntax)this.syntaxList.get(currentToken);
                        if (syntax != null) {
                            tok.pushBack();
                            syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                            if (syntax != null) {
                                this.syntaxList.put(label, syntax);
                            }
                            textconv.label = label;
                            textconv.syntax = syntax;
                            this.tcList.put(label, textconv);
                            continue;
                        }
                        this.errorToken("TEXTUAL-CONVENTION: Unexpected word in macro", tok);
                        continue;
                    }
                    this.errorToken("TEXTUAL-CONVENTION: Unexpected word in macro", tok);
                    continue;
                }
                this.errorToken("label ::= ?: Dont know how to parse.", tok);
                continue;
            }
            this.errorToken("label ?: Dont know how to parse.", tok);
        }
        if (currentToken == null) {
            this.errorToken("No END in module: End of file reached", tok);
        }
        this.inModule = false;
        this.API.modules.addElement(this);
    }

    void changeRoot(MibNode node, StreamTokenizer tok) throws MibException, IOException {
        block12: {
            block11: {
                if (this.root != (MibNode)nodeList.get("INIT::=iso")) break block11;
                this.root = node;
                this.rootOID = node.getOID();
                int i = 0;
                Vector v = node.getOIDVector();
                if (v == null) {
                    this.errorToken("MIB root string returns null", tok);
                }
                this.rootOIDString = new String[v.size()];
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    this.rootOIDString[i++] = (String)e.nextElement();
                }
                break block12;
            }
            int length = 0;
            boolean changeRoot = false;
            long[] nodeOID = node.getOID();
            length = nodeOID.length >= this.rootOID.length ? this.rootOID.length : nodeOID.length;
            int i = 0;
            while (i < length) {
                if (this.rootOID[i] != nodeOID[i]) {
                    changeRoot = true;
                    length = i;
                    break;
                }
                ++i;
            }
            long[] subnodeOID = new long[length];
            int j = 0;
            while (j < length) {
                subnodeOID[j] = nodeOID[j];
                ++j;
            }
            if (!changeRoot) break block12;
            this.rootOID = subnodeOID;
            this.root = (MibNode)nodeList.get("INIT::=iso");
            int j2 = 1;
            while (j2 < subnodeOID.length) {
                if (this.root == null) {
                    this.errorToken("Bad oid, cannot be the root", tok);
                }
                if (this.root.syntax != null) break;
                Enumeration e = this.root.childList.elements();
                while (e.hasMoreElements()) {
                    this.root = (MibNode)e.nextElement();
                    if (subnodeOID[j2] == this.root.subid) break;
                    this.root = null;
                }
                ++j2;
            }
            if (this.root == null) {
                this.errorToken("Bad oid, cannot be the root", tok);
            }
            int i2 = 0;
            Vector v = this.root.getOIDVector();
            if (v == null) {
                this.errorToken("MIB root string returns null", tok);
            }
            this.rootOIDString = new String[v.size()];
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.rootOIDString[i2++] = (String)e.nextElement();
            }
        }
    }

    public String translateToNames(String oid) {
        Vector<String> vectorOID = new Vector<String>();
        StringTokenizer st = new StringTokenizer(oid, "., \t\n\r");
        while (st.hasMoreTokens()) {
            vectorOID.addElement(st.nextToken());
        }
        MibNode node = this.getNode(vectorOID);
        if (node == null) {
            return null;
        }
        Vector nodeVector = node.getOIDVector();
        StringBuffer s = new StringBuffer();
        Enumeration e = nodeVector.elements();
        while (e.hasMoreElements()) {
            s.append("." + e.nextElement());
        }
        int i = nodeVector.size();
        while (i < vectorOID.size()) {
            s.append("." + vectorOID.elementAt(i));
            ++i;
        }
        return s.toString();
    }

    public String translateToNumbers(String oid) {
        Vector<String> vectorOID = new Vector<String>();
        StringTokenizer st = new StringTokenizer(oid, "., \t\n\r");
        while (st.hasMoreTokens()) {
            vectorOID.addElement(st.nextToken());
        }
        MibNode node = this.getNode(vectorOID);
        if (node == null) {
            return null;
        }
        Vector nodeVector = node.getOIDVectorIds();
        StringBuffer s = new StringBuffer();
        Enumeration e = nodeVector.elements();
        while (e.hasMoreElements()) {
            s.append("." + e.nextElement());
        }
        int i = nodeVector.size();
        while (i < vectorOID.size()) {
            s.append("." + vectorOID.elementAt(i));
            ++i;
        }
        return s.toString();
    }

    public MibNode getNode(String oid) {
        if (oid == null) {
            return null;
        }
        Vector<String> vectorOID = new Vector<String>();
        StringTokenizer st = new StringTokenizer(oid, "., \t\n\r");
        while (st.hasMoreTokens()) {
            vectorOID.addElement(st.nextToken());
        }
        return this.getNode(vectorOID);
    }

    public MibNode getNode(Vector oid) {
        MibNode node = null;
        String last = (String)oid.lastElement();
        if (!Character.isDigit(last.charAt(0))) {
            node = (MibNode)nodeList.get(new String(String.valueOf(this.name) + "::=" + last));
            if (node == null) {
                node = (MibNode)nodeList.get(new String("INIT::=" + last));
            }
            if (node != null) {
                Vector nodeLabels = node.getOIDVector();
                Vector nodeIds = node.getOIDVectorIds();
                int nodeSize = nodeLabels.size();
                int oidSize = oid.size();
                boolean isRightSuperSet = false;
                int i = 1;
                while (i < oidSize + 1) {
                    if (!nodeLabels.elementAt(nodeSize - i).equals(oid.elementAt(oidSize - i)) && !nodeIds.elementAt(nodeSize - i).toString().equals(oid.elementAt(oidSize - i))) {
                        isRightSuperSet = false;
                        break;
                    }
                    isRightSuperSet = true;
                    ++i;
                }
                if (isRightSuperSet) {
                    return node;
                }
            }
            Enumeration e = this.API.modules.elements();
            while (e.hasMoreElements()) {
                node = (MibNode)nodeList.get(new String(String.valueOf(((MibModule)e.nextElement()).name) + "::=" + last));
                if (node == null) {
                    node = (MibNode)nodeList.get(new String("INIT::=" + last));
                }
                if (node == null) continue;
                Vector nodeLabels = node.getOIDVector();
                Vector nodeIds = node.getOIDVectorIds();
                int nodeSize = nodeLabels.size();
                int oidSize = oid.size();
                boolean isRightSuperSet = false;
                int i = 1;
                while (i < oidSize + 1) {
                    if (!nodeLabels.elementAt(nodeSize - i).equals(oid.elementAt(oidSize - i)) && !nodeIds.elementAt(nodeSize - i).toString().equals(oid.elementAt(oidSize - i))) {
                        if (!e.hasMoreElements()) {
                            return null;
                        }
                        isRightSuperSet = false;
                        break;
                    }
                    isRightSuperSet = true;
                    ++i;
                }
                if (!isRightSuperSet) continue;
                return node;
            }
        }
        if (this.root == null) {
            return null;
        }
        int i = 0;
        long[] subids = new long[oid.size()];
        Enumeration e = oid.elements();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            if (Character.isDigit(next.charAt(0))) {
                try {
                    subids[i++] = new Long(next);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid sub-id: " + next);
                    return null;
                }
            }
            subids[i++] = -1L;
        }
        if (oid.size() < this.rootOID.length) {
            return null;
        }
        i = 0;
        while (i < this.rootOID.length) {
            if (subids[i] != this.rootOID[i] && !this.rootOIDString[i].equals((String)oid.elementAt(i))) break;
            ++i;
        }
        if (i < this.rootOID.length) {
            return null;
        }
        MibNode lastNode = this.root;
        node = this.root;
        i = this.rootOID.length;
        while (i < oid.size()) {
            if (node == null) break;
            lastNode = node;
            Enumeration e2 = lastNode.childList.elements();
            while (e2.hasMoreElements()) {
                node = (MibNode)e2.nextElement();
                if (subids[i] == node.subid || node.label.equals((String)oid.elementAt(i))) break;
                node = null;
            }
            ++i;
        }
        if (node == null) {
            if (lastNode.syntax != null) {
                return lastNode;
            }
        } else if (node.getOID().length < oid.size() && node.syntax == null) {
            return null;
        }
        if (node != null) {
            return node;
        }
        return node;
    }

    public MibNode getNode(long[] oid) {
        int i = 0;
        if (oid.length < this.rootOID.length) {
            return null;
        }
        i = 0;
        while (i < this.rootOID.length) {
            if (oid[i] != this.rootOID[i]) break;
            ++i;
        }
        if (i < this.rootOID.length) {
            return null;
        }
        MibNode node = this.root;
        while (i < oid.length) {
            if (node == null) {
                return null;
            }
            if (node.syntax != null) {
                return node;
            }
            Enumeration e = node.childList.elements();
            while (e.hasMoreElements()) {
                node = (MibNode)e.nextElement();
                if (oid[i] == node.subid) break;
                node = null;
            }
            ++i;
        }
        if (node == null) {
            return null;
        }
        if (node.getOID().length < oid.length && node.syntax == null) {
            return null;
        }
        return node;
    }

    public MibNode getNearestNode(long[] oid) {
        int i = 0;
        if (oid.length < this.rootOID.length) {
            return null;
        }
        i = 0;
        while (i < this.rootOID.length) {
            if (oid[i] != this.rootOID[i]) break;
            ++i;
        }
        if (i < this.rootOID.length) {
            return null;
        }
        MibNode node = this.root;
        MibNode lastNode = null;
        while (i < oid.length) {
            lastNode = node;
            if (node.syntax != null) {
                return node;
            }
            Enumeration e = node.childList.elements();
            while (e.hasMoreElements()) {
                node = (MibNode)e.nextElement();
                if (oid[i] == node.subid) break;
                if (e.hasMoreElements()) continue;
                return lastNode;
            }
            ++i;
        }
        return node;
    }

    protected void initSyntaxes() {
        this.syntaxList.put("INTEGER", new LeafSyntax("INTEGER", 2));
        this.syntaxList.put("OCTET STRING", new LeafSyntax("OCTET STRING", 4));
        this.syntaxList.put("OBJECT IDENTIFIER", new LeafSyntax("OBJECT IDENTIFIER", 6));
        this.syntaxList.put("NetworkAddress", new LeafSyntax("IpAddress", 64));
        this.syntaxList.put("IpAddress", new LeafSyntax("IpAddress", 64));
        this.syntaxList.put("Counter", new LeafSyntax("Counter", 65));
        this.syntaxList.put("Gauge", new LeafSyntax("Gauge", 66));
        this.syntaxList.put("TimeTicks", new LeafSyntax("TimeTicks", 67));
        this.syntaxList.put("Opaque", new LeafSyntax("Opaque", 68));
        this.syntaxList.put("Counter32", new LeafSyntax("Counter32", 65));
        this.syntaxList.put("Integer32", new LeafSyntax("Integer32", 2));
        this.syntaxList.put("Gauge32", new LeafSyntax("Gauge32", 66));
        this.syntaxList.put("Unsigned32", new LeafSyntax("Unsigned32", 66));
        this.syntaxList.put("Counter64", new LeafSyntax("Counter64", 70));
        this.syntaxList.put("BITS", new LeafSyntax("BITS", 4));
        this.syntaxList.put("ObjectName", new LeafSyntax("ObjectName", 6));
        this.syntaxList.put("DisplayString", new LeafSyntax("DisplayString", 4));
        this.syntaxList.put("PhysAddress", new LeafSyntax("PhysAddress", 4));
        this.syntaxList.put("TestAndIncr", new LeafSyntax("TestAndIncr", 2));
        this.syntaxList.put("TimeStamp", new LeafSyntax("TimeStamp", 67));
        this.syntaxList.put("ObjectSyntax", new LeafSyntax("ObjectSyntax", 5));
        this.syntaxList.put("RowStatus", new LeafSyntax("RowStatus", 2));
        this.syntaxList.put("MacAddress", new LeafSyntax("MacAddress", 4));
        this.syntaxList.put("DateAndTime", new LeafSyntax("DateAndTime", 4));
        this.syntaxList.put("TimeInterval", new LeafSyntax("TimeInterval", 2));
    }

    protected void initMacros() {
        this.macroList.put("OBJECT-TYPE", new MibMacro("OBJECT-TYPE", null));
        this.macroList.put("TRAP-TYPE", new MibMacro("TRAP-TYPE", null));
        this.macroList.put("MODULE-IDENTITY", new MibMacro("MODULE-IDENTITY", null));
        this.macroList.put("OBJECT-IDENTITY", new MibMacro("OBJECT-IDENTITY", null));
        this.macroList.put("NOTIFICATION-TYPE", new MibMacro("NOTIFICATION-TYPE", null));
        this.macroList.put("MODULE-COMPLIANCE", new MibMacro("MODULE-COMPLIANCE", null));
        this.macroList.put("OBJECT-GROUP", new MibMacro("OBJECT-GROUP", null));
        this.macroList.put("NOTIFICATION-GROUP", new MibMacro("NOTIFICATION-GROUP", null));
        this.macroList.put("TEXTUAL-CONVENTION", new MibMacro("TEXTUAL-CONVENTION", null));
    }

    protected void initNodes() {
        String[] name = new String[]{"ccitt", "iso", "org", "dod", "internet", "directory", "mgmt", "experimental", "private", "snmpV2", "enterprises", "mib-2", "snmpDomains", "snmpProxys", "snmpModules"};
        String[] parent = new String[]{"", "", "iso", "org", "dod", "internet", "internet", "internet", "internet", "internet", "private", "mgmt", "snmpV2", "snmpV2", "snmpV2"};
        long[] lArray = new long[15];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 6L;
        lArray[4] = 1L;
        lArray[5] = 1L;
        lArray[6] = 2L;
        lArray[7] = 3L;
        lArray[8] = 4L;
        lArray[9] = 6L;
        lArray[10] = 1L;
        lArray[11] = 1L;
        lArray[12] = 1L;
        lArray[13] = 2L;
        lArray[14] = 3L;
        long[] num = lArray;
        int i = 0;
        while (i < name.length) {
            MibNode node = new MibNode();
            node.label = name[i];
            node.parent = (MibNode)nodeList.get(new String("INIT::=" + parent[i]));
            if (node.parent != null) {
                node.parent.childList.addElement(node);
            }
            node.subid = num[i];
            String temp = new String("INIT::=" + name[i]);
            nodeList.put(temp, node);
            ++i;
        }
        if (this.root == null) {
            this.root = (MibNode)nodeList.get("INIT::=iso");
            this.rootOID = new long[1];
            this.rootOID[0] = 1L;
            this.rootOIDString = new String[1];
            this.rootOIDString[0] = "iso";
        }
    }

    protected Vector parseOID(StreamTokenizer tok) throws MibException, IOException {
        String currentToken = null;
        Vector<String> toks = new Vector<String>();
        currentToken = this.getToken(tok);
        if (currentToken == null) {
            this.errorToken("OID: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            this.errorToken("OID: Bad parse, expecting { ", tok);
        }
        if ((currentToken = this.getToken(tok)) == null) {
            this.errorToken("OID: Unexpected end of data", tok);
        }
        if (currentToken.indexOf(46) != -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(currentToken);
            while (!currentToken.equals("}")) {
                currentToken = this.getToken(tok);
                if (currentToken == null) {
                    this.errorToken("OID: Unexpected end of data", tok);
                }
                buf.append(currentToken.substring(1));
            }
            StringTokenizer st = new StringTokenizer(buf.toString(), "., \t\n\r");
            while (st.hasMoreTokens()) {
                toks.addElement(st.nextToken());
            }
        } else {
            String id = null;
            while (!currentToken.equals("}")) {
                if (currentToken.equals("(")) {
                    while (!currentToken.equals(")")) {
                        id = currentToken;
                        currentToken = this.getToken(tok);
                        if (currentToken != null) continue;
                        this.errorToken("OID: Unexpected end of data", tok);
                    }
                } else {
                    toks.addElement(currentToken);
                }
                currentToken = this.getToken(tok);
                if (currentToken != null) continue;
                this.errorToken("OID: Unexpected end of data", tok);
            }
            if (!Character.isDigit(((String)toks.lastElement()).charAt(0))) {
                toks.setElementAt(id, toks.size() - 1);
            }
        }
        return toks;
    }

    protected Vector parseSequence(StreamTokenizer tok) throws MibException, IOException {
        String currentToken = null;
        Vector<String> toks = new Vector<String>();
        currentToken = this.getToken(tok);
        if (currentToken == null) {
            this.errorToken("Sequence: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            this.errorToken("Sequence: Bad parse, expecting { ", tok);
        }
        if ((currentToken = this.getToken(tok)) == null) {
            this.errorToken("Sequence: Unexpected end of data", tok);
        }
        while (!currentToken.equals("}")) {
            this.isLabel(currentToken, tok);
            toks.addElement(currentToken);
            Vector stoks = this.parseSyntax(tok);
            if (!((String)stoks.firstElement()).endsWith(",")) {
                currentToken = this.getToken(tok);
                if (currentToken == null) {
                    this.errorToken("Sequence: Unexpected end of data", tok);
                }
                if (currentToken.equals("}")) break;
                if (!currentToken.equals(",")) {
                    this.errorToken("Sequence: Bad parse, expecting , ", tok);
                }
            }
            if ((currentToken = this.getToken(tok)) != null) continue;
            this.errorToken("Sequence: Unexpected end of data", tok);
        }
        return toks;
    }

    protected Vector parseSyntax(StreamTokenizer tok) throws MibException, IOException {
        int braceCount;
        int parenCount;
        Vector<String> toks;
        String currentToken;
        block10: {
            currentToken = null;
            currentToken = this.getToken(tok);
            if (currentToken == null) {
                this.errorToken("SYNTAX: Unexpected end of data", tok);
            }
            toks = new Vector<String>();
            toks.addElement(currentToken);
            parenCount = 0;
            braceCount = 0;
            currentToken = this.getToken(tok);
            try {
                if (currentToken.equals("{")) {
                    ++braceCount;
                    toks.addElement(currentToken);
                    break block10;
                }
                if (currentToken.equals("(")) {
                    ++parenCount;
                    toks.addElement(currentToken);
                    break block10;
                }
                tok.pushBack();
            }
            catch (NullPointerException nullPointerException) {}
        }
        while (parenCount > 0 || braceCount > 0) {
            currentToken = this.getToken(tok);
            if (currentToken == null) {
                this.errorToken("Syntax: Unexpected end of data", tok);
                continue;
            }
            toks.addElement(currentToken);
            if (currentToken.equals("{")) {
                ++braceCount;
                continue;
            }
            if (currentToken.equals("(")) {
                ++parenCount;
                continue;
            }
            if (currentToken.equals(")")) {
                --parenCount;
                continue;
            }
            if (!currentToken.equals("}")) continue;
            --braceCount;
        }
        return toks;
    }

    protected boolean isLabel(String s, StreamTokenizer tok) throws MibException, IOException {
        if (s.equals("DisplayString") || s.equals("PhysAddress")) {
            return true;
        }
        if (s.equals("TestAndIncr") || s.equals("TimeStamp") || s.equals("MacAddress") || s.equals("RowStatus") || s.equals("TimeInterval") || s.equals("DateAndTime")) {
            return true;
        }
        if (this.syntaxList.get(s) != null || this.macroList.get(s) != null) {
            this.errorToken(String.valueOf(s) + " is a reserved word.", tok);
        }
        return true;
    }

    protected void parseImports(Vector imports, String moduleName) throws MibException {
        MibModule module = this;
        MibNode object = null;
        Vector<String> found = new Vector<String>();
        Enumeration e = imports.elements();
        while (e.hasMoreElements()) {
            String nextimport;
            String nam = nextimport = (String)e.nextElement();
            if (nextimport.endsWith(",")) {
                nam = nextimport.substring(0, nextimport.length() - 1);
            }
            Object v = this.syntaxList.get(nam);
            object = (MibNode)v;
            if (v == null) {
                Object v2 = nodeList.get(new String(String.valueOf(moduleName) + "::=" + nam));
                object = (MibNode)v2;
                if (v2 == null) {
                    Object v3 = nodeList.get(new String("INIT::=" + nam));
                    object = (MibNode)v3;
                    if (v3 == null) {
                        Object v4 = this.trapList.get(nam);
                        object = (MibNode)v4;
                        if (v4 == null) {
                            Object v5 = this.macroList.get(nam);
                            object = (MibNode)v5;
                            if (v5 == null) continue;
                        }
                    }
                }
            }
            found.addElement(nextimport);
        }
        Enumeration e2 = found.elements();
        while (e2.hasMoreElements()) {
            imports.removeElement(e2.nextElement());
        }
        if (imports.size() == 0) {
            return;
        }
        module = null;
        Enumeration e3 = this.API.modules.elements();
        while (e3.hasMoreElements()) {
            module = (MibModule)e3.nextElement();
            if (module.name.equals(moduleName)) break;
            module = null;
        }
        if (module == null) {
            try {
                if (this.applet != null) {
                    URL url = new URL(this.applet.getDocumentBase(), String.valueOf(this.mibFileDir) + moduleName);
                    InputStream stream = url.openStream();
                    module = new MibModule(stream, this.API, this.DEBUG, this.applet);
                } else {
                    File compiledMibFile;
                    if (this.API.DEBUG) {
                        System.out.println("Loading import " + this.mibFileDir + moduleName + " from " + this.name);
                    }
                    if ((compiledMibFile = new File(String.valueOf(this.mibFileDir) + moduleName + ".cmi")).exists()) {
                        module = new MibModule(this.API);
                        module.parseCMIBFile(compiledMibFile);
                    } else {
                        module = new MibModule(String.valueOf(this.mibFileDir) + moduleName, this.API, this.DEBUG);
                    }
                }
            }
            catch (FileNotFoundException fe) {
                System.out.println(fe);
                throw new MibException("IMPORTS: Cannot find module: " + moduleName);
            }
            catch (Exception exception) {
                throw new MibException("IMPORTS: module: " + moduleName);
            }
        }
        Enumeration e4 = imports.elements();
        while (e4.hasMoreElements()) {
            String nextimport = (String)e4.nextElement();
            if (nextimport.endsWith(",")) {
                nextimport = nextimport.substring(0, nextimport.length() - 1);
            }
            Object v = module.syntaxList.get(nextimport);
            object = (MibNode)v;
            if (v != null) {
                this.syntaxList.put(nextimport, object);
                continue;
            }
            Object v6 = nodeList.get(String.valueOf(module.name) + "::=" + nextimport);
            object = (MibNode)v6;
            if (v6 != null || (object = this.getNodeInModules(nextimport)) != null || (object = nodeList.get("INIT::=" + nextimport)) != null) continue;
            object = module.trapList.get(nextimport);
            if (object != null) {
                this.trapList.put(nextimport, object);
                continue;
            }
            object = module.macroList.get(nextimport);
            if (object != null) {
                this.macroList.put(nextimport, object);
                continue;
            }
            throw new MibException("IMPORTS: Cannot find " + nextimport + " in " + moduleName);
        }
    }

    protected String getToken(StreamTokenizer tok) throws MibException, IOException {
        String st2;
        String st1 = this.nextToken(tok);
        if (st1 == null) {
            return null;
        }
        if (st1.equals("OBJECT")) {
            st2 = this.nextToken(tok);
            if (st2 == null) {
                return this.errorToken("Unexpected EOF", tok);
            }
            if (st2.startsWith("IDENTIFIER")) {
                return new String(String.valueOf(st1) + " " + st2);
            }
            tok.pushBack();
        }
        if (st1.equals("OCTET")) {
            st2 = this.nextToken(tok);
            if (st2 == null) {
                this.errorToken("Unexpected EOF", tok);
            }
            if (st2.startsWith("STRING")) {
                return new String(String.valueOf(st1) + " " + st2);
            }
            this.errorToken("OCTET cannot be a label.", tok);
        }
        if (st1.equals("SEQUENCE")) {
            st2 = this.nextToken(tok);
            if (st2 == null) {
                this.errorToken("Unexpected EOF", tok);
            }
            if (st2.equals("OF")) {
                return new String(String.valueOf(st1) + " " + st2);
            }
            tok.pushBack();
        }
        if (st1.equals("DEFINITIONS") && this.inModule) {
            this.errorToken("Unexpected start of new MODULE", tok);
        }
        return st1;
    }

    /*
     * Unable to fully structure code
     */
    protected String nextToken(StreamTokenizer tok) throws MibException, IOException {
        while (tok.nextToken() != -1) {
            block12: {
                if (tok.ttype != 34) break block12;
                s = new StringBuffer("\"");
                line = tok.lineno();
                tok.wordChars(32, 32);
                tok.wordChars(9, 9);
                tok.wordChars(46, 46);
                tok.wordChars(45, 45);
                tok.wordChars(48, 57);
                tok.wordChars(40, 40);
                tok.wordChars(41, 41);
                tok.wordChars(44, 44);
                ** GOTO lbl30
                {
                    ++line;
                    s.append('\n');
                    do {
                        if (line < tok.lineno()) continue block1;
                        if (tok.ttype == -3) {
                            s.append(tok.sval);
                        } else if (tok.ttype == -2) {
                            s.append(Long.toString((long)tok.nval));
                        } else {
                            s.append(new Character((char)tok.ttype).toString());
                        }
                        if (tok.ttype == 34) break block1;
lbl30:
                        // 2 sources

                    } while (tok.nextToken() != -1);
                }
                tok.parseNumbers();
                tok.whitespaceChars(0, 32);
                tok.ordinaryChar(46);
                tok.ordinaryChar(40);
                tok.ordinaryChar(41);
                tok.ordinaryChar(44);
                return new String(s);
            }
            if (tok.ttype == 45) {
                line = tok.lineno();
                tok.nextToken();
                if (tok.ttype == 45) {
                    while (tok.nextToken() != -1) {
                        if (tok.lineno() > line) break;
                    }
                }
                tok.pushBack();
                continue;
            }
            if (tok.ttype == -3) {
                return tok.sval;
            }
            if (tok.ttype == -2) {
                return Long.toString((long)tok.nval);
            }
            return new Character((char)tok.ttype).toString();
        }
        return null;
    }

    protected String errorToken(String s, StreamTokenizer tok) throws MibException {
        throw new MibException("Error reading MIB: " + s + "\n" + "File: " + this.filename + " Line: " + tok.lineno());
    }

    public void storeInFile(String f) {
        this.filename = f;
        this.sb.append("\n");
        this.sb.append(this.name);
        this.sb.append("\n");
        this.sb.append("Name  iso");
        this.sb.append("\n");
        this.sb.append("Syntax  null");
        this.sb.append("\n");
        this.sb.append("Parent  null");
        this.sb.append("\n");
        this.sb.append("Subid  1");
        this.sb.append("\n");
        this.doRepeat((MibNode)nodeList.get("INIT::=iso"));
        this.appendRoot();
        try {
            this.ostr.writeBytes(this.sb.toString());
        }
        catch (Exception exception) {}
        try {
            this.ostr.close();
        }
        catch (Exception exception) {
            System.out.println("Not Closed");
        }
    }

    public void appendRoot() {
        MibNode tempRoot = this.root;
        long[] tempRootOID = this.rootOID;
        String[] tempRootOIDString = this.rootOIDString;
        Enumeration e = this.API.modules.elements();
        while (e.hasMoreElements()) {
            MibModule tempModule = (MibModule)e.nextElement();
            if (tempModule.name == this.name) continue;
            int minLength = Math.min(tempRootOID.length, tempModule.rootOID.length);
            int i = 0;
            i = 0;
            while (i < minLength) {
                if (tempRootOID[i] > tempModule.rootOID[i]) {
                    tempRoot = tempModule.root;
                    tempRootOID = tempModule.rootOID;
                    tempRootOIDString = tempModule.rootOIDString;
                    break;
                }
                ++i;
            }
            if (i != minLength || minLength >= tempRootOID.length) continue;
            tempRoot = tempModule.root;
            tempRootOID = tempModule.rootOID;
            tempRootOIDString = tempModule.rootOIDString;
        }
        this.sb.append("Root  " + tempRoot.label);
        this.sb.append("\n");
        this.sb.append("RootOID  ");
        int ind = 0;
        while (ind < tempRootOID.length) {
            this.sb.append(String.valueOf(tempRootOID[ind]) + " ");
            ++ind;
        }
        this.sb.append("\n");
        this.sb.append("RootOIDString  ");
        int ind2 = 0;
        while (ind2 < tempRootOIDString.length) {
            this.sb.append(String.valueOf(tempRootOIDString[ind2]) + " ");
            ++ind2;
        }
        this.sb.append("\n");
    }

    public void doRepeat(MibNode mainnode) {
        File outputFile = new File(this.filename);
        try {
            this.ostr = new DataOutputStream(new FileOutputStream(outputFile));
        }
        catch (Exception exception) {}
        Enumeration e = mainnode.childList.elements();
        while (e.hasMoreElements()) {
            MibNode node = (MibNode)e.nextElement();
            this.sb.append("Name  " + node.toString());
            this.sb.append("\n");
            this.sb.append("Syntax  " + node.syntax);
            this.sb.append("\n");
            this.sb.append("Parent  " + node.parent.toString());
            this.sb.append("\n");
            this.sb.append("Subid  " + node.subid);
            this.sb.append("\n");
            this.doRepeat(node);
        }
    }

    public void parsemyfile(String f) throws MibException, IOException, FileNotFoundException {
        File file = new File(f);
        this.parseCMIBFile(file);
    }

    public void parseCMIBFile(File f) throws MibException, IOException, FileNotFoundException {
        this.fstr = new FileInputStream(f);
        this.fstr = new BufferedInputStream(this.fstr);
        StreamTokenizer tok = new StreamTokenizer(this.fstr);
        String currentToken = "null";
        tok.wordChars(35, 122);
        tok.ordinaryChar(34);
        tok.ordinaryChar(59);
        tok.ordinaryChar(40);
        tok.ordinaryChar(41);
        tok.ordinaryChar(46);
        tok.ordinaryChar(44);
        this.initSyntaxes();
        this.initNodes();
        this.name = currentToken = this.nextToken(tok);
        try {
            this.createnode(tok, currentToken);
        }
        catch (Exception e) {
            System.out.println("Error in Create");
            e.printStackTrace();
        }
    }

    public void createnode(StreamTokenizer tok, String currentToken) throws MibException, IOException {
        String addKeyName = this.name;
        LeafSyntax syntax = null;
        while (currentToken != null) {
            String label;
            MibNode node = new MibNode();
            currentToken = this.nextToken(tok);
            if (currentToken.equals("Root")) break;
            if (!currentToken.equals("Name")) {
                this.errorToken("Bad parse, expected Name", tok);
            }
            node.label = currentToken = this.nextToken(tok);
            currentToken = this.nextToken(tok);
            if (!currentToken.equals("Syntax")) {
                this.errorToken("Bad parse, expected Syntax", tok);
            }
            if ((currentToken = this.nextToken(tok)).equals("null")) {
                label = "null";
                syntax = (LeafSyntax)this.syntaxList.get(currentToken);
                if (syntax != null) {
                    tok.pushBack();
                    syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                }
            }
            if (currentToken.equals("OBJECT")) {
                currentToken = this.nextToken(tok);
                if (!currentToken.equals("IDENTIFIER")) {
                    this.errorToken("IDENTIFIER Expected", tok);
                    label = null;
                } else {
                    label = "OBJECT IDENTIFIER";
                }
                syntax = (LeafSyntax)this.syntaxList.get(label);
                if (syntax != null) {
                    tok.pushBack();
                    syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                }
            }
            if (currentToken.equals("OCTET")) {
                currentToken = this.nextToken(tok);
                if (!currentToken.equals("STRING")) {
                    this.errorToken("STRING Expected", tok);
                    label = null;
                } else {
                    label = "OCTET STRING";
                }
                syntax = (LeafSyntax)this.syntaxList.get(label);
                if (syntax != null) {
                    tok.pushBack();
                    syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                }
            } else {
                label = currentToken;
                syntax = (LeafSyntax)this.syntaxList.get(currentToken);
                if (syntax != null) {
                    tok.pushBack();
                    syntax = new LeafSyntax(label, this.parseSyntax(tok), syntax);
                }
            }
            if (syntax != null) {
                this.syntaxList.put(label, syntax);
            }
            node.syntax = (LeafSyntax)this.syntaxList.get(label);
            currentToken = this.nextToken(tok);
            if (!currentToken.equals("Parent")) {
                this.errorToken("Bad parse, expected Parent", tok);
            }
            currentToken = this.nextToken(tok);
            node.parent = (MibNode)nodeList.get(new String(String.valueOf(this.name) + "::=" + currentToken));
            if (node.parent == null) {
                node.parent = (MibNode)nodeList.get(new String("INIT::=" + currentToken));
            }
            if (node.parent != null) {
                node.parent.childList.addElement(node);
            }
            if (!(currentToken = this.nextToken(tok)).equals("Subid")) {
                this.errorToken("Bad parse, expected Subid", tok);
            }
            currentToken = this.nextToken(tok);
            node.subid = new Long(currentToken);
            String temp = new String(String.valueOf(this.name) + "::=" + node.label);
            nodeList.put(temp, node);
        }
        this.root.label = currentToken = this.nextToken(tok);
        currentToken = this.nextToken(tok);
        if (!currentToken.equals("RootOID")) {
            this.errorToken("Not in the specified format", tok);
        }
        Vector<String> v1 = new Vector<String>();
        Vector<String> v2 = new Vector<String>();
        int i = 0;
        currentToken = this.nextToken(tok);
        while (!currentToken.equals("RootOIDString")) {
            v1.addElement(currentToken);
            currentToken = this.nextToken(tok);
        }
        this.rootOID = new long[v1.size()];
        Enumeration e = v1.elements();
        while (e.hasMoreElements()) {
            this.rootOID[i++] = new Long(e.nextElement().toString());
        }
        currentToken = this.nextToken(tok);
        while (currentToken != null) {
            v2.addElement(currentToken);
            currentToken = this.nextToken(tok);
        }
        i = 0;
        this.rootOIDString = new String[v2.size()];
        e = v2.elements();
        while (e.hasMoreElements()) {
            this.rootOIDString[i++] = (String)e.nextElement();
        }
        this.root = (MibNode)nodeList.get(String.valueOf(this.name) + "::=" + this.root.label);
        if (this.root == null) {
            this.root = (MibNode)nodeList.get("INIT::=" + this.root.label);
        }
        this.inModule = false;
        this.API.modules.addElement(this);
    }

    public String getFileName() {
        return this.filename;
    }

    private MibNode getNodeInModules(String label) {
        Object obj = null;
        Enumeration ae = this.API.modules.elements();
        while (ae.hasMoreElements()) {
            MibModule tempModule = (MibModule)ae.nextElement();
            Object v = nodeList.get(String.valueOf(tempModule.name) + "::=" + label);
            obj = v;
            if (v == null) continue;
            return obj;
        }
        return null;
    }
}

