/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.SnmpException;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;

public class SASClient
implements Serializable {
    public boolean connected = false;
    Socket sock;
    DataInputStream inp;
    DataOutputStream outp;
    String hostname;
    String sasSocketPortDir;
    Applet app;
    int sas_listen_port;
    boolean DEBUG = false;
    static final int SAS_INVALID_TYPE = -1;
    static final int SAS_OPEN = 1;
    static final int SAS_SEND = 2;
    static final int SAS_RECEIVED = 3;
    static final int SAS_CLOSE = 4;
    static final int SAS_SAVE = 5;
    static final int SAS_ERROR = 6;
    static final int SAS_APPEND = 7;
    static final int SAS_DELETE_FILE = 8;
    static final int SAS_CREATE_DIR = 9;
    static final int SAS_DELETE_DIR = 10;
    static final int SAS_CLIENT_CALL = 11;
    static final int SAS_CLIENT_RESPONSE = 12;
    static final int SAS_ALIVE = 13;
    static final int SAS_TRAP_REQUEST = 14;
    static final int SAS_NAME_LOOKUP = 15;
    static final int SAS_ADDRESS_LOOKUP = 16;
    static final int SAS_VALID_TYPES = 25;
    int port;
    int len;
    byte[] data;
    String remoteHost;
    String remoteHostName;
    private String addr;
    private String host;
    boolean gotResponse = true;
    byte[] callData;
    int CALL_TIMEOUT = 60;
    boolean gotUserResponse = false;
    byte[] userRcvData;
    int user_req_type = -1;

    public SASClient(Applet applet, boolean debug) throws SnmpException {
        this.app = applet;
        this.DEBUG = debug;
        this.hostname = applet.getCodeBase().getHost();
        if (this.hostname.equals("")) {
            this.hostname = "localhost";
        }
        this.sasSocketPortDir = applet.getParameter("SAS_PORT_DIR");
        this.sasSocketPortDir = this.sasSocketPortDir == null ? "./" : String.valueOf(this.sasSocketPortDir) + "/";
        this.connectToHost(applet);
    }

    private void connectToHost(Applet applet) throws SnmpException {
        int port = 0;
        try {
            URL url = new URL(applet.getDocumentBase(), String.valueOf(this.sasSocketPortDir) + "SASocketPort");
            DataInputStream stream = new DataInputStream(url.openStream());
            String portstring = stream.readUTF();
            port = Integer.parseInt(portstring);
            InetAddress addr = InetAddress.getByName(this.hostname);
            this.sock = new Socket(addr, port);
            this.outp = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.inp = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        }
        catch (Exception e) {
            if (port != 0) {
                System.err.println("Failed to connect: " + this.hostname + ":" + port + " - " + e);
            }
            throw new SnmpException("Error: Connecting to Applet Host : " + e);
        }
        this.connected = true;
    }

    private void open(Applet applet, boolean debug, int local_port) throws SnmpException {
        this.connectToHost(applet);
        System.out.println("Connected to SASserver again");
        try {
            this.outp.writeInt(1);
            this.outp.writeInt(local_port);
            this.outp.flush();
        }
        catch (IOException iOException) {
            System.err.println("Error opening socket at applet host.");
        }
    }

    void open(int local_port) {
        this.sas_listen_port = local_port;
        try {
            this.outp.writeInt(1);
            this.outp.writeInt(local_port);
            this.outp.flush();
        }
        catch (IOException iOException) {
            System.err.println("Error opening socket at applet host.");
        }
    }

    public synchronized void reqTraps(int port) throws IOException {
        this.outp.writeInt(14);
        this.outp.writeInt(port);
        this.outp.flush();
    }

    public synchronized void send(String hostname, int port, byte[] data) throws IOException {
        this.outp.writeInt(2);
        this.outp.writeUTF(hostname);
        this.outp.writeInt(port);
        int len = data.length;
        this.outp.writeInt(len);
        this.outp.write(data, 0, len);
        this.outp.flush();
    }

    public void saveFile(String filename, byte[] data) throws IOException {
        this.outp.writeInt(5);
        this.outp.writeUTF(filename);
        int len = data.length;
        this.outp.writeInt(len);
        this.outp.write(data, 0, len);
        this.outp.flush();
    }

    public synchronized String getHostName(String address, int timeout) throws IOException {
        String hostname;
        if (address == null) {
            return null;
        }
        if (timeout == 0) {
            timeout = 2000;
        }
        long start = System.currentTimeMillis();
        this.outp.writeInt(16);
        this.outp.writeUTF(address);
        this.addr = address;
        this.outp.flush();
        while (this.host == null) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            long now = System.currentTimeMillis();
            if (now - start <= (long)timeout) continue;
            this.addr = null;
            this.host = null;
            return null;
        }
        String string = this.addr;
        synchronized (string) {
            hostname = this.host;
            this.addr = null;
            this.host = null;
        }
        if (hostname.equals("NULL")) {
            return null;
        }
        return hostname;
    }

    public synchronized String getHostAddress(String hostname, int timeout) throws IOException {
        String addrname;
        if (timeout == 0) {
            timeout = 2000;
        }
        if (hostname == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        this.host = hostname;
        this.outp.writeInt(15);
        this.outp.writeUTF(hostname);
        this.outp.flush();
        while (this.addr == null) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            long now = System.currentTimeMillis();
            if (now - start <= (long)timeout) continue;
            this.addr = null;
            this.host = null;
            return null;
        }
        String string = this.host;
        synchronized (string) {
            addrname = this.addr;
            this.host = null;
            this.addr = null;
        }
        if (addrname.equals("NULL")) {
            return null;
        }
        return addrname;
    }

    public void appendFile(String filename, byte[] data) throws IOException {
        this.outp.writeInt(7);
        this.outp.writeUTF(filename);
        int len = data.length;
        this.outp.writeInt(len);
        this.outp.write(data, 0, len);
        this.outp.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive() throws SnmpException, IOException {
        int type = -1;
        try {
            block7: while (true) {
                if ((type = this.inp.readInt()) == 13) {
                    continue;
                }
                if (type == 12) {
                    int len2 = this.inp.readInt();
                    this.callData = new byte[len2];
                    this.inp.readFully(this.callData, 0, len2);
                    this.gotResponse = true;
                    continue;
                }
                if (type == this.user_req_type) {
                    int len = this.inp.readInt();
                    this.userRcvData = new byte[len];
                    this.inp.readFully(this.userRcvData, 0, len);
                    this.gotUserResponse = true;
                    this.user_req_type = -1;
                    continue;
                }
                switch (type) {
                    case 16: {
                        if (this.addr == null) {
                            String dummyStr = this.inp.readUTF();
                            dummyStr = this.inp.readUTF();
                            this.addr = null;
                            this.host = null;
                            continue block7;
                        }
                        this.addr = this.inp.readUTF();
                        this.host = this.inp.readUTF();
                        continue block7;
                    }
                    case 15: {
                        if (this.host == null) {
                            String dummyStr = this.inp.readUTF();
                            dummyStr = this.inp.readUTF();
                            this.addr = null;
                            this.host = null;
                            continue block7;
                        }
                        this.host = this.inp.readUTF();
                        this.addr = this.inp.readUTF();
                        continue block7;
                    }
                    case 3: {
                        this.remoteHost = this.inp.readUTF();
                        this.port = this.inp.readInt();
                        this.len = this.inp.readInt();
                        this.data = new byte[this.len];
                        this.inp.readFully(this.data, 0, this.len);
                        return;
                    }
                }
                break;
            }
            throw new SnmpException("Receive error");
        }
        catch (IOException ie) {
            System.err.println("Error communicating with SAS Server. ");
            throw new IOException("Receive Error " + ie.getMessage());
        }
    }

    public void close() {
        try {
            this.outp.writeInt(4);
            this.outp.flush();
        }
        catch (IOException iOException) {}
    }

    public synchronized byte[] clientCall(byte[] bytes) {
        this.gotResponse = false;
        this.callData = null;
        try {
            this.outp.writeInt(11);
            int len = bytes.length;
            this.outp.writeInt(len);
            this.outp.write(bytes, 0, len);
            this.outp.flush();
        }
        catch (IOException e) {
            System.err.println("IO error: " + e);
            return null;
        }
        int i = 0;
        while (!this.gotResponse) {
            try {
                Thread.sleep(50L);
                if (i++ <= this.CALL_TIMEOUT * 20) continue;
                System.err.println("Client Call Timeout.");
                return null;
            }
            catch (Exception exception) {}
        }
        return this.callData;
    }

    public synchronized byte[] userSyncSend(int userType, byte[] bytes) {
        if (this.isKnownSASType(userType)) {
            System.err.println("User should use unknown SAS type( 26 onwards ) as userType ");
            return null;
        }
        this.gotUserResponse = false;
        this.userRcvData = null;
        this.user_req_type = userType;
        try {
            this.outp.writeInt(userType);
            int len = bytes.length;
            this.outp.writeInt(len);
            this.outp.write(bytes, 0, len);
            this.outp.flush();
        }
        catch (IOException e) {
            System.err.println("IO error: " + e);
            return null;
        }
        int i = 0;
        while (!this.gotUserResponse) {
            try {
                Thread.sleep(50L);
                if (i++ <= this.CALL_TIMEOUT * 20) continue;
                System.err.println("Client Call Timeout.");
                return null;
            }
            catch (Exception exception) {}
        }
        this.user_req_type = -1;
        return this.userRcvData;
    }

    public boolean isKnownSASType(int type) {
        return type <= 25;
    }

    public void createDir(String directory) throws IOException {
        this.outp.writeInt(9);
        this.outp.writeUTF(directory);
        this.outp.flush();
    }

    public void deleteFile(String filename) throws IOException {
        this.outp.writeInt(8);
        this.outp.writeUTF(filename);
        this.outp.flush();
    }

    public void deleteDir(String directory) throws IOException {
        this.outp.writeInt(10);
        this.outp.writeUTF(directory);
        this.outp.flush();
    }
}

