/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.SnmpClient;
import Snmp2.SnmpPDU;
import Snmp2.SnmpSession;
import com.novell.net.IpxDatagramPacket;
import java.net.DatagramPacket;
import java.util.Vector;

class SnmpCallback
extends Thread {
    Vector responses = new Vector();
    Vector packets = new Vector(10000);
    int protocol = 0;

    public SnmpCallback() {
    }

    public SnmpCallback(int proto) {
        this.protocol = proto;
    }

    synchronized void enQ(SnmpClient client, SnmpSession session, SnmpPDU pdu, int reqid) {
        CallbackArgs callargs = pdu != null ? new CallbackArgs(client, session, pdu, reqid) : new CallbackArgs(client, session, null, reqid);
        this.responses.addElement(callargs);
        this.notifyAll();
    }

    synchronized void enQ(DatagramPacket packet, SnmpSession session, SnmpPDU pdu) {
        PacketArgs pacArgs = new PacketArgs(packet, session, pdu);
        if (this.packets.size() >= 10000) {
            return;
        }
        this.packets.addElement(pacArgs);
        if (this.packets.size() == 1) {
            this.notifyAll();
        }
    }

    synchronized void enQ(IpxDatagramPacket packet, SnmpSession session, SnmpPDU pdu) {
        IpxPacketArgs pacArgs = new IpxPacketArgs(packet, session, pdu);
        if (this.packets.size() >= 10000) {
            return;
        }
        this.packets.addElement(pacArgs);
        if (this.packets.size() == 1) {
            this.notifyAll();
        }
    }

    public void run() {
        while (true) {
            Object pacArgs;
            if (this.protocol == 1) {
                pacArgs = this.getIpxPDU();
                this.processPacket(((IpxPacketArgs)pacArgs).packet, ((IpxPacketArgs)pacArgs).session, ((IpxPacketArgs)pacArgs).pdu);
                continue;
            }
            if (this.protocol != 0) continue;
            pacArgs = this.getPDU();
            this.processPacket(((PacketArgs)pacArgs).packet, ((PacketArgs)pacArgs).session, ((PacketArgs)pacArgs).pdu);
        }
    }

    synchronized PacketArgs getPDU() {
        try {
            while (this.packets.size() <= 0) {
                this.wait();
            }
            PacketArgs pac = (PacketArgs)this.packets.firstElement();
            this.packets.removeElementAt(0);
            return pac;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    synchronized IpxPacketArgs getIpxPDU() {
        try {
            while (this.packets.size() <= 0) {
                this.wait();
            }
            IpxPacketArgs pac = (IpxPacketArgs)this.packets.firstElement();
            this.packets.removeElementAt(0);
            return pac;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    void processPacket(DatagramPacket packet, SnmpSession session, SnmpPDU pdu) {
        session.processPacket(packet, pdu);
    }

    void processPacket(IpxDatagramPacket packet, SnmpSession session, SnmpPDU pdu) {
        session.processPacket(packet, pdu);
    }

    class CallbackArgs {
        SnmpClient client;
        SnmpSession session;
        SnmpPDU pdu;
        int reqid;

        public CallbackArgs(SnmpClient cli, SnmpSession sess, SnmpPDU pd, int req) {
            SnmpCallback.this = SnmpCallback.this;
            this.client = cli;
            this.session = sess;
            this.pdu = pd;
            this.reqid = req;
        }
    }

    class PacketArgs {
        DatagramPacket packet;
        SnmpSession session;
        SnmpPDU pdu;

        public PacketArgs(DatagramPacket pac, SnmpSession sess, SnmpPDU pd) {
            SnmpCallback.this = SnmpCallback.this;
            this.packet = pac;
            this.session = sess;
            this.pdu = pd;
        }
    }

    class IpxPacketArgs {
        IpxDatagramPacket packet;
        SnmpSession session;
        SnmpPDU pdu;

        public IpxPacketArgs(IpxDatagramPacket pac, SnmpSession sess, SnmpPDU pd) {
            SnmpCallback.this = SnmpCallback.this;
            this.packet = pac;
            this.session = sess;
            this.pdu = pd;
        }
    }
}

