/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpUnsignedInt;

public class SnmpCounter
extends SnmpUnsignedInt {
    public SnmpCounter(long s) {
        super(s);
        this.Type = (byte)65;
    }

    public String toTagString() {
        return "Counter: " + Long.toString(this.value);
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeUInt(buff, space, (int)this.value, 65);
    }

    public long getIncrement(SnmpCounter c) {
        return this.getIncrement(c.longValue());
    }

    public long getIncrement(long lastValue) {
        long valueNow = this.longValue();
        long diff = valueNow - lastValue;
        if (diff < 0L) {
            diff = valueNow + 0xFFFFFFFFL - lastValue;
        }
        return diff;
    }
}

