/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpVar;

public class SnmpCounter64
extends SnmpVar {
    protected long[] value = new long[2];
    protected byte[] byteValue;

    SnmpCounter64(long val) {
        this.value[0] = val;
        this.value[1] = val < 0L ? -1L : 0L;
        this.Type = (byte)70;
    }

    public SnmpCounter64(long[] val) {
        if (val != null) {
            this.value[0] = val[0];
            this.value[1] = val[1];
        }
        this.Type = (byte)70;
    }

    public Object toValue() {
        long[] val = new long[]{this.value[0], this.value[1]};
        return val;
    }

    public String toString() {
        return "0x" + Long.toString(this.value[1], 16) + Long.toString(this.value[0], 16);
    }

    public String toTagString() {
        return "COUNTER64: " + this.toString();
    }

    public long diff(SnmpCounter64 val) {
        long MAX = Long.MAX_VALUE;
        long lvalue = this.value[1] << 32 | this.value[0];
        long lval = val.value[1] << 32 | val.value[0];
        if (lvalue >= 0L && lval >= 0L) {
            return lvalue - lval;
        }
        if (lvalue < 0L && lval < 0L) {
            return lval - lvalue;
        }
        if (lvalue < 0L) {
            if (lval <= (lvalue & MAX)) {
                return Long.MIN_VALUE;
            }
            return MAX - lval + (lvalue & MAX) + 1L;
        }
        if (lval < 0L && lvalue > (lval & MAX)) {
            return lvalue - (lval & MAX) - MAX - 1L;
        }
        return Long.MIN_VALUE;
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            this.byteValue = new byte[8];
            long v = this.value[0];
            int i = this.byteValue.length;
            while (v != 0L) {
                this.byteValue[--i] = (byte)(v & 0xFFL);
                v >>>= 8;
            }
        }
        return this.byteValue;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeUInt(buff, space, this.value[0], 70);
    }
}

