/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.MibModule;
import Snmp2.MibNode;
import Snmp2.SnmpAPI;
import Snmp2.SnmpVar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SnmpOID
extends SnmpVar {
    protected int[] value;
    protected byte[] byteValue;
    protected SnmpAPI API;
    private static int[] zeroDotZero = new int[2];
    public MibNode node;
    private static boolean lookupNode = true;

    static SnmpOID newInstance(int[] oid, SnmpAPI api) {
        SnmpOID snmpOID = new SnmpOID();
        snmpOID.Type = (byte)6;
        snmpOID.value = oid;
        snmpOID.API = api;
        return snmpOID;
    }

    static SnmpOID newInstance(int[] oid) {
        return SnmpOID.newInstance(oid, null);
    }

    protected SnmpOID() {
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        int[] oid = this.value == null ? zeroDotZero : this.value;
        return ASNTypes.encodeOid(buff, space, oid, oid.length, 6);
    }

    public SnmpOID(String s) {
        this.Type = (byte)6;
        if (s == null) {
            return;
        }
        this.setOID(s);
    }

    public SnmpOID(int[] oid) {
        this.Type = (byte)6;
        this.value = new int[oid.length];
        System.arraycopy(oid, 0, this.value, 0, oid.length);
    }

    public SnmpOID(String s, SnmpAPI api) {
        this.Type = (byte)6;
        if (s == null) {
            return;
        }
        Vector oidVector = new Vector();
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens()) {
            oidVector.addElement(st.nextToken());
        }
        if (!Character.isDigit(((String)oidVector.firstElement()).charAt(0))) {
            String label = (String)oidVector.firstElement();
            Enumeration e = api.modules.elements();
            while (e.hasMoreElements()) {
                MibModule tempModule = (MibModule)e.nextElement();
                this.node = (MibNode)MibModule.nodeList.get(String.valueOf(tempModule.name) + "::=" + label);
                if (this.node == null) {
                    this.node = (MibNode)MibModule.nodeList.get("INIT::=" + label);
                }
                if (this.node != null) break;
            }
            if (this.node != null) {
                if (this.node.syntax == null && oidVector.size() > 1) {
                    this.node = null;
                } else {
                    Vector v = this.node.getOIDVector();
                    int j = 1;
                    while (j < oidVector.size()) {
                        v.addElement((String)oidVector.elementAt(j));
                        ++j;
                    }
                    oidVector = v;
                }
            }
        }
        if (this.node == null) {
            oidVector = this.toVector(s);
            Enumeration e = api.modules.elements();
            while (e.hasMoreElements()) {
                this.node = ((MibModule)e.nextElement()).getNode(oidVector);
                if (this.node == null) continue;
                int length = this.node.getOID().length;
                if (length >= oidVector.size()) break;
                try {
                    if (Character.isDigit(((String)oidVector.elementAt(length)).charAt(0))) break;
                    this.node = null;
                }
                catch (Exception ex) {
                    System.out.println("Exception:" + ex);
                }
            }
        }
        if (this.node == null) {
            this.setOID(s);
        } else {
            long[] nodeoid = this.node.getOID();
            this.value = new int[oidVector.size()];
            int i = 0;
            while (i < nodeoid.length) {
                this.value[i] = (int)nodeoid[i];
                ++i;
            }
            int i2 = nodeoid.length;
            while (i2 < this.value.length) {
                try {
                    this.value[i2] = (int)new Long((String)oidVector.elementAt(i2)).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid OID format: " + s);
                    this.value = null;
                    return;
                }
                ++i2;
            }
        }
    }

    public SnmpOID(String s, MibModule module) {
        this.Type = (byte)6;
        if (s == null) {
            return;
        }
        Vector oidVector = new Vector();
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens()) {
            oidVector.addElement(st.nextToken());
        }
        if (!Character.isDigit(((String)oidVector.firstElement()).charAt(0))) {
            String label = (String)oidVector.firstElement();
            this.node = (MibNode)MibModule.nodeList.get(String.valueOf(module.name) + "::=" + label);
            if (this.node == null) {
                this.node = (MibNode)MibModule.nodeList.get("INIT::=" + label);
            }
            if (this.node != null) {
                if (this.node.syntax == null && oidVector.size() > 1) {
                    this.node = null;
                } else {
                    Vector v = this.node.getOIDVector();
                    int j = 1;
                    while (j < oidVector.size()) {
                        v.addElement((String)oidVector.elementAt(j));
                        ++j;
                    }
                    oidVector = v;
                }
            }
        }
        if (this.node == null) {
            oidVector = this.toVector(s);
            this.node = module.getNode(oidVector);
        }
        if (this.node == null) {
            this.setOID(s);
        } else {
            long[] nodeoid = this.node.getOID();
            this.value = new int[oidVector.size()];
            int i = 0;
            while (i < nodeoid.length) {
                this.value[i] = (int)nodeoid[i];
                ++i;
            }
            int i2 = nodeoid.length;
            while (i2 < this.value.length) {
                try {
                    this.value[i2] = (int)new Long((String)oidVector.elementAt(i2)).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid OID format: " + s);
                    this.value = null;
                    return;
                }
                ++i2;
            }
        }
    }

    public MibNode getNode(SnmpAPI api) {
        MibNode lastModuleNode = null;
        int lastModuleNodeLength = 0;
        long[] oid = this.convertIntArrayToLongArray(this.value);
        Enumeration e = api.modules.elements();
        while (e.hasMoreElements()) {
            this.node = ((MibModule)e.nextElement()).getNode(oid);
            if (this.node == null || this.node == null) continue;
            int length = this.node.getOID().length;
            if (length < oid.length) {
                if (this.node.syntax == null) {
                    if (length > lastModuleNodeLength) {
                        lastModuleNode = this.node;
                        lastModuleNodeLength = length;
                    }
                    this.node = null;
                    continue;
                }
                lastModuleNode = this.node;
                break;
            }
            lastModuleNode = this.node;
            break;
        }
        this.node = lastModuleNode;
        return lastModuleNode;
    }

    public MibNode getNode(MibModule module) {
        long[] oid = this.convertIntArrayToLongArray(this.value);
        this.node = module.getNode(oid);
        return this.node;
    }

    public MibNode getNearestNode(SnmpAPI api) {
        MibNode lastModuleNode = null;
        int lastModuleNodeLength = 0;
        MibNode node = null;
        long[] oid = this.convertIntArrayToLongArray(this.value);
        Enumeration e = api.modules.elements();
        while (e.hasMoreElements()) {
            node = ((MibModule)e.nextElement()).getNearestNode(oid);
            if (node == null || node == null) continue;
            int length = node.getOID().length;
            if (length < oid.length) {
                if (node.syntax == null) {
                    if (length > lastModuleNodeLength) {
                        lastModuleNode = node;
                        lastModuleNodeLength = length;
                    }
                    node = null;
                    continue;
                }
                lastModuleNode = node;
                break;
            }
            lastModuleNode = node;
            break;
        }
        node = lastModuleNode;
        return lastModuleNode;
    }

    public Object toValue() {
        if (this.value == null) {
            return null;
        }
        return this.convertIntArrayToLongArray(this.value);
    }

    public int[] toIntArray() {
        if (this.value == null) {
            return null;
        }
        int[] oid = new int[this.value.length];
        System.arraycopy(this.value, 0, oid, 0, this.value.length);
        return oid;
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            int n = this.value.length;
            this.byteValue = new byte[4 * n];
            int i = 0;
            while (i < n) {
                int v = this.value[i];
                int j = (i + 1) * 4;
                while (v != 0) {
                    this.byteValue[--j] = (byte)(v & 0xFF);
                    v >>>= 8;
                }
                ++i;
            }
        }
        return this.byteValue;
    }

    public String nodeLabel() {
        if (this.node != null) {
            return this.node.label;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (lookupNode && this.API != null) {
            this.node = this.getNode(this.API);
        }
        if (this.node == null) {
            int i = 0;
            while (i < this.value.length) {
                s.append("." + Long.toString((long)this.value[i] & 0xFFFFFFFFL));
                ++i;
            }
        } else {
            s.append(this.node.getOIDString());
            int i = this.node.getOID().length;
            while (i < this.value.length) {
                s.append("." + Long.toString((long)this.value[i] & 0xFFFFFFFFL));
                ++i;
            }
        }
        return s.toString();
    }

    public String toTagString() {
        return "Object ID: " + this.toString();
    }

    public String toShortString() {
        String s = this.toString();
        if (this.node == null) {
            return s;
        }
        return s.substring(s.indexOf(this.nodeLabel()));
    }

    private void setOID(String s) {
        try {
            if (s.charAt(0) != '.') {
                s = String.valueOf(SnmpAPI.Standard_Prefix) + s;
            }
            char[] c = s.toCharArray();
            int f = 0;
            int l = c.length;
            if (c[f] == '.') {
                ++f;
            }
            if (c[l - 1] == '.') {
                --l;
            }
            int len = 1;
            int i = f;
            while (i < l) {
                if (c[i] == '.') {
                    ++len;
                }
                ++i;
            }
            this.value = new int[len];
            int j = 0;
            int subId = 0;
            int d = 0;
            int i2 = f;
            while (i2 < l) {
                if (c[i2] == '.') {
                    this.value[j++] = subId;
                    subId = 0;
                } else {
                    d = Character.digit(c[i2], 10);
                    if (d >= 0) {
                        subId = subId * 10 + d;
                    } else {
                        throw new Exception();
                    }
                }
                ++i2;
            }
            this.value[j] = subId;
        }
        catch (Exception exception) {
            System.err.println("Invalid OID format: " + s);
            this.value = null;
        }
    }

    Vector toVector(String s) {
        Vector<String> v = new Vector<String>();
        if (s.charAt(0) != '.') {
            s = String.valueOf(SnmpAPI.Standard_Prefix) + s;
        }
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return v;
    }

    long[] convertIntArrayToLongArray(int[] intArray) {
        long[] longArray = new long[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            longArray[i] = (long)intArray[i] & 0xFFFFFFFFL;
            ++i;
        }
        return longArray;
    }

    public static void setNodeLookup(boolean lookup) {
        lookupNode = lookup;
    }

    public static boolean getNodeLookup() {
        return lookupNode;
    }
}

