/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpVar;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class SnmpString
extends SnmpVar {
    protected static final byte[] s_emptyString = new byte[0];
    protected String value;
    protected byte[] byteValue = s_emptyString;
    protected String enc;

    static SnmpVar newInstance(byte[] b) {
        SnmpString v = new SnmpString();
        v.Type = (byte)4;
        v.byteValue = b;
        return v;
    }

    protected SnmpString() {
    }

    public SnmpString(String s) {
        this(s, null);
    }

    public SnmpString(String s, String enc) {
        if (enc != null) {
            this.enc = enc;
        }
        this.Type = (byte)4;
        if (s == null) {
            return;
        }
        if (s.startsWith("'") && s.endsWith("'") && s.indexOf(":") != -1) {
            try {
                String tempS = s.substring(1, s.length() - 1);
                StringTokenizer toks = new StringTokenizer(tempS, ":");
                byte[] a = new byte[toks.countTokens()];
                int i = 0;
                while (toks.hasMoreTokens()) {
                    tempS = toks.nextToken();
                    if (tempS.length() > 2) {
                        throw new Exception();
                    }
                    a[i] = (byte)Integer.parseInt(tempS, 16);
                    ++i;
                }
                this.byteValue = a;
                this.value = new String(a, 0);
                return;
            }
            catch (Exception exception) {}
        }
        this.value = s;
        int n = this.value.length();
        this.byteValue = new byte[n];
        if (enc == null) {
            this.value.getBytes(0, n, this.byteValue, 0);
        } else {
            try {
                this.byteValue = this.value.getBytes(enc);
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println("Encoding Not Supported " + uee.getMessage() + " " + enc);
                this.byteValue = new byte[n];
                this.value.getBytes(0, n, this.byteValue, 0);
            }
        }
    }

    public SnmpString(byte[] b) {
        this.Type = (byte)4;
        if (b == null) {
            return;
        }
        this.byteValue = new byte[b.length];
        System.arraycopy(b, 0, this.byteValue, 0, b.length);
    }

    public Object toValue() {
        return this.toString();
    }

    public String toString() {
        if (this.value == null) {
            this.value = new String(this.byteValue, 0);
        }
        return this.value;
    }

    public String toTagString() {
        return "STRING: " + this.toString();
    }

    public String toByteString() {
        StringBuffer sb = new StringBuffer(this.byteValue.length * 3);
        int i = 0;
        while (i < this.byteValue.length) {
            sb.append(String.valueOf(Integer.toString(this.byteValue[i] & 0xFF, 16)) + " ");
            ++i;
        }
        return sb.toString();
    }

    public byte[] toBytes() {
        byte[] b = new byte[this.byteValue.length];
        System.arraycopy(this.byteValue, 0, b, 0, this.byteValue.length);
        return b;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeOctets(buff, space, this.byteValue, 0, this.byteValue.length, 4);
    }
}

