/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpUnsignedInt;

public class SnmpTimeticks
extends SnmpUnsignedInt {
    public SnmpTimeticks(long s) {
        super(s);
        this.Type = (byte)67;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        long timeticks = this.value;
        int days = (int)((timeticks /= 100L) / 86400L);
        int hours = (int)((timeticks %= 86400L) / 3600L);
        int minutes = (int)((timeticks %= 3600L) / 60L);
        int seconds = (int)(timeticks % 60L);
        if (days == 1) {
            s.append("1 day, ");
        } else if (days != 0) {
            s.append(String.valueOf(days) + " days, ");
        }
        s.append(String.valueOf(hours) + " hours, ");
        s.append(String.valueOf(minutes) + " minutes, ");
        s.append(String.valueOf(seconds) + " seconds. ");
        return s.toString();
    }

    public String toShortString() {
        StringBuffer s = new StringBuffer();
        long timeticks = this.value;
        int days = (int)((timeticks /= 100L) / 86400L);
        int hours = (int)((timeticks %= 86400L) / 3600L);
        int minutes = (int)((timeticks %= 3600L) / 60L);
        int seconds = (int)(timeticks % 60L);
        if (days == 1) {
            s.append("1d ");
        } else if (days != 0) {
            s.append(String.valueOf(days) + "d ");
        }
        s.append(String.valueOf(this.fmt(hours)) + ":");
        s.append(String.valueOf(this.fmt(minutes)) + ":");
        s.append(this.fmt(seconds));
        return s.toString();
    }

    public String toTagString() {
        return "TimeTicks: " + this.toString();
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeUInt(buff, space, (int)this.value, 67);
    }

    String fmt(int i) {
        String s = String.valueOf(i);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }
}

