/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpVar;

public class SnmpUnsignedInt
extends SnmpVar {
    protected long value;
    protected byte[] byteValue;

    public SnmpUnsignedInt(long val) {
        this.value = val;
        this.Type = (byte)66;
    }

    public Object toValue() {
        return new Long(this.value);
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public String toTagString() {
        return "UNSIGNED: " + Long.toString(this.value);
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            this.byteValue = new byte[4];
            int v = (int)this.value;
            int i = this.byteValue.length;
            while (v != 0) {
                this.byteValue[--i] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return this.byteValue;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeUInt(buff, space, (int)this.value, 66);
    }
}

