/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.exceptions;

import com.novell.admin.common.exceptions.MessageLinkResourceBundle;
import com.novell.admin.common.exceptions.SPIException;
import java.util.MissingResourceException;

public final class SimpleSPIException
extends SPIException {
    private String errorId = null;
    private Exception ex = null;
    private String xtraMsg = null;

    private SimpleSPIException(MessageLinkResourceBundle bundle, String errorCode, boolean reportFlag, String xtraMsg) {
        super(bundle, reportFlag);
        this.errorId = errorCode;
        this.xtraMsg = xtraMsg;
        this.setHelpID(errorCode);
        this.setHelpID(errorCode);
    }

    private SimpleSPIException(MessageLinkResourceBundle bundle, Exception e) {
        super(bundle, true);
        this.setHelpSetName(null);
        this.ex = e;
    }

    public SimpleSPIException(String bundleName) {
        super(bundleName);
        this.setHelpSetName(null);
    }

    public String getErrorId() {
        return this.errorId;
    }

    public SPIException newException(String error) {
        return new SimpleSPIException(this.bundle, error, true, null);
    }

    public SPIException newException(String error, String xtraMsg) {
        return new SimpleSPIException(this.bundle, error, true, xtraMsg);
    }

    public SPIException newException(String error, boolean reportFlag) {
        return new SimpleSPIException(this.bundle, error, reportFlag, null);
    }

    public SPIException newException(Exception e) {
        return new SimpleSPIException(this.bundle, e);
    }

    public String getLocalizedMessage() {
        if (this.ex != null) {
            String msg = this.ex.getLocalizedMessage();
            if (msg != null && msg.length() != 0) {
                return msg;
            }
            if (this.errorId != null) {
                return this.bundle.getUnknownErrorMessage(this.errorId);
            }
            return this.ex.toString();
        }
        try {
            String retMsg = this.bundle.getLocalizedMessage(this.errorId);
            if (this.xtraMsg != null) {
                retMsg = retMsg + "\n\n" + this.xtraMsg;
            }
            return retMsg;
        }
        catch (MissingResourceException e) {
            return this.bundle.getUnknownErrorMessage(this.errorId);
        }
    }
}

