/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.exceptions;

import com.novell.admin.common.exceptions.MessageLinkResourceBundle;
import com.novell.admin.common.exceptions.SPIException;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public class UniqueSPIException
extends SPIException {
    public static final String ERR_CODE = "(Error {0}) ";
    int errorCode = 0;
    String className = null;
    String funcName = null;
    String crackedError;

    public UniqueSPIException(String bundleName) {
        super(bundleName);
    }

    protected UniqueSPIException(MessageLinkResourceBundle bundle, int errorCode, String className, String funcName, Throwable throwable) {
        super(bundle, true);
        this.errorCode = errorCode;
        this.className = className;
        this.funcName = funcName;
        this.crackedError = this.crackErrorCode();
        this.setHelpID(bundle.getHelpId(this.crackedError + funcName));
        if (this.getHelpID() == null) {
            this.setHelpID(bundle.getHelpId(this.crackedError));
        }
        this.setCause(throwable);
    }

    public SPIException newException(int errorCode, String funcName) {
        return new UniqueSPIException(this.bundle, errorCode, "", funcName, null);
    }

    public SPIException newException(int errorCode, String funcName, Throwable throwable) {
        return new UniqueSPIException(this.bundle, errorCode, "", funcName, throwable);
    }

    public SPIException newException(int errorCode, String className, String funcName, Throwable throwable) {
        return new UniqueSPIException(this.bundle, errorCode, className, funcName, throwable);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public String getLocalizedMessage() {
        String message = "";
        String err = "";
        err = MessageFormat.format(ERR_CODE, this.crackedError);
        try {
            message = err + this.bundle.getLocalizedMessage(this.crackedError + this.getFunctionName());
        }
        catch (MissingResourceException exception1) {
            try {
                message = err + this.bundle.getLocalizedMessage(this.crackedError);
            }
            catch (MissingResourceException exception2) {
                message = this.bundle.getUnknownErrorMessage(this.crackedError);
            }
        }
        return message;
    }
}

