/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.util;

import com.novell.admin.common.util.EndianInput;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class EndianInputStream
extends InputStream
implements EndianInput {
    protected byte[] buffer;
    protected int position;
    protected int mark = 0;
    protected int count;
    private DataInputStream dis;
    private char[] charsBuffer;

    public EndianInputStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public EndianInputStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.position = offset;
        this.count = Math.min(offset + length, buffer.length);
        this.dis = new DataInputStream(this);
    }

    public synchronized int read() {
        return this.position < this.count ? this.buffer[this.position++] & 0xFF : -1;
    }

    public synchronized int read(byte[] buffer, int offset, int length) {
        if (this.position >= this.count) {
            return -1;
        }
        if (this.position + length > this.count) {
            length = this.count - this.position;
        }
        if (length <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, buffer, offset, length);
        this.position += length;
        return length;
    }

    public synchronized long skip(long n) {
        if ((long)this.position + n > (long)this.count) {
            n = this.count - this.position;
        }
        if (n < 0L) {
            return 0L;
        }
        this.position = (int)((long)this.position + n);
        return n;
    }

    public synchronized int available() {
        return this.count - this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int markpos) {
        this.mark = this.position;
    }

    public synchronized void reset() {
        this.position = this.mark;
    }

    public final void readFully(byte[] data) throws IOException {
        this.dis.readFully(data);
    }

    public final void readFully(byte[] data, int offset, int length) throws IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(data, offset, length);
    }

    public final int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return this.dis.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return this.dis.readChar();
    }

    public final int readInt() throws IOException {
        return this.dis.readInt();
    }

    public final long readLong() throws IOException {
        return this.dis.readLong();
    }

    public final float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public final double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(this.dis)).readLine();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public final char readHiLoChar() throws IOException {
        return this.readChar();
    }

    public final char readLoHiChar() throws IOException {
        int ch2 = this.read();
        int ch1 = this.read();
        if ((ch1 | ch2) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public final String readHiLoChars() throws IOException {
        short c;
        char[] buf = this.charsBuffer;
        if (buf == null) {
            buf = this.charsBuffer = new char[256];
        }
        int room = buf.length;
        int offset = 0;
        block3: while (true) {
            c = this.readShort();
            switch (c) {
                case -1: 
                case 0: {
                    break block3;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 256];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.charsBuffer, 0, buf, 0, offset);
                        this.charsBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block3;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    public final String readLoHiChars() throws IOException {
        short c;
        char[] buf = this.charsBuffer;
        if (buf == null) {
            buf = this.charsBuffer = new char[256];
        }
        int room = buf.length;
        int offset = 0;
        block3: while (true) {
            c = this.readLoHiShort();
            switch (c) {
                case -1: 
                case 0: {
                    break block3;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 256];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.charsBuffer, 0, buf, 0, offset);
                        this.charsBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block3;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    public final String readHiLoString() throws IOException {
        int offset;
        char[] buffer = new char[this.readInt() / 2];
        for (offset = 0; offset < buffer.length; ++offset) {
            buffer[offset] = (char)this.readShort();
        }
        if (offset == 0) {
            return null;
        }
        return String.copyValueOf(buffer, 0, offset);
    }

    private static final native String getString(byte[] var0, int var1);

    public final String readUString() throws IOException {
        int length = this.readLoHiInt();
        if (length == 0) {
            return new String();
        }
        if (this.position + length > this.count) {
            throw new EOFException();
        }
        String string = EndianInputStream.getString(this.buffer, this.position);
        this.position += length;
        return string;
    }

    public final int readHiLoInt() throws IOException {
        return this.readInt();
    }

    public final int readLoHiInt() throws IOException {
        int ch4 = this.read();
        int ch3 = this.read();
        int ch2 = this.read();
        int ch1 = this.read();
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final short readHiLoShort() throws IOException {
        return this.readShort();
    }

    public final short readLoHiShort() throws IOException {
        int ch2 = this.read();
        int ch1 = this.read();
        if ((ch1 | ch2) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final long readHiLoLong() throws IOException {
        return this.readLong();
    }

    public final long readLoHiLong() throws IOException {
        return ((long)this.readLoHiInt() << 32) + ((long)this.readLoHiInt() & 0xFFFFFFFFL);
    }

    public final void align32() throws IOException {
        this.position = this.position + 3 & 0xFFFFFFFC;
    }

    public final void unpad(int n) throws IOException {
    }
}

