/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;

public class Npp {
    private static String sepStr = "****************************************************************";
    private static HashMap s_envMap = new HashMap();
    private static boolean s_doSystemOut = true;
    private static PrintWriter s_fpw = null;
    private static final String DEFAULTFORMATSTRING = "%i%n %c%t.%m%t(%l) %s";
    private static String s_formatString = "%i%n %c%t.%m%t(%l) %s";
    private static int fullTruncPadSize = 20;
    private static int truncPadSize = 10;
    private static int prePadSize = 4;
    private static final int FILENAME = 0;
    private static final int CLASSNAME = 1;
    private static final int FULLCLASSNAME = 2;
    private static final int METHODNAME = 3;
    private static final int LINENUM = 4;
    private static final int ISPACE = 5;
    private static final int CALLNUM = 6;
    private static final int MESSAGE = 7;
    private static final int PI_SIZE = 8;

    private Npp() {
    }

    public static void out(String inMess) {
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        String[] sa = Npp.getPrintableItems(ste[1]);
        sa[7] = inMess;
        String pMess = Npp.formMessage(s_formatString, sa);
        Npp.do_out(pMess, false);
    }

    public static void nfout(String inMess) {
        Npp.do_out(inMess, false);
    }

    public static void fout(String formatString, String inMess) {
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        String[] sa = Npp.getPrintableItems(ste[1]);
        sa[7] = inMess;
        String pMess = Npp.formMessage(formatString, sa);
        Npp.do_out(pMess, false);
    }

    public static void prime(int spaceNum) {
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        String[] sa = Npp.getPrintableItems(ste[1]);
        String hashKey = sa[1] + sa[3];
        NppEnv m_env = (NppEnv)s_envMap.get(hashKey);
        if (m_env == null) {
            m_env = new NppEnv(1, spaceNum);
            s_envMap.put(hashKey, m_env);
        } else {
            ++m_env.callNum;
            if (spaceNum >= 0 && m_env.spaceNum != spaceNum) {
                m_env.setSpace(spaceNum);
            }
        }
    }

    public static void setFullTruncPadSize(int newFullTruncPad) {
        fullTruncPadSize = newFullTruncPad;
    }

    public static void setTruncPadSize(int newTruncPad) {
        truncPadSize = newTruncPad;
    }

    public static void setPrePadSize(int newPrePad) {
        prePadSize = newPrePad;
    }

    public static void dumpStack(int dumpDepth) {
        int endIndex;
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        String[] sa = Npp.getPrintableItems(ste[1]);
        sa[7] = "Dumping " + dumpDepth + " stack frames";
        String pMess = Npp.formMessage(s_formatString, sa);
        Npp.do_out(pMess, false);
        String preStr = Npp.formMessage("%i%n", sa);
        String tpad = "";
        int maxIndex = ste.length - 1;
        int n = endIndex = dumpDepth == 0 ? maxIndex : dumpDepth;
        for (int cIndex = 1; cIndex <= endIndex; ++cIndex) {
            String[] tsarr = Npp.getPrintableItems(ste[cIndex]);
            String tform = cIndex == maxIndex ? "%c.%m(%l) is the end of the Stack frame." : "%c.%m(%l) was called from";
            String tmess = Npp.formMessage(tform, tsarr);
            Npp.do_out(preStr + tpad + tmess, false);
            tpad = tpad + "  ";
        }
    }

    public static void setFormatString(String newFormatString) {
        s_formatString = newFormatString == null ? DEFAULTFORMATSTRING : newFormatString;
    }

    public static void setDoSystemOut(boolean doOut) {
        s_doSystemOut = doOut;
    }

    public static void startFile(String fileStr) {
        if (s_fpw == null) {
            Throwable terr = new Throwable();
            StackTraceElement[] ste = terr.getStackTrace();
            Npp.useThisFile(ste[1], fileStr);
        }
    }

    public static void changeFile(String fileStr) {
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        Npp.useThisFile(ste[1], fileStr);
    }

    private static void useThisFile(StackTraceElement ste, String fileStr) {
        String[] sa = Npp.getPrintableItems(ste);
        String stackStr = Npp.formMessage("Called from: %c.%m(%l)", sa);
        Date now = new Date();
        if (fileStr == null) {
            Npp.do_out(sepStr, true);
            Npp.do_out(now.toString(), true);
            Npp.do_out(stackStr, true);
            Npp.do_out("Error Npp.startFile() cannot use \"null\"", true);
            Npp.do_out(sepStr, true);
            return;
        }
        if (s_fpw != null) {
            Npp.stopFile();
        }
        String lowerFile = fileStr.toLowerCase();
        try {
            File openFile = new File(lowerFile);
            FileWriter fileWriter = new FileWriter(openFile, true);
            s_fpw = new PrintWriter(fileWriter);
            Npp.do_out(sepStr, false);
            Npp.do_out(now.toString(), false);
            Npp.do_out(stackStr, false);
            Npp.do_out("File opened for append logging", false);
            Npp.do_out(sepStr, false);
        }
        catch (IOException ioe) {
            String emess = "IOException Npp.useThisFile() trying to open " + lowerFile + " - " + ioe.toString();
            Npp.do_out(sepStr, true);
            Npp.do_out(now.toString(), true);
            Npp.do_out(stackStr, true);
            Npp.do_out(emess, true);
            Npp.do_out(sepStr, true);
        }
    }

    public static void stopFile() {
        Throwable terr = new Throwable();
        StackTraceElement[] ste = terr.getStackTrace();
        String[] sa = Npp.getPrintableItems(ste[1]);
        String stackStr = Npp.formMessage("Called from: %c.%m(%l)", sa);
        Date now = new Date();
        if (s_fpw == null) {
            Npp.do_out(sepStr, true);
            Npp.do_out(now.toString(), true);
            Npp.do_out(stackStr, true);
            Npp.do_out("WARNING:  cannot stop file logging because it is not open", true);
            Npp.do_out(sepStr, true);
            return;
        }
        Npp.do_out(sepStr, true);
        Npp.do_out(now.toString(), true);
        Npp.do_out(stackStr, true);
        Npp.do_out("Closing file for logging", true);
        Npp.do_out(sepStr, true);
        s_fpw.flush();
        s_fpw.close();
        s_fpw = null;
    }

    private static void do_out(String outMess, boolean forceSystemOut) {
        if (s_doSystemOut || forceSystemOut) {
            System.out.println(outMess);
        }
        if (s_fpw != null) {
            s_fpw.println(outMess);
            s_fpw.flush();
        }
    }

    private static String formMessage(String formatString, String[] sa) {
        String formed = formatString;
        formed = Npp.replaceTruncPadPattern(formed, "%f%t", sa[0]);
        formed = Npp.replacePrePadPattern(formed, "%p%f", sa[0]);
        formed = Npp.replacePattern(formed, "%f", sa[0]);
        formed = Npp.replaceTruncPadPattern(formed, "%c%t", sa[1]);
        formed = Npp.replacePrePadPattern(formed, "%p%c", sa[1]);
        formed = Npp.replacePattern(formed, "%c", sa[1]);
        formed = Npp.replaceTruncPadPattern(formed, "%C%t", sa[2]);
        formed = Npp.replacePrePadPattern(formed, "%p%C", sa[2]);
        formed = Npp.replacePattern(formed, "%C", sa[2]);
        formed = Npp.replaceTruncPadPattern(formed, "%m%t", sa[3]);
        formed = Npp.replacePrePadPattern(formed, "%p%m", sa[3]);
        formed = Npp.replacePattern(formed, "%m", sa[3]);
        formed = Npp.replaceTruncPadPattern(formed, "%l%t", sa[4]);
        formed = Npp.replacePrePadPattern(formed, "%p%l", sa[4]);
        formed = Npp.replacePattern(formed, "%l", sa[4]);
        formed = Npp.replaceTruncPadPattern(formed, "%i%t", sa[5]);
        formed = Npp.replacePrePadPattern(formed, "%p%i", sa[5]);
        formed = Npp.replacePattern(formed, "%i", sa[5]);
        formed = Npp.replaceTruncPadPattern(formed, "%n%t", sa[6]);
        formed = Npp.replacePrePadPattern(formed, "%p%n", sa[6]);
        formed = Npp.replacePattern(formed, "%n", sa[6]);
        formed = Npp.replaceTruncPadPattern(formed, "%s%t", sa[7]);
        formed = Npp.replacePrePadPattern(formed, "%p%s", sa[7]);
        int ftp = (formed = Npp.replacePattern(formed, "%s", sa[7])).indexOf("%T");
        if (ftp >= 0) {
            String tmps1 = formed.substring(0, ftp);
            String s1 = Npp.getTruncPadString(tmps1, fullTruncPadSize);
            String s2 = formed.substring(ftp + 2);
            formed = s1 + s2;
        }
        return formed;
    }

    private static String replacePattern(String src, String pattern, String replacement) {
        StringBuffer newsb = new StringBuffer(src.length() + replacement.length());
        boolean iHaveReplaceToDo = replacement.length() > 0;
        int iPatternLen = pattern.length();
        int iCopyStart = 0;
        int iPatternPos = src.indexOf(pattern);
        while (iPatternPos != -1) {
            newsb.append(src.substring(iCopyStart, iPatternPos));
            if (iHaveReplaceToDo) {
                newsb.append(replacement);
            }
            iCopyStart = iPatternPos + iPatternLen;
            iPatternPos = src.indexOf(pattern, iCopyStart);
        }
        newsb.append(src.substring(iCopyStart));
        return newsb.toString();
    }

    private static String replacePrePadPattern(String src, String pattern, String replacement) {
        String retSrc = src;
        if (src.indexOf(pattern) >= 0) {
            String newRep = Npp.getPrePadString(replacement, prePadSize);
            retSrc = Npp.replacePattern(src, pattern, newRep);
        }
        return retSrc;
    }

    private static String getPrePadString(String srcToPrePad, int pLen) {
        String retSrc;
        int srcLen = srcToPrePad.length();
        if (srcLen < pLen) {
            StringBuffer tbuf = new StringBuffer(pLen);
            for (int padsize = pLen - srcLen; padsize > 0; --padsize) {
                tbuf.append(' ');
            }
            tbuf.append(srcToPrePad);
            retSrc = tbuf.toString();
        } else {
            retSrc = srcToPrePad;
        }
        return retSrc;
    }

    private static String replaceTruncPadPattern(String src, String pattern, String replacement) {
        String retSrc = src;
        if (src.indexOf(pattern) >= 0) {
            String newRep = Npp.getTruncPadString(replacement, truncPadSize);
            retSrc = Npp.replacePattern(src, pattern, newRep);
        }
        return retSrc;
    }

    private static String getTruncPadString(String srcToTruncPad, int tpLen) {
        String retSrc;
        int srcLen = srcToTruncPad.length();
        if (srcLen < tpLen) {
            StringBuffer tbuf = new StringBuffer(tpLen);
            tbuf.append(srcToTruncPad);
            for (int padsize = tpLen - srcLen; padsize > 0; --padsize) {
                tbuf.append('.');
            }
            retSrc = tbuf.toString();
        } else {
            retSrc = srcLen > tpLen ? srcToTruncPad.substring(0, tpLen) : srcToTruncPad;
        }
        return retSrc;
    }

    private static String[] getPrintableItems(StackTraceElement ste) {
        String[] rs = new String[8];
        rs[0] = ste.getFileName();
        int ii = rs[0].indexOf(".java");
        if (ii > 0) {
            rs[0] = rs[0].substring(0, ii);
        }
        rs[2] = ste.getClassName();
        ii = rs[2].lastIndexOf(46);
        rs[1] = ii > -1 && ii < rs[2].length() - 1 ? rs[2].substring(ii + 1) : rs[2];
        rs[3] = ste.getMethodName();
        rs[4] = Integer.toString(ste.getLineNumber());
        String hashKey = rs[1] + rs[3];
        NppEnv m_env = (NppEnv)s_envMap.get(hashKey);
        if (m_env == null) {
            rs[5] = "";
            rs[6] = "?";
        } else {
            rs[5] = m_env.ispace;
            rs[6] = Integer.toString(m_env.callNum);
        }
        rs[7] = "?";
        return rs;
    }

    static class NppEnv {
        public int callNum = 0;
        public int spaceNum = 0;
        public String ispace = "";

        public NppEnv(int initCallNum, int initSpaceNum) {
            this.callNum = initCallNum;
            this.setSpace(initSpaceNum);
        }

        public void setSpace(int initSpaceNum) {
            int n = this.spaceNum = initSpaceNum < 0 ? 0 : initSpaceNum;
            while (initSpaceNum-- > 0) {
                this.ispace = this.ispace + " ";
            }
        }
    }
}

