/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ldap.jndi.LDAPNamespaceImpl;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;

public class AdminNamespaceFactory {
    private static Class NDSNamespaceImplClass = null;
    public static final int LDAP_NAMESPACE = 1;
    public static final int NDS_NAMESPACE = 2;
    private static SimpleSPIException nsSpiException = null;

    public static AdminNamespace createAdminNamespace(int NamespaceType) throws SPIException {
        try {
            AdminNamespace ans;
            switch (NamespaceType) {
                case 1: {
                    ans = new LDAPNamespaceImpl();
                    break;
                }
                case 2: {
                    if (NDSNamespaceImplClass == null) {
                        NDSNamespaceImplClass = NDSNamespaceImpl.class;
                    }
                    ans = new NDSNamespaceImpl(null);
                    break;
                }
                default: {
                    throw new Exception("Invalid type");
                }
            }
            return ans;
        }
        catch (Throwable tex) {
            throw AdminNamespaceFactory.resolveSPIException(tex);
        }
    }

    public static String getNDSTreeNameFromID(String treeAddressID) throws SPIException {
        try {
            if (NDSNamespaceImplClass == null) {
                NDSNamespaceImplClass = NDSNamespaceImpl.class;
            }
            String rStr = NDSNamespaceImpl.getTreeNameFromID(treeAddressID);
            return rStr;
        }
        catch (Throwable tex) {
            throw AdminNamespaceFactory.resolveSPIException(tex);
        }
    }

    public static String getNDSConnectedAddressFromID(String treeAddressID) throws SPIException {
        try {
            if (NDSNamespaceImplClass == null) {
                NDSNamespaceImplClass = NDSNamespaceImpl.class;
            }
            return NDSNamespaceImpl.getConnectedAddressFromID(treeAddressID);
        }
        catch (Throwable tex) {
            throw AdminNamespaceFactory.resolveSPIException(tex);
        }
    }

    public static void initializeSecureNCPTrees(boolean IWillNotUseThisMethod, NDSNamespace ndsns, String[] treeList) throws SPIException {
        if (!(ndsns instanceof NDSNamespaceImpl)) {
            throw nsSpiException.newException("spi26", "invalid namespace implementation");
        }
        ((NDSNamespaceImpl)ndsns).initializeSecureNCPTrees(IWillNotUseThisMethod, treeList);
    }

    private static SPIException resolveSPIException(Throwable tex) {
        if (nsSpiException == null) {
            nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");
        }
        SPIException spie = null;
        if (tex instanceof SPIException) {
            spie = (SPIException)tex;
        } else {
            String xtraMsg = tex instanceof RuntimeException || tex instanceof Error ? tex.toString() : tex.getLocalizedMessage();
            spie = nsSpiException.newException("spi25", xtraMsg);
        }
        return spie;
    }
}

