/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.BooleanValue;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class BooleanStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    private static final int BAD_TOSTRING_OBJ = 3;
    private static final int BAD_BOUNDS_OBJ = 4;

    public boolean canCreateValue(Object obj) {
        return obj instanceof Boolean || obj instanceof String;
    }

    public ValueComponent createValueComponent() {
        return new BooleanValue(this.getSyntax(), new Boolean(true));
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof Boolean) {
            return new BooleanValue(this.getSyntax(), (Boolean)obj);
        }
        if (obj instanceof String) {
            return new BooleanValue(this.getSyntax(), new Boolean((String)obj));
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof BooleanValue)) {
            throw new AdminError(1, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return false;
        }
        BooleanValue b1 = (BooleanValue)obj1;
        BooleanValue b2 = (BooleanValue)obj2;
        return b1.getValue() == b2.getValue();
    }

    public long compare(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof BooleanValue) && obj2 instanceof BooleanValue) {
            throw new AdminError(2, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return obj1.getSyntax().getId() - obj2.getSyntax().getId();
        }
        BooleanValue v1 = (BooleanValue)obj1;
        BooleanValue v2 = (BooleanValue)obj2;
        boolean b1 = v1.getValue();
        boolean b2 = v2.getValue();
        if (!b1 && b2) {
            return -1L;
        }
        if (b1 && !b2) {
            return 1L;
        }
        return 0L;
    }

    public String toString(ValueComponent obj) {
        if (obj instanceof BooleanValue) {
            return ((BooleanValue)obj).getBooleanValue().toString();
        }
        throw new AdminError(3, this.getClass());
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof BooleanValue) {
            return false;
        }
        throw new AdminError(4, this.getClass());
    }
}

