/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.Strategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ListStrategy
implements Strategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    private static final int BAD_BOUNDS_OBJ = 3;
    protected static final int TOSTRING_LIMIT = 256;

    public Vector getAddableSyntaxes(ValueList list) {
        return new Vector();
    }

    public boolean canInsertComponent(ValueList list, ValueComponent comp) {
        return false;
    }

    public boolean canRemoveComponent(ValueList list, ValueComponent comp) {
        return false;
    }

    public String toString(ValueComponent component) {
        if (!(component instanceof ValueList)) {
            return component.toString();
        }
        ValueList list = (ValueList)component;
        StringBuffer sbuf = new StringBuffer();
        Enumeration e = list.getComponents();
        while (e.hasMoreElements()) {
            sbuf.append(e.nextElement().toString());
            if (sbuf.length() < 256) continue;
            sbuf.setLength(256);
            break;
        }
        return new String(sbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(ValueComponent component1, ValueComponent component2) {
        if (!(component1 instanceof ValueList)) {
            throw new AdminError(1, this.getClass());
        }
        if (component1.getSyntax() != component2.getSyntax()) {
            return false;
        }
        ValueList list1 = (ValueList)component1;
        ValueList list2 = (ValueList)component2;
        ValueList valueList = list1;
        synchronized (valueList) {
            ValueList valueList2 = list2;
            synchronized (valueList2) {
                if (list1.getComponentCount() != list2.getComponentCount()) {
                    return false;
                }
                Enumeration enum1 = list1.getComponents();
                Enumeration enum2 = list2.getComponents();
                while (enum1.hasMoreElements()) {
                    ValueComponent comp2;
                    ValueComponent comp1 = (ValueComponent)enum1.nextElement();
                    if (comp1.equals(comp2 = (ValueComponent)enum2.nextElement())) continue;
                    return false;
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long compare(ValueComponent component1, ValueComponent component2) {
        if (component1 instanceof ValueList && component2 instanceof ValueList) {
            throw new AdminError(2, this.getClass());
        }
        if (component1.getSyntax() != component2.getSyntax()) {
            return component1.getSyntax().getId() - component2.getSyntax().getId();
        }
        ValueList list1 = (ValueList)component1;
        ValueList list2 = (ValueList)component2;
        ValueComponent valueComponent = component1;
        synchronized (valueComponent) {
            ValueComponent valueComponent2 = component2;
            synchronized (valueComponent2) {
                Enumeration enum1 = list1.getComponents();
                Enumeration enum2 = list2.getComponents();
                while (enum1.hasMoreElements() && enum2.hasMoreElements()) {
                    ValueComponent comp2;
                    ValueComponent comp1 = (ValueComponent)enum1.nextElement();
                    long c = comp1.compareTo(comp2 = (ValueComponent)enum2.nextElement());
                    if (c == 0L) continue;
                    return c;
                }
                return list1.getComponentCount() - list2.getComponentCount();
            }
        }
    }

    public abstract Object createFacade(ValueComponent var1) throws IncompatibleComponentException;

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof ValueList) {
            return false;
        }
        throw new AdminError(3, this.getClass());
    }
}

