/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class StringStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_CI_EQUAL_OBJ = 2;
    private static final int BAD_COMPARE_OBJ = 3;
    private static final int WITHIN_BOUNDS = 4;
    private static final int BAD_TOSTRING_OBJ = 5;

    public boolean equals(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof StringValue)) {
            throw new AdminError(1, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return false;
        }
        StringValue v1 = (StringValue)obj1;
        StringValue v2 = (StringValue)obj2;
        return v1.getValue().equals(v2.getValue());
    }

    protected final boolean equalsIgnoreCase(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof StringValue)) {
            throw new AdminError(2, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return false;
        }
        StringValue v1 = (StringValue)obj1;
        StringValue v2 = (StringValue)obj2;
        return v1.getValue().equalsIgnoreCase(v2.getValue());
    }

    public long compare(ValueComponent obj1, ValueComponent obj2) {
        if (!(obj1 instanceof StringValue) || !(obj2 instanceof StringValue)) {
            throw new AdminError(3, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return obj1.getSyntax().getId() - obj2.getSyntax().getId();
        }
        StringValue v1 = (StringValue)obj1;
        StringValue v2 = (StringValue)obj2;
        return v1.getValue().compareTo(v2.getValue());
    }

    public String toString(ValueComponent obj) {
        if (obj instanceof StringValue) {
            return ((StringValue)obj).getValue().toString();
        }
        throw new AdminError(5, this.getClass());
    }

    public boolean canCreateValue(Object obj) {
        if (obj instanceof String) {
            return this.isLegalString((String)obj);
        }
        return false;
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        String str;
        if (obj instanceof String && this.isLegalString(str = (String)obj)) {
            return new StringValue(this.getSyntax(), str);
        }
        throw new ComponentCreationException();
    }

    public ValueComponent createValueComponent() {
        return new StringValue(this.getSyntax(), "");
    }

    public boolean isLegalString(String s) {
        return true;
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof StringValue) {
            StringValue val = (StringValue)comp;
            long i = val.getValue().length();
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(4, this.getClass());
    }

    protected boolean stringIsValid(String validChars, String s) {
        int len = s.length();
        while (len-- > 0) {
            if (validChars.indexOf(s.charAt(len)) != -1) continue;
            return false;
        }
        return true;
    }
}

