/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public abstract class TimeStrategy
implements ValueStrategy {
    private static final int BAD_OBJ = 1;
    protected static final int WITHIN_BOUNDS = 3;

    public boolean equals(ValueComponent component1, ValueComponent component2) {
        return this.compare(component1, component2) == 0L;
    }

    public long compare(ValueComponent component1, ValueComponent component2) {
        if (!(component1 instanceof DateValue)) {
            throw new AdminError(1, this.getClass());
        }
        if (component1.getSyntax() != component2.getSyntax()) {
            return component1.getSyntax().getId() - component2.getSyntax().getId();
        }
        DateValue v1 = (DateValue)component1;
        DateValue v2 = (DateValue)component2;
        return v1.getMillis() - v2.getMillis();
    }

    public boolean canCreateValue(Object obj) {
        if (obj instanceof Number) {
            long v = ((Number)obj).longValue();
            return v >= 0L;
        }
        return obj instanceof Date || obj instanceof String;
    }

    public ValueComponent createValueComponent() {
        return new DateValue(this.getSyntax(), new Date());
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof Date) {
            return new DateValue(this.getSyntax(), (Date)obj);
        }
        if (obj instanceof Number) {
            long v = ((Number)obj).longValue();
            if (v >= 0L) {
                return new DateValue(this.getSyntax(), v);
            }
        } else if (obj instanceof String) {
            try {
                Date d = DateFormat.getDateInstance().parse((String)obj);
                return new DateValue(this.getSyntax(), d);
            }
            catch (ParseException x) {
                throw new ComponentCreationException();
            }
        }
        throw new ComponentCreationException();
    }

    public String toString(ValueComponent obj) {
        if (obj instanceof DateValue) {
            Date d = ((DateValue)obj).getValue();
            return d.toString();
        }
        return obj.toString();
    }

    public abstract Syntax getSyntax();

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof DateValue) {
            DateValue val = (DateValue)comp;
            long i = val.getMillis();
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(3, this.getClass());
    }
}

