/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import java.util.Enumeration;
import java.util.Vector;

final class CaseIgnoreListStrategy
extends ListStrategy {
    private static final int WITHIN_BOUNDS = 1;

    CaseIgnoreListStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList v = new ValueList(LDAPSyntax.SYN_CI_LIST);
        v.initList(new StringValue(LDAPSyntax.SYN_CI_STRING, ""));
        return v;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        ValueList v = new ValueList(LDAPSyntax.SYN_CI_LIST);
        if (paramObj instanceof String) {
            String str = (String)paramObj;
            int startIndex = 0;
            int delim = 0;
            while (delim >= 0) {
                delim = str.indexOf(36, startIndex);
                if (delim >= 0) {
                    v.initList(new StringValue(LDAPSyntax.SYN_CI_STRING, str.substring(startIndex, delim)));
                } else {
                    v.initList(new StringValue(LDAPSyntax.SYN_CI_STRING, str.substring(startIndex)));
                }
                startIndex = delim + 1;
            }
            return v;
        }
        if (paramObj instanceof Vector) {
            Vector vec = (Vector)paramObj;
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                if (!(comp instanceof String)) continue;
                v.initList(new StringValue(LDAPSyntax.SYN_CI_STRING, (String)comp));
            }
            return v;
        }
        throw new ComponentCreationException();
    }

    public boolean canInsertComponent(ValueList list, ValueComponent comp) {
        if (comp.getSyntax() == LDAPSyntax.SYN_CI_STRING) {
            return !list.contains(comp);
        }
        return false;
    }

    public boolean canRemoveComponent(ValueList list, ValueComponent comp) {
        return list.contains(comp);
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        int i;
        ValueList vl;
        if (comp instanceof ValueList && (vl = (ValueList)comp).getSyntax() == LDAPSyntax.SYN_CI_LIST && (i = 0) < vl.getComponentCount()) {
            StringValue v = (StringValue)vl.getElementAt(i);
            return v.isWithinBounds(lowerBound, upperBound);
        }
        throw new AdminError(1, this.getClass());
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            int count = list.getComponentCount();
            if (count == 0) {
                return new String("");
            }
            String str = list.getElementAt(0).toString();
            for (int i = 1; i < count; ++i) {
                str = str + "$" + list.getElementAt(i).toString();
            }
            return str;
        }
        return vc.toString();
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new CaseIgnoreListFacade((ValueList)comp);
    }
}

