/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.FaxNumberFacade;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

final class FaxNumberStrategy
extends ListStrategy {
    private HashMap paramTable = new HashMap(7);

    public FaxNumberStrategy() {
        this.paramTable.put("twoDimensional", "");
        this.paramTable.put("fineResolution", "");
        this.paramTable.put("unlimitedLength", "");
        this.paramTable.put("b4Length", "");
        this.paramTable.put("a3Width", "");
        this.paramTable.put("b4Width", "");
        this.paramTable.put("uncompressed", "");
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_FAX_NUMBER);
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_PRINTABLE_STRING.createValueComponent());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        ValueList list = new ValueList(LDAPSyntax.SYN_FAX_NUMBER);
        Long bits = new Long(0L);
        String phone = null;
        if (paramObj instanceof Vector) {
            Vector compList = (Vector)paramObj;
            if (compList.size() != 2) {
                throw new ComponentCreationException();
            }
            Vector vector = compList;
            synchronized (vector) {
                Enumeration e = compList.elements();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    if (comp instanceof Long) {
                        bits = (Long)comp;
                        continue;
                    }
                    if (!(comp instanceof String)) continue;
                    phone = (String)comp;
                }
            }
        } else if (paramObj instanceof String) {
            phone = (String)paramObj;
        } else {
            throw new ComponentCreationException();
        }
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(bits));
        list.initList(LDAPSyntax.SYN_PRINTABLE_STRING.createValueComponent(phone));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new FaxNumberFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            return list.getElementAt(1).toString();
        }
        return vc.toString();
    }
}

