/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.TimeStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ldap.LDAPSyntax;
import java.util.Date;

final class GeneralizedTimeStrategy
extends TimeStrategy {
    GeneralizedTimeStrategy() {
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        long v = 0L;
        if (obj instanceof String) {
            v = DateValue.generalizedTimeToMs((String)obj);
        } else if (obj instanceof Number) {
            v = ((Number)obj).longValue() * 1000L;
        } else if (obj instanceof Date) {
            v = ((Date)obj).getTime();
        } else {
            throw new ComponentCreationException();
        }
        return super.createValueComponent(new Long(v));
    }

    public Syntax getSyntax() {
        return LDAPSyntax.SYN_GENERALIZEDTIME;
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof DateValue) {
            DateValue val = (DateValue)comp;
            long i = val.getMillis() / 1000L;
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(3, this.getClass());
    }
}

