/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPClassFlags;

public final class LDAPClassDefinition
extends ClassDefinition {
    private LDAPClassFlags classFlags;
    private String oid;
    private String NDAPName;

    public LDAPClassDefinition(String name, String[] aliasArray, LDAPClassFlags flags, String[] classContainmentNames, String[] superClassNames, AttributeDefinition[] mandatoryAttributes, AttributeDefinition[] namingAttributes, AttributeDefinition[] optionalAttributes, String oid, String NDAPName, SchemaDefinition schemaDef) {
        super(name, aliasArray, classContainmentNames, superClassNames, mandatoryAttributes, namingAttributes, optionalAttributes, flags.isFlagSet(4), flags.isFlagSet(1), flags.isFlagSet(8), flags.isFlagSet(2), schemaDef);
        this.classFlags = (LDAPClassFlags)flags.clone();
        this.oid = oid;
        this.NDAPName = NDAPName;
    }

    public LDAPClassFlags getClassFlags() {
        return (LDAPClassFlags)this.classFlags.clone();
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String modifiedOID) {
        this.oid = modifiedOID;
    }

    public String getNDAPName() {
        return this.NDAPName;
    }

    public AttributeDefinition[] getMandatoryAttributes() {
        AttributeDefinition[] attrDefs = this.mandatoryAttributeTable.values().toArray(new LDAPAttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getOptionalAttributes() {
        AttributeDefinition[] attrDefs = this.optionalAttributeTable.values().toArray(new LDAPAttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getNamingAttributes() {
        AttributeDefinition[] attrDefs = this.namingAttributeTable.values().toArray(new LDAPAttributeDefinition[0]);
        return attrDefs;
    }

    void setContainerFlag(boolean iscontainer) {
        if (iscontainer) {
            this.classFlags.setFlag(4);
            this.container = true;
        } else {
            this.classFlags.clearFlag(4);
            this.container = false;
        }
    }
}

